/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util.rb_trees;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.uima.internal.util.BinaryTree;
import org.apache.uima.internal.util.rb_trees.RBTNode;

public class RedBlackTree<T>
implements Iterable<T> {
    RBTNode<T> root = null;
    int size = 0;

    public final int size() {
        return this.size;
    }

    public final void clear() {
        this.root = null;
        this.size = 0;
    }

    public final boolean containsKey(int key) {
        return RBTNode.find(this.root, key) != null;
    }

    public final boolean containsValue(T o) {
        Iterator<T> it = this.iterator();
        while (it.hasNext()) {
            if (o != it.next()) continue;
            return true;
        }
        return false;
    }

    public final boolean put(int key, T el) {
        if (this.put(new RBTNode<T>(key, el))) {
            ++this.size;
            return true;
        }
        return false;
    }

    public final T remove(int key) {
        RBTNode<T> node = RBTNode.find(this.root, key);
        T ret = null;
        if (node != null) {
            ret = node.element;
            --this.size;
            RBTNode.delete(this, node);
        }
        return ret;
    }

    public final T get(int key) {
        if (this.root == null) {
            return null;
        }
        RBTNode<T> node = RBTNode.find(this.root, key);
        if (node == null) {
            return null;
        }
        return node.element;
    }

    public final boolean isEmpty() {
        return this.root == null;
    }

    public final int[] keySet() {
        int[] set = new int[this.size];
        if (this.root != null) {
            this.root.keys(0, set);
        }
        return set;
    }

    private final boolean put(RBTNode<T> node) {
        return RBTNode.insert(this, node);
    }

    public final T getFirst() {
        return this.getFirstNode().element;
    }

    private final RBTNode<T> getFirstNode() {
        if (this.root == null) {
            return null;
        }
        RBTNode<T> x = this.root;
        while (x.left != null) {
            x = x.left;
        }
        return x;
    }

    @Override
    public Iterator<T> iterator() {
        return new RBTIterator(this);
    }

    public BinaryTree getBinaryTree() {
        if (this.root == null) {
            return null;
        }
        BinaryTree tree = new BinaryTree();
        this.root.getBinaryTree(tree);
        return tree;
    }

    public void printKeys() {
        if (this.root != null) {
            this.root.printKeys(0);
        }
        System.out.println("Size: " + this.size);
    }

    public static void main(String[] args) {
        int i;
        RedBlackTree<String> tree = new RedBlackTree<String>();
        tree.put(1, "a");
        tree.printKeys();
        System.out.println("");
        tree.put(2, "b");
        tree.printKeys();
        System.out.println("");
        tree.put(3, "c");
        tree.printKeys();
        System.out.println("");
        tree.put(4, "d");
        tree.printKeys();
        System.out.println("");
        tree.put(5, "e");
        tree.printKeys();
        System.out.println("");
        tree.put(6, "f");
        tree.printKeys();
        System.out.println("");
        tree.put(7, "g");
        tree.printKeys();
        System.out.println("");
        tree.put(8, "h");
        tree.printKeys();
        System.out.println("");
        tree.put(9, "i");
        tree.printKeys();
        System.out.println("");
        tree.put(10, "j");
        tree.printKeys();
        System.out.println("");
        tree.put(3, "k");
        tree.printKeys();
        System.out.println("");
        int[] a = tree.keySet();
        System.out.print('[');
        for (i = 0; i < a.length; ++i) {
            if (i != 0) {
                System.out.print(',');
            }
            System.out.print(a[i]);
        }
        System.out.println(']');
        tree.remove(1);
        tree.printKeys();
        System.out.println("");
        tree.remove(2);
        tree.printKeys();
        System.out.println("");
        tree.remove(3);
        tree.printKeys();
        System.out.println("");
        tree.remove(4);
        tree.printKeys();
        System.out.println("");
        tree.remove(5);
        tree.printKeys();
        System.out.println("");
        tree.remove(6);
        tree.printKeys();
        System.out.println("");
        a = tree.keySet();
        System.out.print('[');
        for (i = 0; i < a.length; ++i) {
            if (i != 0) {
                System.out.print(',');
            }
            System.out.print(a[i]);
        }
        System.out.println(']');
    }

    private static class RBTIterator<T>
    implements Iterator<T> {
        RBTNode<T> current;

        RBTIterator(RedBlackTree<T> tree) {
            this.current = ((RedBlackTree)tree).getFirstNode();
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public T next() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            Object ret = this.current.element;
            this.current = this.current.successor();
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

