/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.validators;

import java.math.BigInteger;
import org.exolab.castor.xml.TypeValidator;
import org.exolab.castor.xml.ValidationContext;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.validators.PatternValidator;

public class BigIntegerValidator
extends PatternValidator
implements TypeValidator {
    private boolean useMin = false;
    private boolean useMax = false;
    private boolean useFixed = false;
    private BigInteger min = BigInteger.valueOf(0L);
    private BigInteger max = BigInteger.valueOf(0L);
    private BigInteger fixed = BigInteger.valueOf(0L);

    public void clearFixed() {
        this.useFixed = false;
    }

    public void clearMax() {
        this.useMax = false;
    }

    public void clearMin() {
        this.useMin = false;
    }

    public BigInteger getFixed() {
        if (this.useFixed) {
            return this.fixed;
        }
        return null;
    }

    public BigInteger getMaxInclusive() {
        if (this.useMax) {
            return this.max;
        }
        return null;
    }

    public BigInteger getMinInclusive() {
        if (this.useMin) {
            return this.min;
        }
        return null;
    }

    public boolean hasFixed() {
        return this.useFixed;
    }

    public void setFixed(BigInteger fixedValue) {
        this.useFixed = true;
        this.fixed = fixedValue;
    }

    public void setMinExclusive(BigInteger minValue) {
        this.useMin = true;
        this.min = minValue.add(BigInteger.valueOf(1L));
    }

    public void setMinInclusive(BigInteger minValue) {
        this.useMin = true;
        this.min = minValue;
    }

    public void setMaxExclusive(BigInteger maxValue) {
        this.useMax = true;
        this.max = maxValue.subtract(BigInteger.valueOf(-1L));
    }

    public void setMaxInclusive(BigInteger maxValue) {
        this.useMax = true;
        this.max = maxValue;
    }

    public void validate(BigInteger value, ValidationContext context) throws ValidationException {
        if (this.useFixed) {
            if (value != this.fixed) {
                String err = value + " is not equal to the fixed value of " + this.fixed;
                throw new ValidationException(err);
            }
            return;
        }
        if (this.useMin && value.compareTo(this.min) == -1) {
            String err = value + " is less than the minimum allowable ";
            err = err + "value of " + this.min;
            throw new ValidationException(err);
        }
        if (this.useMax && value.compareTo(this.max) == 1) {
            String err = value + " is greater than the maximum allowable ";
            err = err + "value of " + this.max;
            throw new ValidationException(err);
        }
        if (this.hasPattern()) {
            super.validate(value.toString(), context);
        }
    }

    public void validate(Object object) throws ValidationException {
        this.validate(object, (ValidationContext)null);
    }

    public void validate(Object object, ValidationContext context) throws ValidationException {
        if (object == null) {
            String err = "BigIntegerValidator cannot validate a null object.";
            throw new ValidationException(err);
        }
        BigInteger value = BigInteger.valueOf(0L);
        try {
            value = (BigInteger)object;
        }
        catch (Exception ex) {
            String err = "Expecting a BigInteger, received instead: ";
            err = err + object.getClass().getName();
            throw new ValidationException(err);
        }
        this.validate(value, context);
    }
}

