/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import java.util.Objects;
import org.apache.datasketches.kll.KllDoublesSketch;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllMemoryValidate;
import org.apache.datasketches.kll.KllPreambleUtil;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.Memory;

final class KllHeapDoublesSketch
extends KllDoublesSketch {
    private final int k_;
    private final int m_;
    private long n_;
    private int minK_;
    private boolean isLevelZeroSorted_;
    private double minDoubleItem_;
    private double maxDoubleItem_;
    private double[] doubleItems_;

    KllHeapDoublesSketch(int k, int m) {
        super(null, null);
        KllHelper.checkM(m);
        KllHelper.checkK(k, m);
        this.k_ = k;
        this.m_ = m;
        this.n_ = 0L;
        this.minK_ = k;
        this.isLevelZeroSorted_ = false;
        this.levelsArr = new int[]{k, k};
        this.minDoubleItem_ = Double.NaN;
        this.maxDoubleItem_ = Double.NaN;
        this.doubleItems_ = new double[k];
    }

    static KllHeapDoublesSketch heapifyImpl(Memory srcMem) {
        Objects.requireNonNull(srcMem, "Parameter 'srcMem' must not be null");
        KllMemoryValidate memVal = new KllMemoryValidate(srcMem, KllSketch.SketchType.DOUBLES_SKETCH);
        return new KllHeapDoublesSketch(srcMem, memVal);
    }

    private KllHeapDoublesSketch(Memory srcMem, KllMemoryValidate memValidate) {
        super(null, null);
        boolean serialVersionUpdatable;
        this.k_ = memValidate.k;
        this.m_ = memValidate.m;
        this.n_ = memValidate.n;
        this.minK_ = memValidate.minK;
        this.levelsArr = memValidate.levelsArr;
        this.isLevelZeroSorted_ = memValidate.level0Sorted;
        boolean bl = serialVersionUpdatable = KllPreambleUtil.getMemorySerVer(srcMem) == 3;
        if (memValidate.empty && !serialVersionUpdatable) {
            this.minDoubleItem_ = Double.NaN;
            this.maxDoubleItem_ = Double.NaN;
            this.doubleItems_ = new double[this.k_];
        } else if (memValidate.singleItem && !serialVersionUpdatable) {
            double item;
            this.minDoubleItem_ = this.maxDoubleItem_ = (item = srcMem.getDouble(8L));
            this.doubleItems_ = new double[this.k_];
            this.doubleItems_[this.k_ - 1] = item;
        } else {
            int offsetBytes = 20;
            this.minDoubleItem_ = srcMem.getDouble((long)(offsetBytes += serialVersionUpdatable ? this.levelsArr.length * 4 : (this.levelsArr.length - 1) * 4));
            this.maxDoubleItem_ = srcMem.getDouble((long)(offsetBytes += 8));
            offsetBytes += 8;
            int capacityItems = this.levelsArr[this.getNumLevels()];
            int retainedItems = capacityItems - this.levelsArr[0];
            this.doubleItems_ = new double[capacityItems];
            int shift = this.levelsArr[0];
            if (serialVersionUpdatable) {
                srcMem.getDoubleArray((long)(offsetBytes += shift * 8), this.doubleItems_, shift, retainedItems);
            } else {
                srcMem.getDoubleArray((long)offsetBytes, this.doubleItems_, shift, retainedItems);
            }
        }
    }

    @Override
    public int getK() {
        return this.k_;
    }

    @Override
    public long getN() {
        return this.n_;
    }

    @Override
    double[] getDoubleItemsArray() {
        return this.doubleItems_;
    }

    @Override
    double getDoubleSingleItem() {
        if (this.n_ != 1L) {
            KllSketch.Error.kllSketchThrow(KllSketch.Error.NOT_SINGLE_ITEM);
            return Double.NaN;
        }
        return this.doubleItems_[this.k_ - 1];
    }

    @Override
    int getM() {
        return this.m_;
    }

    @Override
    double getMaxDoubleItem() {
        return this.maxDoubleItem_;
    }

    @Override
    double getMinDoubleItem() {
        return this.minDoubleItem_;
    }

    @Override
    int getMinK() {
        return this.minK_;
    }

    @Override
    void incN() {
        ++this.n_;
    }

    @Override
    void incNumLevels() {
    }

    @Override
    boolean isLevelZeroSorted() {
        return this.isLevelZeroSorted_;
    }

    @Override
    void setDoubleItemsArray(double[] doubleItems) {
        this.doubleItems_ = doubleItems;
    }

    @Override
    void setDoubleItemsArrayAt(int index, double item) {
        this.doubleItems_[index] = item;
    }

    @Override
    void setLevelZeroSorted(boolean sorted) {
        this.isLevelZeroSorted_ = sorted;
    }

    @Override
    void setMaxDoubleItem(double item) {
        this.maxDoubleItem_ = item;
    }

    @Override
    void setMinDoubleItem(double item) {
        this.minDoubleItem_ = item;
    }

    @Override
    void setMinK(int minK) {
        this.minK_ = minK;
    }

    @Override
    void setN(long n) {
        this.n_ = n;
    }

    @Override
    void setNumLevels(int numLevels) {
    }
}

