/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

import java.time.Duration;
import java.util.concurrent.TimeUnit;

public final class Timer {
    private long startNanos = System.nanoTime();

    private Timer() {
    }

    public static Timer startNew() {
        return new Timer();
    }

    public void restart() {
        this.startNanos = System.nanoTime();
    }

    private long getElapsedNanos() {
        return System.nanoTime() - this.startNanos;
    }

    public boolean hasElapsed(Duration duration) {
        return this.getElapsedNanos() >= Timer.toNanos(duration);
    }

    public boolean hasElapsed(long duration, TimeUnit unit) {
        return this.getElapsedNanos() >= unit.toNanos(duration);
    }

    public Duration elapsed() {
        return Duration.ofNanos(this.getElapsedNanos());
    }

    public long elapsed(TimeUnit unit) {
        return unit.convert(this.getElapsedNanos(), TimeUnit.NANOSECONDS);
    }

    private static long toNanos(Duration duration) {
        try {
            return duration.toNanos();
        }
        catch (ArithmeticException e) {
            return Long.MAX_VALUE;
        }
    }
}

