/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.behavior.InvalidBehaviorIdException;
import org.apache.wicket.model.IDetachable;
import org.apache.wicket.util.lang.Args;

final class Behaviors
implements IDetachable {
    private static final long serialVersionUID = 1L;
    private final Component component;

    public Behaviors(Component component) {
        this.component = component;
    }

    public void add(Behavior ... behaviors) {
        Args.notNull((Object)behaviors, (String)"behaviors");
        for (Behavior behavior : behaviors) {
            Args.notNull((Object)behavior, (String)"behavior");
            this.internalAdd(behavior);
            if (!behavior.isTemporary(this.component)) {
                this.component.addStateChange();
            }
            behavior.bind(this.component);
        }
    }

    private void internalAdd(Behavior behavior) {
        this.component.data_add(behavior);
        if (!behavior.getStatelessHint(this.component)) {
            this.getBehaviorId(behavior);
        }
    }

    public <M extends Behavior> List<M> getBehaviors(Class<M> type) {
        int start;
        int len = this.component.data_length();
        if (len < (start = this.component.data_start())) {
            return Collections.emptyList();
        }
        ArrayList<Behavior> subset = new ArrayList<Behavior>(len);
        for (int i = this.component.data_start(); i < len; ++i) {
            Object obj = this.component.data_get(i);
            if (obj == null || !(obj instanceof Behavior) || type != null && !type.isAssignableFrom(obj.getClass())) continue;
            subset.add((Behavior)obj);
        }
        return Collections.unmodifiableList(subset);
    }

    public void remove(Behavior behavior) {
        Args.notNull((Object)behavior, (String)"behavior");
        if (this.internalRemove(behavior)) {
            if (!behavior.isTemporary(this.component)) {
                this.component.addStateChange();
            }
        } else {
            throw new IllegalStateException("Tried to remove a behavior that was not added to the component. Behavior: " + behavior.toString());
        }
        behavior.detach(this.component);
    }

    @Override
    public final void detach() {
        int len = this.component.data_length();
        for (int i = this.component.data_start(); i < len; ++i) {
            Object obj = this.component.data_get(i);
            if (obj == null || !(obj instanceof Behavior)) continue;
            Behavior behavior = (Behavior)obj;
            behavior.detach(this.component);
            if (!behavior.isTemporary(this.component)) continue;
            this.internalRemove(behavior);
        }
    }

    private boolean internalRemove(Behavior behavior) {
        int len = this.component.data_length();
        for (int i = this.component.data_start(); i < len; ++i) {
            Object o = this.component.data_get(i);
            if (o == null || !o.equals(behavior)) continue;
            this.component.data_remove(i);
            behavior.unbind(this.component);
            BehaviorIdList ids = this.getBehaviorsIdList(false);
            if (ids != null) {
                int idx = ids.indexOf(behavior);
                if (idx == ids.size() - 1) {
                    ids.remove(idx);
                } else if (idx >= 0) {
                    ids.set(idx, null);
                }
                ids.trimToSize();
                if (ids.isEmpty()) {
                    this.removeBehaviorsIdList();
                }
            }
            return true;
        }
        return false;
    }

    private void removeBehaviorsIdList() {
        for (int i = this.component.data_start(); i < this.component.data_length(); ++i) {
            Object obj = this.component.data_get(i);
            if (obj == null || !(obj instanceof BehaviorIdList)) continue;
            this.component.data_remove(i);
            return;
        }
    }

    private BehaviorIdList getBehaviorsIdList(boolean createIfNotFound) {
        int len = this.component.data_length();
        for (int i = this.component.data_start(); i < len; ++i) {
            Object obj = this.component.data_get(i);
            if (obj == null || !(obj instanceof BehaviorIdList)) continue;
            return (BehaviorIdList)obj;
        }
        if (createIfNotFound) {
            BehaviorIdList list = new BehaviorIdList();
            this.component.data_add(list);
            return list;
        }
        return null;
    }

    public void onRemove(Component component) {
        int len = component.data_length();
        for (int i = component.data_start(); i < len; ++i) {
            Object obj = component.data_get(i);
            if (obj == null || !(obj instanceof Behavior)) continue;
            Behavior behavior = (Behavior)obj;
            behavior.onRemove(component);
        }
    }

    public final int getBehaviorId(Behavior behavior) {
        Args.notNull((Object)behavior, (String)"behavior");
        boolean found = false;
        for (int i = this.component.data_start(); i < this.component.data_length(); ++i) {
            if (behavior != this.component.data_get(i)) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalStateException("Behavior must be added to component before its id can be generated. Behavior: " + behavior + ", Component: " + this);
        }
        BehaviorIdList ids = this.getBehaviorsIdList(true);
        int id = ids.indexOf(behavior);
        if (id < 0) {
            for (int i = 0; i < ids.size(); ++i) {
                if (ids.get(i) != null) continue;
                ids.set(i, behavior);
                id = i;
                break;
            }
        }
        if (id < 0) {
            id = ids.size();
            ids.add(behavior);
            ids.trimToSize();
        }
        return id;
    }

    public final Behavior getBehaviorById(int id) {
        Behavior behavior = null;
        BehaviorIdList ids = this.getBehaviorsIdList(false);
        if (ids != null && id >= 0 && id < ids.size()) {
            behavior = (Behavior)ids.get(id);
        }
        if (behavior != null) {
            return behavior;
        }
        throw new InvalidBehaviorIdException(this.component, id);
    }

    private static class BehaviorIdList
    extends ArrayList<Behavior> {
        private static final long serialVersionUID = 1L;

        public BehaviorIdList() {
            super(1);
        }
    }
}

