/*
 * Decompiled with CFR 0.152.
 */
package javax.money.format;

import java.util.Locale;
import java.util.Objects;
import javax.money.AbstractContextBuilder;
import javax.money.MonetaryAmountFactory;
import javax.money.format.AmountFormatContext;
import javax.money.format.AmountFormatQuery;

public final class AmountFormatContextBuilder
extends AbstractContextBuilder<AmountFormatContextBuilder, AmountFormatContext> {
    private static final String DEFAULT_FORMAT_NAME = "default";

    private AmountFormatContextBuilder(AmountFormatQuery formatQuery) {
        this.importContext(formatQuery);
    }

    private AmountFormatContextBuilder(AmountFormatContext context) {
        Objects.requireNonNull(context);
        this.importContext(context);
    }

    private AmountFormatContextBuilder(String formatName) {
        Objects.requireNonNull(formatName, "formatName required.");
        this.set("formatName", formatName);
    }

    private AmountFormatContextBuilder(Locale locale) {
        Objects.requireNonNull(locale, "locale required.");
        this.setLocale(locale);
        this.set("formatName", DEFAULT_FORMAT_NAME);
    }

    public AmountFormatContextBuilder setFormatName(String formatName) {
        return (AmountFormatContextBuilder)this.set("formatName", formatName);
    }

    public AmountFormatContextBuilder setLocale(Locale locale) {
        return (AmountFormatContextBuilder)this.set(locale);
    }

    public AmountFormatContextBuilder setMonetaryAmountFactory(MonetaryAmountFactory monetaryAmountBuilder) {
        Objects.requireNonNull(monetaryAmountBuilder);
        return (AmountFormatContextBuilder)this.set(MonetaryAmountFactory.class, monetaryAmountBuilder);
    }

    @Override
    public AmountFormatContext build() {
        return new AmountFormatContext(this);
    }

    public static AmountFormatContextBuilder create(AmountFormatQuery formatQuery) {
        return new AmountFormatContextBuilder(formatQuery);
    }

    public static AmountFormatContextBuilder of(AmountFormatContext context) {
        return new AmountFormatContextBuilder(context);
    }

    public static AmountFormatContextBuilder of(String formatName) {
        return new AmountFormatContextBuilder(formatName);
    }

    public static AmountFormatContextBuilder of(Locale locale) {
        return new AmountFormatContextBuilder(locale);
    }
}

