/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.AbstractPagedHashMap;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.LongArray;

abstract class AbstractHash
extends AbstractPagedHashMap {
    LongArray ids;

    AbstractHash(long capacity, float maxLoadFactor, BigArrays bigArrays) {
        super(capacity, maxLoadFactor, bigArrays);
        this.ids = bigArrays.newLongArray(this.capacity(), true);
    }

    public long id(long index) {
        return this.ids.get(index) - 1L;
    }

    protected final long id(long index, long id) {
        return this.ids.set(index, id + 1L) - 1L;
    }

    @Override
    protected void resize(long capacity) {
        this.ids = this.bigArrays.resize(this.ids, capacity);
    }

    @Override
    protected boolean used(long bucket) {
        return this.id(bucket) >= 0L;
    }

    @Override
    public void close() {
        Releasables.close(this.ids);
    }
}

