/*
 * Decompiled with CFR 0.152.
 */
package groovyx.net.http;

import groovyx.net.http.HttpBuilder;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpCookie;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public interface FromServer {
    public static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";

    default public String getContentType() {
        Header.CombinedMap header = (Header.CombinedMap)Header.find(this.getHeaders(), "Content-Type");
        if (header == null) {
            return DEFAULT_CONTENT_TYPE;
        }
        return (String)((Map)header.getParsed()).get("Content-Type");
    }

    default public Charset getCharset() {
        Header.CombinedMap header = (Header.CombinedMap)Header.find(this.getHeaders(), "Content-Type");
        if (header == null) {
            return StandardCharsets.UTF_8;
        }
        if (((Map)header.getParsed()).containsKey("charset")) {
            Charset.forName((String)((Map)header.getParsed()).get("charset"));
        }
        return StandardCharsets.UTF_8;
    }

    default public List<HttpCookie> getCookies() {
        return HttpBuilder.cookies(this.getHeaders());
    }

    public InputStream getInputStream();

    public int getStatusCode();

    public String getMessage();

    public List<Header<?>> getHeaders();

    public boolean getHasBody();

    public URI getUri();

    public void finish();

    default public Reader getReader() {
        return new BufferedReader(new InputStreamReader(this.getInputStream()));
    }

    public static abstract class Header<T>
    implements Map.Entry<String, String> {
        final String key;
        final String value;
        private T parsed;
        private static final Map<String, BiFunction<String, String, ? extends Header>> constructors;

        protected static String key(String raw) {
            return raw.substring(0, raw.indexOf(58)).trim();
        }

        protected static String cleanQuotes(String str) {
            return str.startsWith("\"") ? str.substring(1, str.length() - 1) : str;
        }

        protected static String value(String raw) {
            return Header.cleanQuotes(raw.substring(raw.indexOf(58) + 1).trim());
        }

        protected Header(String key, String value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public String setValue(String val) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Header)) {
                return false;
            }
            Header other = (Header)o;
            return Objects.equals(this.getKey(), other.getKey()) && Objects.equals(this.getValue(), other.getValue());
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.getKey(), this.getValue());
        }

        public String toString() {
            return this.key + ": " + this.value;
        }

        public T getParsed() {
            if (this.parsed == null) {
                this.parsed = this.parse();
            }
            return this.parsed;
        }

        public abstract Class<?> getParsedType();

        protected abstract T parse();

        public static Header<?> full(String raw) {
            return Header.keyValue(Header.key(raw), Header.value(raw));
        }

        public static Header<?> keyValue(String key, String value) {
            BiFunction<String, String, ? extends Header> func = constructors.get(key);
            return func == null ? new ValueOnly(key, value) : func.apply(key, value);
        }

        public static Header<?> find(Collection<Header<?>> headers, String key) {
            return headers.stream().filter(h -> h.getKey().equalsIgnoreCase(key)).findFirst().orElse(null);
        }

        static {
            TreeMap<String, BiFunction<String, String, Header>> tmp = new TreeMap<String, BiFunction<String, String, Header>>(String.CASE_INSENSITIVE_ORDER);
            tmp.put("Access-Control-Allow-Origin", ValueOnly::new);
            tmp.put("Accept-Patch", CombinedMap::new);
            tmp.put("Accept-Ranges", ValueOnly::new);
            tmp.put("Age", SingleLong::new);
            tmp.put("Allow", CsvList::new);
            tmp.put("Alt-Svc", MapPairs::new);
            tmp.put("Cache-Control", MapPairs::new);
            tmp.put("Connection", ValueOnly::new);
            tmp.put("Content-Disposition", CombinedMap::new);
            tmp.put("Content-Encoding", ValueOnly::new);
            tmp.put("Content-Language", ValueOnly::new);
            tmp.put("Content-Length", SingleLong::new);
            tmp.put("Content-Location", ValueOnly::new);
            tmp.put("Content-MD5", ValueOnly::new);
            tmp.put("Content-Range", ValueOnly::new);
            tmp.put("Content-Type", CombinedMap::new);
            tmp.put("Date", HttpDate::new);
            tmp.put("ETag", ValueOnly::new);
            tmp.put("Expires", HttpDate::new);
            tmp.put("Last-Modified", HttpDate::new);
            tmp.put("Link", CombinedMap::new);
            tmp.put("Location", ValueOnly::new);
            tmp.put("P3P", MapPairs::new);
            tmp.put("Pragma", ValueOnly::new);
            tmp.put("Proxy-Authenticate", ValueOnly::new);
            tmp.put("Public-Key-Pins", MapPairs::new);
            tmp.put("Refresh", CombinedMap::new);
            tmp.put("Retry-After", HttpDate::new);
            tmp.put("Server", ValueOnly::new);
            tmp.put("Set-Cookie", HttpCookies::new);
            tmp.put("Set-Cookie2", HttpCookies::new);
            tmp.put("Status", ValueOnly::new);
            tmp.put("Strict-Transport-Security", MapPairs::new);
            tmp.put("Trailer", ValueOnly::new);
            tmp.put("Transfer-Encoding", ValueOnly::new);
            tmp.put("TSV", ValueOnly::new);
            tmp.put("Upgrade", CsvList::new);
            tmp.put("Vary", ValueOnly::new);
            tmp.put("Via", CsvList::new);
            tmp.put("Warning", ValueOnly::new);
            tmp.put("WWW-Authenticate", ValueOnly::new);
            tmp.put("X-Frame-Options", ValueOnly::new);
            constructors = Collections.unmodifiableMap(tmp);
        }

        public static class HttpCookies
        extends Header<List<HttpCookie>> {
            public HttpCookies(String key, String value) {
                super(key, value);
            }

            @Override
            public List<HttpCookie> parse() {
                return HttpCookie.parse(this.key + ": " + this.value);
            }

            @Override
            public Class<?> getParsedType() {
                return List.class;
            }
        }

        public static class SingleLong
        extends Header<Long> {
            public SingleLong(String key, String value) {
                super(key, value);
            }

            @Override
            public Long parse() {
                return Long.valueOf((String)this.getValue());
            }

            @Override
            public Class<?> getParsedType() {
                return Long.class;
            }
        }

        public static class MapPairs
        extends Header<Map<String, String>> {
            public MapPairs(String key, String value) {
                super(key, value);
            }

            @Override
            public Map<String, String> parse() {
                return Arrays.stream(((String)this.getValue()).split(";")).map(String::trim).map(str -> str.split("=")).collect(Collectors.toMap(ary -> ary[0].trim(), ary -> {
                    if (((String[])ary).length == 1) {
                        return ary[0];
                    }
                    return MapPairs.cleanQuotes(ary[1].trim());
                }, (oldVal, newVal) -> newVal, () -> new TreeMap(String.CASE_INSENSITIVE_ORDER)));
            }

            @Override
            public Class<?> getParsedType() {
                return Map.class;
            }
        }

        public static class HttpDate
        extends Header<ZonedDateTime> {
            public HttpDate(String key, String value) {
                super(key, value);
            }

            private boolean isSimpleNumber() {
                for (int i = 0; i < ((String)this.getValue()).length(); ++i) {
                    if (Character.isDigit(((String)this.getValue()).charAt(i))) continue;
                    return false;
                }
                return true;
            }

            @Override
            public ZonedDateTime parse() {
                if (this.isSimpleNumber()) {
                    return ZonedDateTime.now(ZoneOffset.UTC).plusSeconds(Long.parseLong((String)this.getValue()));
                }
                return this.parse(DateTimeFormatter.RFC_1123_DATE_TIME);
            }

            public ZonedDateTime parse(DateTimeFormatter formatter) {
                return ZonedDateTime.parse((CharSequence)this.getValue(), formatter);
            }

            @Override
            public Class<?> getParsedType() {
                return ZonedDateTime.class;
            }
        }

        public static class CsvList
        extends Header<List<String>> {
            public CsvList(String key, String value) {
                super(key, value);
            }

            @Override
            public List<String> parse() {
                return Collections.unmodifiableList(Arrays.stream(((String)this.getValue()).split(",")).map(String::trim).collect(Collectors.toList()));
            }

            @Override
            public Class<?> getParsedType() {
                return List.class;
            }
        }

        public static class CombinedMap
        extends Header<Map<String, String>> {
            public CombinedMap(String key, String value) {
                super(key, value);
            }

            @Override
            public Map<String, String> parse() {
                TreeMap<String, String> ret = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
                String[] ary = ((String)this.getValue()).split(";");
                ret.put(this.key, CombinedMap.cleanQuotes(ary[0].trim()));
                if (ary.length > 1) {
                    String[] secondary = ary[1].split("=");
                    ret.put(secondary[0].trim(), CombinedMap.cleanQuotes(secondary[1].trim()));
                }
                return Collections.unmodifiableMap(ret);
            }

            @Override
            public Class<?> getParsedType() {
                return Map.class;
            }
        }

        public static class ValueOnly
        extends Header<String> {
            public ValueOnly(String key, String value) {
                super(key, value);
            }

            @Override
            public String parse() {
                return this.getValue();
            }

            @Override
            public Class<?> getParsedType() {
                return String.class;
            }
        }
    }
}

