/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.task.reduce;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RawKeyValueIterator;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.ShuffleConsumerPlugin;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.mapreduce.MRIdHelper;
import org.apache.hadoop.mapreduce.RssMRConfig;
import org.apache.hadoop.mapreduce.RssMRUtils;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.task.reduce.ExceptionReporter;
import org.apache.hadoop.mapreduce.task.reduce.MergeManager;
import org.apache.hadoop.mapreduce.task.reduce.MergeManagerImpl;
import org.apache.hadoop.mapreduce.task.reduce.RssEventFetcher;
import org.apache.hadoop.mapreduce.task.reduce.RssFetcher;
import org.apache.hadoop.mapreduce.task.reduce.RssRemoteMergeManagerImpl;
import org.apache.hadoop.mapreduce.task.reduce.Shuffle;
import org.apache.hadoop.mapreduce.task.reduce.ShuffleClientMetrics;
import org.apache.hadoop.util.Progress;
import org.apache.uniffle.client.api.ShuffleReadClient;
import org.apache.uniffle.client.api.ShuffleWriteClient;
import org.apache.uniffle.client.factory.ShuffleClientFactory;
import org.apache.uniffle.common.RemoteStorageInfo;
import org.apache.uniffle.common.ShuffleServerInfo;
import org.apache.uniffle.hadoop.shim.HadoopShimImpl;
import org.apache.uniffle.shaded.org.roaringbitmap.longlong.Roaring64NavigableMap;

public class RssShuffle<K, V>
implements ShuffleConsumerPlugin<K, V>,
ExceptionReporter {
    private static final Log LOG = LogFactory.getLog(RssShuffle.class);
    private static final int MAX_EVENTS_TO_FETCH = 10000;
    private ShuffleConsumerPlugin.Context context;
    private TaskAttemptID reduceId;
    private JobConf mrJobConf;
    private Configuration rssJobConf;
    private Reporter reporter;
    private ShuffleClientMetrics metrics;
    private TaskUmbilicalProtocol umbilical;
    private MergeManager<K, V> merger;
    private Throwable throwable = null;
    private String throwingThreadName = null;
    private Progress copyPhase;
    private TaskStatus taskStatus;
    private Task reduceTask;
    private String appId;
    private String clientType;
    private int replicaWrite;
    private int replicaRead;
    private int replica;
    private int partitionNum;
    private int partitionNumPerRange;
    private String basePath;
    private RemoteStorageInfo remoteStorageInfo;
    private int appAttemptId;

    public void init(ShuffleConsumerPlugin.Context context) {
        this.context = context;
        this.reduceId = context.getReduceId();
        this.mrJobConf = context.getJobConf();
        this.rssJobConf = new JobConf("rss_conf.xml");
        this.umbilical = context.getUmbilical();
        this.reporter = context.getReporter();
        this.metrics = HadoopShimImpl.createShuffleClientMetrics(this.reduceId, this.mrJobConf);
        this.copyPhase = context.getCopyPhase();
        this.taskStatus = context.getStatus();
        this.reduceTask = context.getReduceTask();
        this.appId = RssMRUtils.getApplicationAttemptId().toString();
        this.appAttemptId = RssMRUtils.getApplicationAttemptId().getAttemptId();
        this.replicaWrite = RssMRUtils.getInt(this.rssJobConf, "mapreduce.rss.data.replica.write", 1);
        this.replicaRead = RssMRUtils.getInt(this.rssJobConf, "mapreduce.rss.data.replica.read", 1);
        this.replica = RssMRUtils.getInt(this.rssJobConf, "mapreduce.rss.data.replica", 1);
        this.partitionNum = this.mrJobConf.getNumReduceTasks();
        this.partitionNumPerRange = RssMRUtils.getInt(this.rssJobConf, "mapreduce.rss.partitionNum.per.range", 1);
        this.basePath = RssMRUtils.getString(this.rssJobConf, "mapreduce.rss.remote.storage.path");
        String remoteStorageConf = RssMRUtils.getString(this.rssJobConf, "mapreduce.rss.remote.storage.conf", "");
        this.remoteStorageInfo = new RemoteStorageInfo(this.basePath, remoteStorageConf);
        this.merger = this.createMergeManager(context);
    }

    protected MergeManager<K, V> createMergeManager(ShuffleConsumerPlugin.Context context) {
        boolean useRemoteSpill = RssMRUtils.getBoolean(this.rssJobConf, "mapreduce.rss.reduce.remote.spill.enable", false);
        if (useRemoteSpill) {
            int replication = RssMRUtils.getInt(this.rssJobConf, "mapreduce.rss.reduce.remote.spill.replication", 1);
            int retries = RssMRUtils.getInt(this.rssJobConf, "mapreduce.rss.reduce.remote.spill.retries", 5);
            return new RssRemoteMergeManagerImpl(this.appId, this.reduceId, this.mrJobConf, this.basePath, replication, retries, context.getLocalFS(), context.getLocalDirAllocator(), this.reporter, context.getCodec(), context.getCombinerClass(), context.getCombineCollector(), context.getSpilledRecordsCounter(), context.getReduceCombineInputCounter(), context.getMergedMapOutputsCounter(), this, context.getMergePhase(), context.getMapOutputFile(), this.getRemoteConf());
        }
        return new MergeManagerImpl(this.reduceId, this.mrJobConf, context.getLocalFS(), context.getLocalDirAllocator(), this.reporter, context.getCodec(), context.getCombinerClass(), context.getCombineCollector(), context.getSpilledRecordsCounter(), context.getReduceCombineInputCounter(), context.getMergedMapOutputsCounter(), (ExceptionReporter)this, context.getMergePhase(), context.getMapOutputFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RawKeyValueIterator run() throws IOException, InterruptedException {
        Set<ShuffleServerInfo> serverInfoSet = RssMRUtils.getAssignedServers(this.rssJobConf, this.reduceId.getTaskID().getId());
        ArrayList<ShuffleServerInfo> serverInfoList = new ArrayList<ShuffleServerInfo>();
        for (ShuffleServerInfo server : serverInfoSet) {
            serverInfoList.add(server);
        }
        ShuffleWriteClient writeClient = RssMRUtils.createShuffleClient(this.mrJobConf);
        Roaring64NavigableMap blockIdBitmap = writeClient.getShuffleResult(this.clientType, serverInfoSet, this.appId, 0, this.reduceId.getTaskID().getId());
        writeClient.close();
        RssEventFetcher eventFetcher = new RssEventFetcher(this.appAttemptId, this.reduceId, this.umbilical, this.mrJobConf, 10000);
        Roaring64NavigableMap taskIdBitmap = eventFetcher.fetchAllRssTaskIds();
        LOG.info((Object)("In reduce: " + this.reduceId + ", RSS MR client has fetched blockIds and taskIds successfully"));
        if (!taskIdBitmap.isEmpty()) {
            LOG.info((Object)("In reduce: " + this.reduceId + ", Rss MR client starts to fetch blocks from RSS server"));
            JobConf readerJobConf = this.getRemoteConf();
            boolean expectedTaskIdsBitmapFilterEnable = serverInfoList.size() > 1;
            int retryMax = this.rssJobConf.getInt("mapreduce.rss.client.retry.max", 50);
            long retryIntervalMax = this.rssJobConf.getLong("mapreduce.rss.client.retry.interval.max", 10000L);
            ShuffleReadClient shuffleReadClient = ShuffleClientFactory.getInstance().createShuffleReadClient(ShuffleClientFactory.newReadBuilder().appId(this.appId).shuffleId(0).partitionId(this.reduceId.getTaskID().getId()).basePath(this.basePath).partitionNumPerRange(this.partitionNumPerRange).partitionNum(this.partitionNum).blockIdBitmap(blockIdBitmap).taskIdBitmap(taskIdBitmap).shuffleServerInfoList(serverInfoList).hadoopConf((Configuration)readerJobConf).idHelper(new MRIdHelper()).expectedTaskIdsBitmapFilterEnable(expectedTaskIdsBitmapFilterEnable).retryMax(retryMax).retryIntervalMax(retryIntervalMax).rssConf(RssMRConfig.toRssConf(this.rssJobConf)));
            RssFetcher<K, V> fetcher = new RssFetcher<K, V>(this.mrJobConf, this.reduceId, this.taskStatus, this.merger, this.copyPhase, this.reporter, this.metrics, shuffleReadClient, blockIdBitmap.getLongCardinality(), RssMRConfig.toRssConf(this.rssJobConf));
            fetcher.fetchAllRssBlocks();
            LOG.info((Object)("In reduce: " + this.reduceId + ", Rss MR client fetches blocks from RSS server successfully"));
        }
        this.copyPhase.complete();
        this.taskStatus.setPhase(TaskStatus.Phase.SORT);
        this.reduceTask.statusUpdate(this.umbilical);
        RawKeyValueIterator kvIter = null;
        try {
            kvIter = this.merger.close();
        }
        catch (Throwable e) {
            throw new Shuffle.ShuffleError("Error while doing final merge ", e);
        }
        RssShuffle rssShuffle = this;
        synchronized (rssShuffle) {
            if (this.throwable != null) {
                throw new Shuffle.ShuffleError("error in shuffle in " + this.throwingThreadName, this.throwable);
            }
        }
        LOG.info((Object)("In reduce: " + this.reduceId + ", Rss MR client returns sorted data to reduce successfully"));
        return kvIter;
    }

    private JobConf getRemoteConf() {
        JobConf readerJobConf = new JobConf((Configuration)this.mrJobConf);
        if (!this.remoteStorageInfo.isEmpty()) {
            for (Map.Entry<String, String> entry : this.remoteStorageInfo.getConfItems().entrySet()) {
                readerJobConf.set(entry.getKey(), entry.getValue());
            }
        }
        return readerJobConf;
    }

    public void close() {
    }

    public synchronized void reportException(Throwable t) {
        if (this.throwable == null) {
            this.throwable = t;
            this.throwingThreadName = Thread.currentThread().getName();
        }
    }
}

