/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.coordinator.web.resource;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.hbase.thirdparty.javax.ws.rs.GET;
import org.apache.hbase.thirdparty.javax.ws.rs.Path;
import org.apache.hbase.thirdparty.javax.ws.rs.Produces;
import org.apache.hbase.thirdparty.javax.ws.rs.core.Context;
import org.apache.uniffle.coordinator.ApplicationManager;
import org.apache.uniffle.coordinator.web.Response;
import org.apache.uniffle.coordinator.web.resource.BaseResource;
import org.apache.uniffle.coordinator.web.vo.AppInfoVO;
import org.apache.uniffle.coordinator.web.vo.UserAppNumVO;
import org.apache.uniffle.shaded.guava.collect.Maps;

@Produces(value={"application/json"})
public class ApplicationResource
extends BaseResource {
    @Context
    protected ServletContext servletContext;

    @GET
    @Path(value="/total")
    public Response<Map<String, Integer>> getAppTotality() {
        return this.execute(() -> {
            HashMap<String, Integer> appTotalityMap = Maps.newHashMap();
            appTotalityMap.put("appTotality", this.getApplicationManager().getAppIds().size());
            return appTotalityMap;
        });
    }

    @GET
    @Path(value="/userTotal")
    public Response<List<UserAppNumVO>> getUserApps() {
        return this.execute(() -> {
            Map<String, Map<String, Long>> currentUserAndApp = this.getApplicationManager().getCurrentUserAndApp();
            ArrayList<UserAppNumVO> usercnt = new ArrayList<UserAppNumVO>();
            for (Map.Entry<String, Map<String, Long>> stringMapEntry : currentUserAndApp.entrySet()) {
                String userName = stringMapEntry.getKey();
                usercnt.add(new UserAppNumVO(userName, stringMapEntry.getValue().size()));
            }
            usercnt.sort(Comparator.reverseOrder());
            return usercnt;
        });
    }

    @GET
    @Path(value="/appInfos")
    public Response<List<AppInfoVO>> getAppInfoList() {
        return this.execute(() -> {
            ArrayList<AppInfoVO> userToAppList = new ArrayList<AppInfoVO>();
            Map<String, Map<String, Long>> currentUserAndApp = this.getApplicationManager().getCurrentUserAndApp();
            for (Map.Entry<String, Map<String, Long>> userAppIdTimestampMap : currentUserAndApp.entrySet()) {
                String userName = userAppIdTimestampMap.getKey();
                for (Map.Entry<String, Long> appIdTimestampMap : userAppIdTimestampMap.getValue().entrySet()) {
                    userToAppList.add(new AppInfoVO(userName, appIdTimestampMap.getKey(), appIdTimestampMap.getValue()));
                }
            }
            userToAppList.sort(Comparator.reverseOrder());
            return userToAppList;
        });
    }

    private ApplicationManager getApplicationManager() {
        return (ApplicationManager)this.servletContext.getAttribute(ApplicationManager.class.getCanonicalName());
    }
}

