/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.shaded.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import org.apache.uniffle.shaded.jackson.core.JsonGenerator;
import org.apache.uniffle.shaded.jackson.core.JsonToken;
import org.apache.uniffle.shaded.jackson.core.type.WritableTypeId;
import org.apache.uniffle.shaded.jackson.databind.JavaType;
import org.apache.uniffle.shaded.jackson.databind.JsonMappingException;
import org.apache.uniffle.shaded.jackson.databind.JsonNode;
import org.apache.uniffle.shaded.jackson.databind.SerializerProvider;
import org.apache.uniffle.shaded.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import org.apache.uniffle.shaded.jackson.databind.jsontype.TypeSerializer;
import org.apache.uniffle.shaded.jackson.databind.ser.std.StdSerializer;

public class RawSerializer<T>
extends StdSerializer<T> {
    public RawSerializer(Class<?> cls) {
        super(cls, false);
    }

    @Override
    public void serialize(T value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeRawValue(value.toString());
    }

    @Override
    public void serializeWithType(T value, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, typeSer.typeId(value, JsonToken.VALUE_EMBEDDED_OBJECT));
        this.serialize(value, g, provider);
        typeSer.writeTypeSuffix(g, typeIdDef);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode("string", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        this.visitStringFormat(visitor, typeHint);
    }
}

