/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.netty.protocol;

import io.netty.buffer.ByteBuf;
import org.apache.uniffle.common.netty.buffer.ManagedBuffer;
import org.apache.uniffle.common.netty.buffer.NettyManagedBuffer;
import org.apache.uniffle.common.netty.protocol.Message;
import org.apache.uniffle.common.netty.protocol.ResponseMessage;
import org.apache.uniffle.common.rpc.StatusCode;
import org.apache.uniffle.common.util.ByteBufUtils;

public class RpcResponse
extends ResponseMessage {
    private long requestId;
    private StatusCode statusCode;
    private String retMessage;

    public RpcResponse(long requestId, StatusCode statusCode, String retMessage) {
        this(requestId, statusCode, retMessage, null);
    }

    public RpcResponse(long requestId, StatusCode statusCode, ManagedBuffer message) {
        this(requestId, statusCode, null, message);
    }

    public RpcResponse(long requestId, StatusCode statusCode, String retMessage, ManagedBuffer message) {
        super(message);
        this.requestId = requestId;
        this.statusCode = statusCode;
        this.retMessage = retMessage;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public String getRetMessage() {
        return this.retMessage;
    }

    public String toString() {
        return "RpcResponse{requestId=" + this.requestId + ", statusCode=" + (Object)((Object)this.statusCode) + ", retMessage='" + this.retMessage + '\'' + '}';
    }

    @Override
    public int encodedLength() {
        return 12 + ByteBufUtils.encodedLength(this.retMessage);
    }

    @Override
    public void encode(ByteBuf buf) {
        buf.writeLong(this.requestId);
        buf.writeInt(this.statusCode.ordinal());
        ByteBufUtils.writeLengthAndString(buf, this.retMessage);
    }

    public static RpcResponse decode(ByteBuf byteBuf, boolean decodeBody) {
        long requestId = byteBuf.readLong();
        StatusCode statusCode = StatusCode.fromCode(byteBuf.readInt());
        String retMessage = ByteBufUtils.readLengthAndString(byteBuf);
        if (decodeBody) {
            NettyManagedBuffer nettyManagedBuffer = new NettyManagedBuffer(byteBuf);
            return new RpcResponse(requestId, statusCode, retMessage, nettyManagedBuffer);
        }
        return new RpcResponse(requestId, statusCode, retMessage, NettyManagedBuffer.EMPTY_BUFFER);
    }

    @Override
    public long getRequestId() {
        return this.requestId;
    }

    @Override
    public Message.Type type() {
        return Message.Type.RPC_RESPONSE;
    }
}

