/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.util;

import java.util.Objects;
import org.apache.uniffle.common.config.RssClientConf;
import org.apache.uniffle.common.config.RssConf;
import org.apache.uniffle.common.util.BlockId;

public class BlockIdLayout {
    public static final BlockIdLayout DEFAULT = BlockIdLayout.from(18, 24, 21);
    public final int sequenceNoBits;
    public final int partitionIdBits;
    public final int taskAttemptIdBits;
    public final int sequenceNoOffset;
    public final int partitionIdOffset;
    public final int taskAttemptIdOffset;
    public final long sequenceNoMask;
    public final long partitionIdMask;
    public final long taskAttemptIdMask;
    public final int maxSequenceNo;
    public final int maxPartitionId;
    public final int maxTaskAttemptId;
    public final int maxNumPartitions;

    private BlockIdLayout(int sequenceNoBits, int partitionIdBits, int taskAttemptIdBits) {
        if (sequenceNoBits <= 0 || partitionIdBits <= 0 || taskAttemptIdBits <= 0) {
            throw new IllegalArgumentException("Don't support given lengths, individual lengths must be larger than 0: given sequenceNoBits=" + sequenceNoBits + ", partitionIdBits=" + partitionIdBits + ", taskAttemptIdBits=" + taskAttemptIdBits);
        }
        if (sequenceNoBits >= 32 || partitionIdBits >= 32 || taskAttemptIdBits >= 32) {
            throw new IllegalArgumentException("Don't support given lengths, individual lengths must be less that 32: given sequenceNoBits=" + sequenceNoBits + ", partitionIdBits=" + partitionIdBits + ", taskAttemptIdBits=" + taskAttemptIdBits);
        }
        if (sequenceNoBits + partitionIdBits + taskAttemptIdBits != 63) {
            throw new IllegalArgumentException("Don't support given lengths, sum must be exactly 63: " + sequenceNoBits + " + " + partitionIdBits + " + " + taskAttemptIdBits + " = " + (sequenceNoBits + partitionIdBits + taskAttemptIdBits));
        }
        this.sequenceNoBits = sequenceNoBits;
        this.partitionIdBits = partitionIdBits;
        this.taskAttemptIdBits = taskAttemptIdBits;
        this.sequenceNoOffset = partitionIdBits + taskAttemptIdBits;
        this.partitionIdOffset = taskAttemptIdBits;
        this.taskAttemptIdOffset = 0;
        this.maxSequenceNo = (1 << sequenceNoBits) - 1;
        this.maxPartitionId = (1 << partitionIdBits) - 1;
        this.maxTaskAttemptId = (1 << taskAttemptIdBits) - 1;
        this.maxNumPartitions = this.maxPartitionId + 1;
        this.sequenceNoMask = (long)this.maxSequenceNo << this.sequenceNoOffset;
        this.partitionIdMask = (long)this.maxPartitionId << this.partitionIdOffset;
        this.taskAttemptIdMask = (long)this.maxTaskAttemptId << this.taskAttemptIdOffset;
    }

    public String toString() {
        return "blockIdLayout[seq: " + this.sequenceNoBits + " bits, part: " + this.partitionIdBits + " bits, task: " + this.taskAttemptIdBits + " bits]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockIdLayout that = (BlockIdLayout)o;
        return this.sequenceNoBits == that.sequenceNoBits && this.partitionIdBits == that.partitionIdBits && this.taskAttemptIdBits == that.taskAttemptIdBits;
    }

    public int hashCode() {
        return Objects.hash(this.sequenceNoBits, this.partitionIdBits, this.taskAttemptIdBits);
    }

    public long getBlockId(int sequenceNo, int partitionId, long taskAttemptId) {
        if (sequenceNo < 0 || sequenceNo > this.maxSequenceNo) {
            throw new IllegalArgumentException("Don't support sequenceNo[" + sequenceNo + "], the max value should be " + this.maxSequenceNo);
        }
        if (partitionId < 0 || partitionId > this.maxPartitionId) {
            throw new IllegalArgumentException("Don't support partitionId[" + partitionId + "], the max value should be " + this.maxPartitionId);
        }
        if (taskAttemptId < 0L || taskAttemptId > (long)this.maxTaskAttemptId) {
            throw new IllegalArgumentException("Don't support taskAttemptId[" + taskAttemptId + "], the max value should be " + this.maxTaskAttemptId);
        }
        return (long)sequenceNo << this.sequenceNoOffset | (long)partitionId << this.partitionIdOffset | taskAttemptId << this.taskAttemptIdOffset;
    }

    public int getSequenceNo(long blockId) {
        return (int)((blockId & this.sequenceNoMask) >> this.sequenceNoOffset);
    }

    public int getPartitionId(long blockId) {
        return (int)((blockId & this.partitionIdMask) >> this.partitionIdOffset);
    }

    public int getTaskAttemptId(long blockId) {
        return (int)((blockId & this.taskAttemptIdMask) >> this.taskAttemptIdOffset);
    }

    public BlockId asBlockId(long blockId) {
        return new BlockId(blockId, this, this.getSequenceNo(blockId), this.getPartitionId(blockId), this.getTaskAttemptId(blockId));
    }

    public BlockId asBlockId(int sequenceNo, int partitionId, long taskAttemptId) {
        return new BlockId(this.getBlockId(sequenceNo, partitionId, taskAttemptId), this, sequenceNo, partitionId, (int)taskAttemptId);
    }

    public static BlockIdLayout from(RssConf rssConf) {
        int sequenceBits = rssConf.get(RssClientConf.BLOCKID_SEQUENCE_NO_BITS);
        int partitionBits = rssConf.get(RssClientConf.BLOCKID_PARTITION_ID_BITS);
        int attemptBits = rssConf.get(RssClientConf.BLOCKID_TASK_ATTEMPT_ID_BITS);
        return BlockIdLayout.from(sequenceBits, partitionBits, attemptBits);
    }

    public static BlockIdLayout from(int sequenceNoBits, int partitionIdBits, int taskAttemptIdBits) {
        return new BlockIdLayout(sequenceNoBits, partitionIdBits, taskAttemptIdBits);
    }
}

