/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.shaded.org.roaringbitmap;

import org.apache.uniffle.shaded.org.roaringbitmap.BitmapContainerCharIterator;
import org.apache.uniffle.shaded.org.roaringbitmap.PeekableCharRankIterator;

final class BitmapContainerCharRankIterator
extends BitmapContainerCharIterator
implements PeekableCharRankIterator {
    private int nextRank = 1;

    BitmapContainerCharRankIterator(long[] p) {
        super(p);
    }

    @Override
    public int peekNextRank() {
        return this.nextRank;
    }

    @Override
    public char next() {
        ++this.nextRank;
        return super.next();
    }

    @Override
    public void advanceIfNeeded(char minval) {
        if (minval >= (this.x + 1) * 64) {
            int nextX = minval / 64;
            this.nextRank += Long.bitCount(this.w);
            ++this.x;
            while (this.x < nextX) {
                this.w = this.bitmap[this.x];
                this.nextRank += Long.bitCount(this.w);
                ++this.x;
            }
            this.x = nextX;
            this.w = this.bitmap[this.x];
            while (this.w == 0L) {
                ++this.x;
                if (this.x == this.bitmap.length) {
                    return;
                }
                this.w = this.bitmap[this.x];
            }
        }
        while (this.hasNext() && this.peekNext() < minval) {
            this.next();
        }
    }

    @Override
    public PeekableCharRankIterator clone() {
        return (PeekableCharRankIterator)super.clone();
    }
}

