/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.client.impl;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.uniffle.client.api.ShuffleReadClient;
import org.apache.uniffle.client.factory.ShuffleClientFactory;
import org.apache.uniffle.client.response.CompressedShuffleBlock;
import org.apache.uniffle.client.util.DefaultIdHelper;
import org.apache.uniffle.common.BufferSegment;
import org.apache.uniffle.common.ShuffleDataDistributionType;
import org.apache.uniffle.common.ShuffleDataResult;
import org.apache.uniffle.common.ShuffleServerInfo;
import org.apache.uniffle.common.config.RssClientConf;
import org.apache.uniffle.common.config.RssConf;
import org.apache.uniffle.common.exception.RssFetchFailedException;
import org.apache.uniffle.common.util.BlockIdLayout;
import org.apache.uniffle.common.util.ChecksumUtils;
import org.apache.uniffle.common.util.IdHelper;
import org.apache.uniffle.common.util.RssUtils;
import org.apache.uniffle.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.uniffle.shaded.com.google.common.collect.Lists;
import org.apache.uniffle.shaded.com.google.common.collect.Queues;
import org.apache.uniffle.shaded.com.google.common.collect.Sets;
import org.apache.uniffle.shaded.org.roaringbitmap.longlong.Roaring64NavigableMap;
import org.apache.uniffle.storage.factory.ShuffleHandlerFactory;
import org.apache.uniffle.storage.handler.api.ClientReadHandler;
import org.apache.uniffle.storage.request.CreateShuffleReadHandlerRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShuffleReadClientImpl
implements ShuffleReadClient {
    private static final Logger LOG = LoggerFactory.getLogger(ShuffleReadClientImpl.class);
    private List<ShuffleServerInfo> shuffleServerInfoList;
    private int shuffleId;
    private int partitionId;
    private ByteBuffer readBuffer;
    private ShuffleDataResult sdr;
    private Roaring64NavigableMap blockIdBitmap;
    private Roaring64NavigableMap taskIdBitmap;
    private Roaring64NavigableMap pendingBlockIds;
    private Roaring64NavigableMap processedBlockIds = Roaring64NavigableMap.bitmapOf(new long[0]);
    private Queue<BufferSegment> bufferSegmentQueue = Queues.newLinkedBlockingQueue();
    private AtomicLong readDataTime = new AtomicLong(0L);
    private AtomicLong copyTime = new AtomicLong(0L);
    private AtomicLong crcCheckTime = new AtomicLong(0L);
    private ClientReadHandler clientReadHandler;
    private IdHelper idHelper;
    private BlockIdLayout blockIdLayout;

    public ShuffleReadClientImpl(ShuffleClientFactory.ReadClientBuilder builder) {
        if (builder.getShuffleDataDistributionType() == null) {
            builder.shuffleDataDistributionType(ShuffleDataDistributionType.NORMAL);
        }
        if (builder.getHadoopConf() == null) {
            builder.hadoopConf(new Configuration());
        }
        if (builder.getRssConf() != null && !builder.getRssConf().getKeySet().equals(Sets.newHashSet(RssClientConf.BLOCKID_SEQUENCE_NO_BITS.key(), RssClientConf.BLOCKID_PARTITION_ID_BITS.key(), RssClientConf.BLOCKID_TASK_ATTEMPT_ID_BITS.key()))) {
            int indexReadLimit = builder.getRssConf().get(RssClientConf.RSS_INDEX_READ_LIMIT);
            String storageType = builder.getRssConf().get(RssClientConf.RSS_STORAGE_TYPE);
            long readBufferSize = builder.getRssConf().getSizeAsBytes(RssClientConf.RSS_CLIENT_READ_BUFFER_SIZE.key(), RssClientConf.RSS_CLIENT_READ_BUFFER_SIZE.defaultValue());
            if (readBufferSize > Integer.MAX_VALUE) {
                LOG.warn(RssClientConf.RSS_CLIENT_READ_BUFFER_SIZE.key() + " can support 2g as max");
                readBufferSize = Integer.MAX_VALUE;
            }
            boolean offHeapEnabled = builder.getRssConf().get(RssClientConf.OFF_HEAP_MEMORY_ENABLE);
            builder.indexReadLimit(indexReadLimit);
            builder.storageType(storageType);
            builder.readBufferSize(readBufferSize);
            builder.offHeapEnable(offHeapEnabled);
            if (builder.getClientType() == null) {
                builder.clientType(builder.getRssConf().get(RssClientConf.RSS_CLIENT_TYPE));
            }
        } else {
            RssConf rssConf = builder.getRssConf() == null ? new RssConf() : builder.getRssConf();
            rssConf.set(RssClientConf.RSS_STORAGE_TYPE, builder.getStorageType());
            rssConf.set(RssClientConf.RSS_INDEX_READ_LIMIT, builder.getIndexReadLimit());
            rssConf.set(RssClientConf.RSS_CLIENT_READ_BUFFER_SIZE, String.valueOf(builder.getReadBufferSize()));
            if (!rssConf.contains(RssClientConf.BLOCKID_SEQUENCE_NO_BITS)) {
                rssConf.setInteger(RssClientConf.BLOCKID_SEQUENCE_NO_BITS, BlockIdLayout.DEFAULT.sequenceNoBits);
            }
            if (!rssConf.contains(RssClientConf.BLOCKID_PARTITION_ID_BITS)) {
                rssConf.setInteger(RssClientConf.BLOCKID_PARTITION_ID_BITS, BlockIdLayout.DEFAULT.partitionIdBits);
            }
            if (!rssConf.contains(RssClientConf.BLOCKID_TASK_ATTEMPT_ID_BITS)) {
                rssConf.setInteger(RssClientConf.BLOCKID_TASK_ATTEMPT_ID_BITS, BlockIdLayout.DEFAULT.taskAttemptIdBits);
            }
            builder.rssConf(rssConf);
            builder.offHeapEnable(false);
            builder.expectedTaskIdsBitmapFilterEnable(false);
            if (builder.getClientType() == null) {
                builder.clientType(rssConf.get(RssClientConf.RSS_CLIENT_TYPE));
            }
        }
        if (builder.getIdHelper() == null) {
            builder.idHelper(new DefaultIdHelper(BlockIdLayout.from(builder.getRssConf())));
        }
        this.init(builder);
    }

    private void init(ShuffleClientFactory.ReadClientBuilder builder) {
        this.shuffleId = builder.getShuffleId();
        this.partitionId = builder.getPartitionId();
        this.blockIdBitmap = builder.getBlockIdBitmap();
        this.taskIdBitmap = builder.getTaskIdBitmap();
        this.idHelper = builder.getIdHelper();
        this.shuffleServerInfoList = builder.getShuffleServerInfoList();
        this.blockIdLayout = BlockIdLayout.from(builder.getRssConf());
        CreateShuffleReadHandlerRequest request = new CreateShuffleReadHandlerRequest();
        request.setStorageType(builder.getStorageType());
        request.setAppId(builder.getAppId());
        request.setShuffleId(this.shuffleId);
        request.setPartitionId(this.partitionId);
        request.setIndexReadLimit(builder.getIndexReadLimit());
        request.setPartitionNumPerRange(builder.getPartitionNumPerRange());
        request.setPartitionNum(builder.getPartitionNum());
        request.setReadBufferSize((int)builder.getReadBufferSize());
        request.setStorageBasePath(builder.getBasePath());
        request.setShuffleServerInfoList(this.shuffleServerInfoList);
        request.setHadoopConf(builder.getHadoopConf());
        request.setExpectBlockIds(this.blockIdBitmap);
        request.setProcessBlockIds(this.processedBlockIds);
        request.setDistributionType(builder.getShuffleDataDistributionType());
        request.setIdHelper(this.idHelper);
        request.setExpectTaskIds(this.taskIdBitmap);
        request.setClientConf(builder.getRssConf());
        request.setClientType(builder.getClientType());
        request.setRetryMax(builder.getRetryMax());
        request.setRetryIntervalMax(builder.getRetryIntervalMax());
        if (builder.isExpectedTaskIdsBitmapFilterEnable()) {
            request.useExpectedTaskIdsBitmapFilter();
        }
        if (builder.isOffHeapEnable()) {
            request.enableOffHeap();
        }
        ArrayList removeBlockIds = Lists.newArrayList();
        this.blockIdBitmap.forEach(bid -> {
            if (!this.taskIdBitmap.contains(this.idHelper.getTaskAttemptId(bid))) {
                removeBlockIds.add(bid);
            }
        });
        Iterator iterator = removeBlockIds.iterator();
        while (iterator.hasNext()) {
            long rid = (Long)iterator.next();
            this.blockIdBitmap.removeLong(rid);
        }
        this.pendingBlockIds = RssUtils.cloneBitMap(this.blockIdBitmap);
        this.clientReadHandler = ShuffleHandlerFactory.getInstance().createShuffleReadHandler(request);
    }

    @Override
    public CompressedShuffleBlock readShuffleBlockData() {
        BufferSegment bs;
        block2: do {
            if (this.blockIdBitmap.isEmpty()) {
                return null;
            }
            if (this.pendingBlockIds.isEmpty()) {
                return null;
            }
            if (this.bufferSegmentQueue.isEmpty() && this.read() <= 0) {
                return null;
            }
            bs = null;
            while ((bs = this.bufferSegmentQueue.poll()) != null) {
                if (!this.processedBlockIds.contains(bs.getBlockId()) && this.blockIdBitmap.contains(bs.getBlockId()) && this.taskIdBitmap.contains(bs.getTaskAttemptId())) {
                    long expectedCrc = -1L;
                    long actualCrc = -1L;
                    try {
                        long start = System.currentTimeMillis();
                        expectedCrc = bs.getCrc();
                        actualCrc = ChecksumUtils.getCrc32(this.readBuffer, bs.getOffset(), bs.getLength());
                        this.crcCheckTime.addAndGet(System.currentTimeMillis() - start);
                    }
                    catch (Exception e) {
                        LOG.warn("Can't read data for " + this.blockIdLayout.asBlockId(bs.getBlockId()), (Throwable)e);
                    }
                    if (expectedCrc != actualCrc) {
                        String errMsg = "Unexpected crc value for " + this.blockIdLayout.asBlockId(bs.getBlockId()) + ", expected:" + expectedCrc + ", actual:" + actualCrc;
                        if (this.shuffleServerInfoList.size() > 1) {
                            LOG.warn(errMsg);
                            this.clientReadHandler.updateConsumedBlockInfo(bs, true);
                            continue;
                        }
                        throw new RssFetchFailedException(errMsg);
                    }
                    this.processedBlockIds.addLong(bs.getBlockId());
                    this.pendingBlockIds.removeLong(bs.getBlockId());
                    this.clientReadHandler.updateConsumedBlockInfo(bs, false);
                    continue block2;
                }
                this.clientReadHandler.updateConsumedBlockInfo(bs, true);
                this.processedBlockIds.addLong(bs.getBlockId());
                this.pendingBlockIds.removeLong(bs.getBlockId());
            }
        } while (bs == null);
        ByteBuffer compressedBuffer = this.readBuffer.duplicate();
        compressedBuffer.position(bs.getOffset());
        compressedBuffer.limit(bs.getOffset() + bs.getLength());
        return new CompressedShuffleBlock(compressedBuffer, bs.getUncompressLength());
    }

    @VisibleForTesting
    protected Roaring64NavigableMap getProcessedBlockIds() {
        return this.processedBlockIds;
    }

    private int read() {
        long start = System.currentTimeMillis();
        if (this.sdr != null) {
            this.sdr.release();
            this.sdr = null;
        }
        this.sdr = this.clientReadHandler.readShuffleData();
        this.readDataTime.addAndGet(System.currentTimeMillis() - start);
        if (this.sdr == null) {
            return 0;
        }
        if (this.readBuffer != null) {
            RssUtils.releaseByteBuffer(this.readBuffer);
        }
        this.readBuffer = this.sdr.getDataBuffer();
        if (this.readBuffer == null || this.readBuffer.capacity() == 0) {
            return 0;
        }
        this.bufferSegmentQueue.addAll(this.sdr.getBufferSegments());
        return this.sdr.getBufferSegments().size();
    }

    @Override
    public void checkProcessedBlockIds() {
        RssUtils.checkProcessedBlockIds(this.blockIdBitmap, this.processedBlockIds);
    }

    @Override
    public void close() {
        if (this.sdr != null) {
            this.sdr.release();
        }
        if (this.readBuffer != null) {
            RssUtils.releaseByteBuffer(this.readBuffer);
        }
        if (this.clientReadHandler != null) {
            this.clientReadHandler.close();
        }
    }

    @Override
    public void logStatics() {
        LOG.info("Metrics for shuffleId[" + this.shuffleId + "], partitionId[" + this.partitionId + "], read data cost " + this.readDataTime + " ms, copy data cost " + this.copyTime + " ms, crc check cost " + this.crcCheckTime + " ms");
        this.clientReadHandler.logConsumedBlockInfo();
    }
}

