/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common;

import java.util.List;
import org.apache.uniffle.common.BlockCompletionCallback;
import org.apache.uniffle.common.ShuffleServerInfo;
import org.apache.uniffle.common.util.ByteBufUtils;
import org.apache.uniffle.io.netty.buffer.ByteBuf;
import org.apache.uniffle.io.netty.buffer.Unpooled;

public class ShuffleBlockInfo {
    private int partitionId;
    private long blockId;
    private int length;
    private int shuffleId;
    private long crc;
    private long taskAttemptId;
    private ByteBuf data;
    private List<ShuffleServerInfo> shuffleServerInfos;
    private int uncompressLength;
    private long freeMemory;
    private int retryCnt = 0;
    private transient BlockCompletionCallback completionCallback;

    public ShuffleBlockInfo(int shuffleId, int partitionId, long blockId, int length, long crc, byte[] data, List<ShuffleServerInfo> shuffleServerInfos, int uncompressLength, long freeMemory, long taskAttemptId) {
        this(shuffleId, partitionId, blockId, length, crc, Unpooled.wrappedBuffer(data), shuffleServerInfos, uncompressLength, freeMemory, taskAttemptId);
    }

    public ShuffleBlockInfo(int shuffleId, int partitionId, long blockId, int length, long crc, ByteBuf data, List<ShuffleServerInfo> shuffleServerInfos, int uncompressLength, long freeMemory, long taskAttemptId) {
        this.partitionId = partitionId;
        this.blockId = blockId;
        this.length = length;
        this.crc = crc;
        this.data = data;
        this.shuffleId = shuffleId;
        this.shuffleServerInfos = shuffleServerInfos;
        this.uncompressLength = uncompressLength;
        this.freeMemory = freeMemory;
        this.taskAttemptId = taskAttemptId;
    }

    public long getBlockId() {
        return this.blockId;
    }

    public int getLength() {
        return this.length;
    }

    public int getSize() {
        return this.length + 24 + 8;
    }

    public long getCrc() {
        return this.crc;
    }

    public ByteBuf getData() {
        return this.data;
    }

    public int getShuffleId() {
        return this.shuffleId;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public List<ShuffleServerInfo> getShuffleServerInfos() {
        return this.shuffleServerInfos;
    }

    public int getUncompressLength() {
        return this.uncompressLength;
    }

    public long getFreeMemory() {
        return this.freeMemory;
    }

    public long getTaskAttemptId() {
        return this.taskAttemptId;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ShuffleBlockInfo:");
        sb.append("shuffleId[" + this.shuffleId + "],");
        sb.append("partitionId[" + this.partitionId + "],");
        sb.append("blockId[" + this.blockId + "],");
        sb.append("length[" + this.length + "],");
        sb.append("uncompressLength[" + this.uncompressLength + "],");
        sb.append("crc[" + this.crc + "],");
        if (this.shuffleServerInfos != null) {
            sb.append("shuffleServer[");
            for (ShuffleServerInfo ssi : this.shuffleServerInfos) {
                sb.append(ssi.getId() + ",");
            }
            sb.append("]");
        } else {
            sb.append("shuffleServer is empty");
        }
        return sb.toString();
    }

    public void incrRetryCnt() {
        ++this.retryCnt;
    }

    public int getRetryCnt() {
        return this.retryCnt;
    }

    public void reassignShuffleServers(List<ShuffleServerInfo> replacements) {
        this.shuffleServerInfos = replacements;
    }

    public synchronized void copyDataTo(ByteBuf to) {
        ByteBufUtils.copyByteBuf(this.data, to);
    }

    public void withCompletionCallback(BlockCompletionCallback callback) {
        this.completionCallback = callback;
    }

    public void executeCompletionCallback(boolean isSuccessful) {
        if (this.completionCallback == null) {
            return;
        }
        this.completionCallback.onBlockCompletion(this, isSuccessful);
    }
}

