/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.client.request;

import org.apache.uniffle.client.request.RetryableRequest;
import org.apache.uniffle.com.google.common.annotations.VisibleForTesting;
import org.apache.uniffle.org.roaringbitmap.longlong.Roaring64NavigableMap;

public class RssGetInMemoryShuffleDataRequest
extends RetryableRequest {
    private final String appId;
    private final int shuffleId;
    private final int partitionId;
    private final long lastBlockId;
    private final int readBufferSize;
    private final Roaring64NavigableMap expectedTaskIds;

    public RssGetInMemoryShuffleDataRequest(String appId, int shuffleId, int partitionId, long lastBlockId, int readBufferSize, Roaring64NavigableMap expectedTaskIds, int retryMax, long retryIntervalMax) {
        this.appId = appId;
        this.shuffleId = shuffleId;
        this.partitionId = partitionId;
        this.lastBlockId = lastBlockId;
        this.readBufferSize = readBufferSize;
        this.expectedTaskIds = expectedTaskIds;
        this.retryMax = retryMax;
        this.retryIntervalMax = retryIntervalMax;
    }

    @VisibleForTesting
    public RssGetInMemoryShuffleDataRequest(String appId, int shuffleId, int partitionId, long lastBlockId, int readBufferSize, Roaring64NavigableMap expectedTaskIds) {
        this(appId, shuffleId, partitionId, lastBlockId, readBufferSize, expectedTaskIds, 1, 0L);
    }

    public String getAppId() {
        return this.appId;
    }

    public int getShuffleId() {
        return this.shuffleId;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public long getLastBlockId() {
        return this.lastBlockId;
    }

    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    public Roaring64NavigableMap getExpectedTaskIds() {
        return this.expectedTaskIds;
    }

    @Override
    public String operationType() {
        return "GetInMemoryShuffleData";
    }
}

