/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.storage.handler.impl;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.uniffle.com.google.common.annotations.VisibleForTesting;
import org.apache.uniffle.common.ShufflePartitionedBlock;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.filesystem.HadoopFilesystemProvider;
import org.apache.uniffle.common.util.ByteBufUtils;
import org.apache.uniffle.storage.common.FileBasedShuffleSegment;
import org.apache.uniffle.storage.handler.api.ShuffleWriteHandler;
import org.apache.uniffle.storage.handler.impl.HadoopFileWriter;
import org.apache.uniffle.storage.util.ShuffleStorageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopShuffleWriteHandler
implements ShuffleWriteHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopShuffleWriteHandler.class);
    private Configuration hadoopConf;
    private String basePath;
    private String fileNamePrefix;
    private Lock writeLock = new ReentrantLock();
    private int failTimes = 0;
    private String user;
    private FileSystem fileSystem;

    @VisibleForTesting
    public HadoopShuffleWriteHandler(String appId, int shuffleId, int startPartition, int endPartition, String storageBasePath, String fileNamePrefix, Configuration hadoopConf) throws Exception {
        this.hadoopConf = hadoopConf;
        this.fileNamePrefix = fileNamePrefix;
        this.basePath = ShuffleStorageUtils.getFullShuffleDataFolder(storageBasePath, ShuffleStorageUtils.getShuffleDataPath(appId, shuffleId, startPartition, endPartition));
        this.initialize();
    }

    public HadoopShuffleWriteHandler(String appId, int shuffleId, int startPartition, int endPartition, String storageBasePath, String fileNamePrefix, Configuration hadoopConf, String user) throws Exception {
        this.hadoopConf = hadoopConf;
        this.fileNamePrefix = fileNamePrefix;
        this.basePath = ShuffleStorageUtils.getFullShuffleDataFolder(storageBasePath, ShuffleStorageUtils.getShuffleDataPath(appId, shuffleId, startPartition, endPartition));
        this.user = user;
        this.initialize();
    }

    private void initialize() throws Exception {
        block3: {
            Path path = new Path(this.basePath);
            LOG.info("User: {}, Path: {}", (Object)this.user, (Object)path);
            this.fileSystem = HadoopFilesystemProvider.getFilesystem(this.user, path, this.hadoopConf);
            if (!this.fileSystem.exists(path)) {
                try {
                    this.fileSystem.mkdirs(path);
                }
                catch (IOException ioe) {
                    if (this.fileSystem.exists(path)) break block3;
                    LOG.error("Can't create shuffle folder:" + this.basePath, (Throwable)ioe);
                    throw ioe;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(List<ShufflePartitionedBlock> shuffleBlocks) throws Exception {
        long start = System.currentTimeMillis();
        this.writeLock.lock();
        try {
            long ss = System.currentTimeMillis();
            String dataFileName = ShuffleStorageUtils.generateDataFileName(this.fileNamePrefix + "_" + this.failTimes);
            String indexFileName = ShuffleStorageUtils.generateIndexFileName(this.fileNamePrefix + "_" + this.failTimes);
            try (HadoopFileWriter dataWriter = this.createWriter(dataFileName);
                 HadoopFileWriter indexWriter = this.createWriter(indexFileName);){
                for (ShufflePartitionedBlock block : shuffleBlocks) {
                    long blockId = block.getBlockId();
                    long crc = block.getCrc();
                    long startOffset = dataWriter.nextOffset();
                    dataWriter.writeData(ByteBufUtils.readBytes(block.getData()));
                    FileBasedShuffleSegment segment = new FileBasedShuffleSegment(blockId, startOffset, block.getLength(), block.getUncompressLength(), crc, block.getTaskAttemptId());
                    indexWriter.writeIndex(segment);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Write handler inside cost {} ms for {}", (Object)(System.currentTimeMillis() - ss), (Object)this.fileNamePrefix);
                }
            }
            catch (IOException e) {
                LOG.warn("Write failed with " + shuffleBlocks.size() + " blocks for " + this.fileNamePrefix + "_" + this.failTimes, (Throwable)e);
                ++this.failTimes;
                throw new RssException(e);
            }
        }
        finally {
            this.writeLock.unlock();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Write handler outside write {} blocks cost {} ms for {}", new Object[]{shuffleBlocks.size(), System.currentTimeMillis() - start, this.fileNamePrefix});
        }
    }

    @VisibleForTesting
    public HadoopFileWriter createWriter(String fileName) throws IOException, IllegalStateException {
        Path path = new Path(this.basePath, fileName);
        HadoopFileWriter writer = new HadoopFileWriter(this.fileSystem, path, this.hadoopConf);
        return writer;
    }

    @VisibleForTesting
    public void setFailTimes(int failTimes) {
        this.failTimes = failTimes;
    }
}

