/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.coordinator.strategy.storage;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.filesystem.HadoopFilesystemProvider;
import org.apache.uniffle.coordinator.ApplicationManager;
import org.apache.uniffle.coordinator.CoordinatorConf;
import org.apache.uniffle.coordinator.strategy.storage.RankValue;
import org.apache.uniffle.coordinator.strategy.storage.SelectStorageStrategy;
import org.apache.uniffle.guava.annotations.VisibleForTesting;
import org.apache.uniffle.guava.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSelectStorageStrategy
implements SelectStorageStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSelectStorageStrategy.class);
    protected final Map<String, RankValue> remoteStoragePathRankValue;
    protected final int fileSize;
    private final String coordinatorId;
    private final Configuration hadoopConf;
    private final CoordinatorConf conf;
    protected List<Map.Entry<String, RankValue>> uris;

    public AbstractSelectStorageStrategy(Map<String, RankValue> remoteStoragePathRankValue, CoordinatorConf conf) {
        this.remoteStoragePathRankValue = remoteStoragePathRankValue;
        this.hadoopConf = new Configuration();
        this.fileSize = conf.getInteger(CoordinatorConf.COORDINATOR_REMOTE_STORAGE_SCHEDULE_FILE_SIZE);
        this.coordinatorId = conf.getString("coordinator.id", UUID.randomUUID().toString());
        this.conf = conf;
    }

    public void readAndWriteHadoopStorage(FileSystem fs, Path testPath, String uri, RankValue rankValue) throws IOException {
        byte[] data = RandomUtils.nextBytes((int)this.fileSize);
        try (FSDataOutputStream fos = fs.create(testPath);){
            fos.write(data);
            fos.flush();
        }
        byte[] readData = new byte[this.fileSize];
        try (FSDataInputStream fis = fs.open(testPath);){
            int readBytes;
            int hasReadBytes = 0;
            do {
                readBytes = fis.read(readData);
                if (hasReadBytes < this.fileSize) {
                    for (int i = 0; i < readBytes; ++i) {
                        if (data[hasReadBytes + i] == readData[i]) continue;
                        this.remoteStoragePathRankValue.put(uri, new RankValue(Long.MAX_VALUE, rankValue.getAppNum().get()));
                        throw new RssException("The content of reading and writing is inconsistent.");
                    }
                }
                hasReadBytes += readBytes;
            } while (readBytes != -1);
        }
    }

    @Override
    public void detectStorage() {
        this.uris = Lists.newCopyOnWriteArrayList(this.remoteStoragePathRankValue.entrySet());
        if (this.remoteStoragePathRankValue.size() > 1) {
            CountDownLatch countDownLatch = new CountDownLatch(this.uris.size());
            this.uris.parallelStream().forEach(uri -> {
                if (((String)uri.getKey()).startsWith(ApplicationManager.getPathSchema().get(0))) {
                    Path remotePath = new Path((String)uri.getKey());
                    String rssTest = (String)uri.getKey() + "/rssTest-" + this.getCoordinatorId() + Thread.currentThread().getName();
                    Path testPath = new Path(rssTest);
                    RankValue rankValue = this.remoteStoragePathRankValue.get(uri.getKey());
                    rankValue.setHealthy(new AtomicBoolean(true));
                    long startWriteTime = System.currentTimeMillis();
                    try {
                        FileSystem fs = HadoopFilesystemProvider.getFilesystem((Path)remotePath, (Configuration)this.hadoopConf);
                        for (int j = 0; j < this.readAndWriteTimes(this.conf); ++j) {
                            this.readAndWriteHadoopStorage(fs, testPath, (String)uri.getKey(), rankValue);
                        }
                    }
                    catch (Exception e) {
                        LOG.error("Storage read and write error, we will not use this remote path {}.", uri, (Object)e);
                        rankValue.setHealthy(new AtomicBoolean(false));
                    }
                    finally {
                        this.sortPathByRankValue((String)uri.getKey(), rssTest, startWriteTime);
                    }
                    countDownLatch.countDown();
                }
            });
            try {
                countDownLatch.await();
            }
            catch (InterruptedException e) {
                LOG.error("Failed to detectStorage!");
            }
        }
    }

    @VisibleForTesting
    public void sortPathByRankValue(String path, String testPath, long startWrite) {
        RankValue rankValue = this.remoteStoragePathRankValue.get(path);
        try {
            FileSystem fs = HadoopFilesystemProvider.getFilesystem((Path)new Path(path), (Configuration)this.hadoopConf);
            fs.delete(new Path(testPath), true);
            if (rankValue.getHealthy().get()) {
                rankValue.setCostTime(new AtomicLong(System.currentTimeMillis() - startWrite));
            }
        }
        catch (Exception e) {
            rankValue.setCostTime(new AtomicLong(Long.MAX_VALUE));
            LOG.error("Failed to sort, we will not use this remote path {}.", (Object)path, (Object)e);
        }
        this.uris = this.getComparator() != null ? Lists.newCopyOnWriteArrayList(this.remoteStoragePathRankValue.entrySet()).stream().filter(Objects::nonNull).sorted(this.getComparator()).collect(Collectors.toList()) : Lists.newCopyOnWriteArrayList(this.remoteStoragePathRankValue.entrySet()).stream().filter(Objects::nonNull).collect(Collectors.toList());
        LOG.info("The sorted remote path list is: {}", this.uris);
    }

    protected int readAndWriteTimes(CoordinatorConf conf) {
        return 1;
    }

    protected Comparator<Map.Entry<String, RankValue>> getComparator() {
        return null;
    }

    String getCoordinatorId() {
        return this.coordinatorId;
    }
}

