/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.coordinator;

import com.google.protobuf.Empty;
import io.grpc.Context;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.stream.Collectors;
import org.apache.uniffle.common.PartitionRange;
import org.apache.uniffle.common.RemoteStorageInfo;
import org.apache.uniffle.common.ServerStatus;
import org.apache.uniffle.common.storage.StorageInfoUtils;
import org.apache.uniffle.coordinator.AccessManager;
import org.apache.uniffle.coordinator.CoordinatorConf;
import org.apache.uniffle.coordinator.CoordinatorServer;
import org.apache.uniffle.coordinator.ServerNode;
import org.apache.uniffle.coordinator.access.AccessCheckResult;
import org.apache.uniffle.coordinator.access.AccessInfo;
import org.apache.uniffle.coordinator.conf.DynamicClientConfService;
import org.apache.uniffle.coordinator.strategy.assignment.PartitionRangeAssignment;
import org.apache.uniffle.coordinator.util.CoordinatorUtils;
import org.apache.uniffle.guava.collect.Sets;
import org.apache.uniffle.proto.CoordinatorServerGrpc;
import org.apache.uniffle.proto.RssProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoordinatorGrpcService
extends CoordinatorServerGrpc.CoordinatorServerImplBase {
    private static final Logger LOG = LoggerFactory.getLogger(CoordinatorGrpcService.class);
    private final CoordinatorServer coordinatorServer;

    public CoordinatorGrpcService(CoordinatorServer coordinatorServer) {
        this.coordinatorServer = coordinatorServer;
    }

    public void getShuffleServerList(Empty request, StreamObserver<RssProtos.GetShuffleServerListResponse> responseObserver) {
        RssProtos.GetShuffleServerListResponse response = RssProtos.GetShuffleServerListResponse.newBuilder().addAllServers((Iterable)this.coordinatorServer.getClusterManager().list().stream().map(ServerNode::convertToGrpcProto).collect(Collectors.toList())).build();
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void getShuffleServerNum(Empty request, StreamObserver<RssProtos.GetShuffleServerNumResponse> responseObserver) {
        int num = this.coordinatorServer.getClusterManager().getNodesNum();
        RssProtos.GetShuffleServerNumResponse response = RssProtos.GetShuffleServerNumResponse.newBuilder().setNum(num).build();
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getShuffleAssignments(RssProtos.GetShuffleServerRequest request, StreamObserver<RssProtos.GetShuffleAssignmentsResponse> responseObserver) {
        String appId = request.getApplicationId();
        int shuffleId = request.getShuffleId();
        int partitionNum = request.getPartitionNum();
        int partitionNumPerRange = request.getPartitionNumPerRange();
        int replica = request.getDataReplica();
        HashSet<String> requiredTags = Sets.newHashSet(request.getRequireTagsList());
        int requiredShuffleServerNumber = request.getAssignmentShuffleServerNumber();
        int estimateTaskConcurrency = request.getEstimateTaskConcurrency();
        HashSet<String> faultyServerIds = new HashSet<String>((Collection<String>)request.getFaultyServerIdsList());
        LOG.info("Request of getShuffleAssignments for appId[{}], shuffleId[{}], partitionNum[{}],  partitionNumPerRange[{}], replica[{}], requiredTags[{}], requiredShuffleServerNumber[{}],faultyServerIds[{}]", new Object[]{appId, shuffleId, partitionNum, partitionNumPerRange, replica, requiredTags, requiredShuffleServerNumber, faultyServerIds.size()});
        try {
            if (!this.coordinatorServer.getClusterManager().isReadyForServe()) {
                throw new Exception("Coordinator is out-of-service when in starting.");
            }
            PartitionRangeAssignment pra = this.coordinatorServer.getAssignmentStrategy().assign(partitionNum, partitionNumPerRange, replica, requiredTags, requiredShuffleServerNumber, estimateTaskConcurrency, faultyServerIds);
            RssProtos.GetShuffleAssignmentsResponse response = CoordinatorUtils.toGetShuffleAssignmentsResponse(pra);
            this.logAssignmentResult(appId, shuffleId, pra);
            responseObserver.onNext((Object)response);
        }
        catch (Exception e) {
            LOG.error("Errors on getting shuffle assignments for app: {}, shuffleId: {}, partitionNum: {}, partitionNumPerRange: {}, replica: {}, requiredTags: {}", new Object[]{appId, shuffleId, partitionNum, partitionNumPerRange, replica, requiredTags, e});
            RssProtos.GetShuffleAssignmentsResponse response = RssProtos.GetShuffleAssignmentsResponse.newBuilder().setStatus(RssProtos.StatusCode.INTERNAL_ERROR).setRetMsg(e.getMessage()).build();
            responseObserver.onNext((Object)response);
        }
        finally {
            responseObserver.onCompleted();
        }
    }

    public void heartbeat(RssProtos.ShuffleServerHeartBeatRequest request, StreamObserver<RssProtos.ShuffleServerHeartBeatResponse> responseObserver) {
        ServerNode serverNode = this.toServerNode(request);
        this.coordinatorServer.getClusterManager().add(serverNode);
        RssProtos.ShuffleServerHeartBeatResponse response = RssProtos.ShuffleServerHeartBeatResponse.newBuilder().setRetMsg("").setStatus(RssProtos.StatusCode.SUCCESS).build();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Got heartbeat from {}", (Object)serverNode);
        }
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void checkServiceAvailable(Empty request, StreamObserver<RssProtos.CheckServiceAvailableResponse> responseObserver) {
        RssProtos.CheckServiceAvailableResponse response = RssProtos.CheckServiceAvailableResponse.newBuilder().setAvailable(this.coordinatorServer.getClusterManager().getNodesNum() > 0).build();
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void reportClientOperation(RssProtos.ReportShuffleClientOpRequest request, StreamObserver<RssProtos.ReportShuffleClientOpResponse> responseObserver) {
        String clientHost = request.getClientHost();
        int clientPort = request.getClientPort();
        RssProtos.ShuffleServerId shuffleServer = request.getServer();
        String operation = request.getOperation();
        LOG.info(clientHost + ":" + clientPort + "->" + operation + "->" + shuffleServer);
        RssProtos.ReportShuffleClientOpResponse response = RssProtos.ReportShuffleClientOpResponse.newBuilder().setRetMsg("").setStatus(RssProtos.StatusCode.SUCCESS).build();
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void appHeartbeat(RssProtos.AppHeartBeatRequest request, StreamObserver<RssProtos.AppHeartBeatResponse> responseObserver) {
        String appId = request.getAppId();
        this.coordinatorServer.getApplicationManager().refreshAppId(appId);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Got heartbeat from application: {}", (Object)appId);
        }
        RssProtos.AppHeartBeatResponse response = RssProtos.AppHeartBeatResponse.newBuilder().setRetMsg("").setStatus(RssProtos.StatusCode.SUCCESS).build();
        if (Context.current().isCancelled()) {
            responseObserver.onError((Throwable)Status.CANCELLED.withDescription("Cancelled by client").asRuntimeException());
            LOG.warn("Cancelled by client {} for after deadline.", (Object)appId);
            return;
        }
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void registerApplicationInfo(RssProtos.ApplicationInfoRequest request, StreamObserver<RssProtos.ApplicationInfoResponse> responseObserver) {
        String appId = request.getAppId();
        String user = request.getUser();
        this.coordinatorServer.getApplicationManager().registerApplicationInfo(appId, user);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Got a registered application info: {}", (Object)appId);
        }
        RssProtos.ApplicationInfoResponse response = RssProtos.ApplicationInfoResponse.newBuilder().setRetMsg("").setStatus(RssProtos.StatusCode.SUCCESS).build();
        if (Context.current().isCancelled()) {
            responseObserver.onError((Throwable)Status.CANCELLED.withDescription("Cancelled by client").asRuntimeException());
            LOG.warn("Cancelled by client {} for after deadline.", (Object)appId);
            return;
        }
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void accessCluster(RssProtos.AccessClusterRequest request, StreamObserver<RssProtos.AccessClusterResponse> responseObserver) {
        AccessInfo accessInfo;
        RssProtos.StatusCode statusCode = RssProtos.StatusCode.SUCCESS;
        AccessManager accessManager = this.coordinatorServer.getAccessManager();
        AccessCheckResult result = accessManager.handleAccessRequest(accessInfo = new AccessInfo(request.getAccessId(), Sets.newHashSet(request.getTagsList()), request.getExtraPropertiesMap(), request.getUser()));
        if (!result.isSuccess()) {
            statusCode = RssProtos.StatusCode.ACCESS_DENIED;
        }
        RssProtos.AccessClusterResponse response = RssProtos.AccessClusterResponse.newBuilder().setStatus(statusCode).setRetMsg(result.getMsg()).setUuid(result.getUuid()).build();
        if (Context.current().isCancelled()) {
            responseObserver.onError((Throwable)Status.CANCELLED.withDescription("Cancelled by client").asRuntimeException());
            LOG.warn("Cancelled by client {} for after deadline.", (Object)accessInfo);
            return;
        }
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void fetchClientConf(Empty empty, StreamObserver<RssProtos.FetchClientConfResponse> responseObserver) {
        RssProtos.FetchClientConfResponse.Builder builder = RssProtos.FetchClientConfResponse.newBuilder().setStatus(RssProtos.StatusCode.SUCCESS);
        boolean dynamicConfEnabled = this.coordinatorServer.getCoordinatorConf().getBoolean(CoordinatorConf.COORDINATOR_DYNAMIC_CLIENT_CONF_ENABLED);
        if (dynamicConfEnabled) {
            DynamicClientConfService dynamicClientConfService = this.coordinatorServer.getDynamicClientConfService();
            for (Map.Entry<String, String> kv : dynamicClientConfService.getRssClientConf().entrySet()) {
                builder.addClientConf(RssProtos.ClientConfItem.newBuilder().setKey(kv.getKey()).setValue(kv.getValue()).build());
            }
        }
        RssProtos.FetchClientConfResponse response = builder.build();
        if (Context.current().isCancelled()) {
            responseObserver.onError((Throwable)Status.CANCELLED.withDescription("Cancelled by client").asRuntimeException());
            LOG.warn("Fetch client conf cancelled by client for after deadline.");
            return;
        }
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    public void fetchRemoteStorage(RssProtos.FetchRemoteStorageRequest request, StreamObserver<RssProtos.FetchRemoteStorageResponse> responseObserver) {
        RssProtos.FetchRemoteStorageResponse response;
        RssProtos.StatusCode status = RssProtos.StatusCode.SUCCESS;
        String appId = request.getAppId();
        try {
            RssProtos.RemoteStorage.Builder rsBuilder = RssProtos.RemoteStorage.newBuilder();
            RemoteStorageInfo rsInfo = this.coordinatorServer.getApplicationManager().pickRemoteStorage(appId);
            if (rsInfo == null) {
                LOG.error("Remote storage of {} do not exist.", (Object)appId);
            } else {
                rsBuilder.setPath(rsInfo.getPath());
                for (Map.Entry entry : rsInfo.getConfItems().entrySet()) {
                    rsBuilder.addRemoteStorageConf(RssProtos.RemoteStorageConfItem.newBuilder().setKey((String)entry.getKey()).setValue((String)entry.getValue()).build());
                }
            }
            response = RssProtos.FetchRemoteStorageResponse.newBuilder().setStatus(status).setRemoteStorage(rsBuilder.build()).build();
        }
        catch (Exception e) {
            status = RssProtos.StatusCode.INTERNAL_ERROR;
            response = RssProtos.FetchRemoteStorageResponse.newBuilder().setStatus(status).build();
            LOG.error("Error happened when get remote storage for appId[{}]", (Object)appId, (Object)e);
        }
        if (Context.current().isCancelled()) {
            responseObserver.onError((Throwable)Status.CANCELLED.withDescription("Cancelled by client").asRuntimeException());
            LOG.warn("Fetch client conf cancelled by client for after deadline.");
            return;
        }
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    private void logAssignmentResult(String appId, int shuffleId, PartitionRangeAssignment pra) {
        SortedMap<PartitionRange, List<ServerNode>> assignments = pra.getAssignments();
        if (assignments != null) {
            HashSet<String> nodeIds = Sets.newHashSet();
            for (Map.Entry<PartitionRange, List<ServerNode>> entry : assignments.entrySet()) {
                for (ServerNode node : entry.getValue()) {
                    nodeIds.add(node.getId());
                }
            }
            if (!nodeIds.isEmpty()) {
                LOG.info("Shuffle Servers of assignment for appId[{}], shuffleId[{}] are {}", new Object[]{appId, shuffleId, nodeIds});
            }
        }
    }

    private ServerNode toServerNode(RssProtos.ShuffleServerHeartBeatRequest request) {
        ServerStatus serverStatus = request.hasStatus() ? ServerStatus.fromProto((RssProtos.ServerStatus)request.getStatus()) : ServerStatus.ACTIVE;
        boolean isHealthy = true;
        if (request.hasIsHealthy()) {
            isHealthy = request.getIsHealthy().getValue();
            serverStatus = isHealthy ? ServerStatus.ACTIVE : ServerStatus.UNHEALTHY;
        }
        return new ServerNode(request.getServerId().getId(), request.getServerId().getIp(), request.getServerId().getPort(), request.getUsedMemory(), request.getPreAllocatedMemory(), request.getAvailableMemory(), request.getEventNumInFlush(), Sets.newHashSet(request.getTagsList()), serverStatus, StorageInfoUtils.fromProto((Map)request.getStorageInfoMap()), request.getServerId().getNettyPort());
    }
}

