/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.metrics;

import com.google.common.collect.Maps;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.Summary;
import java.util.HashMap;
import java.util.Map;
import org.apache.uniffle.common.metrics.MetricsManager;
import org.apache.uniffle.common.util.JavaUtils;

public abstract class RPCMetrics {
    protected boolean isRegistered = false;
    protected Map<String, Counter.Child> counterMap = JavaUtils.newConcurrentMap();
    protected Map<String, Gauge.Child> gaugeMap = JavaUtils.newConcurrentMap();
    protected Map<String, Summary.Child> transportTimeSummaryMap = JavaUtils.newConcurrentMap();
    protected Map<String, Summary.Child> processTimeSummaryMap = JavaUtils.newConcurrentMap();
    protected MetricsManager metricsManager;
    protected String tags;

    public RPCMetrics(String tags) {
        this.tags = tags;
    }

    public abstract void registerMetrics();

    public abstract void registerGeneralMetrics();

    public void register(CollectorRegistry collectorRegistry) {
        if (!this.isRegistered) {
            HashMap labels = Maps.newHashMap();
            labels.put("label", this.tags);
            this.metricsManager = new MetricsManager(collectorRegistry, labels);
            this.registerGeneralMetrics();
            this.registerMetrics();
            this.isRegistered = true;
        }
    }

    public void setGauge(String tag, double value) {
        Gauge.Child gauge;
        if (this.isRegistered && (gauge = this.gaugeMap.get(tag)) != null) {
            gauge.set(value);
        }
    }

    public void incGauge(String tag) {
        this.incGauge(tag, 1.0);
    }

    public void incGauge(String tag, double value) {
        Gauge.Child gauge;
        if (this.isRegistered && (gauge = this.gaugeMap.get(tag)) != null) {
            gauge.inc(value);
        }
    }

    public void decGauge(String tag) {
        this.decGauge(tag, 1.0);
    }

    public void decGauge(String tag, double value) {
        Gauge.Child gauge;
        if (this.isRegistered && (gauge = this.gaugeMap.get(tag)) != null) {
            gauge.dec(value);
        }
    }

    public void incCounter(String metricKey) {
        if (this.isRegistered) {
            Counter.Child counter;
            Gauge.Child gauge = this.gaugeMap.get(metricKey);
            if (gauge != null) {
                gauge.inc();
            }
            if ((counter = this.counterMap.get(metricKey)) != null) {
                counter.inc();
            }
        }
    }

    public void decCounter(String metricKey) {
        Gauge.Child gauge;
        if (this.isRegistered && (gauge = this.gaugeMap.get(metricKey)) != null) {
            gauge.dec();
        }
    }

    public void recordTransportTime(String methodName, long transportTimeInMillionSecond) {
        Summary.Child summary = this.transportTimeSummaryMap.get(methodName);
        if (summary != null) {
            summary.observe((double)transportTimeInMillionSecond / 1000.0);
        }
    }

    public void recordProcessTime(String methodName, long processTimeInMillionSecond) {
        Summary.Child summary = this.processTimeSummaryMap.get(methodName);
        if (summary != null) {
            summary.observe((double)processTimeInMillionSecond / 1000.0);
        }
    }

    public CollectorRegistry getCollectorRegistry() {
        return this.metricsManager.getCollectorRegistry();
    }

    public Map<String, Counter.Child> getCounterMap() {
        return this.counterMap;
    }

    public Map<String, Gauge.Child> getGaugeMap() {
        return this.gaugeMap;
    }

    public Map<String, Summary.Child> getTransportTimeSummaryMap() {
        return this.transportTimeSummaryMap;
    }

    public Map<String, Summary.Child> getProcessTimeSummaryMap() {
        return this.processTimeSummaryMap;
    }
}

