/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.guava.math;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.uniffle.guava.annotations.GwtIncompatible;
import org.apache.uniffle.guava.math.ElementTypesAreNonnullByDefault;
import org.apache.uniffle.guava.math.ToDoubleRounder;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
public class BigDecimalMath {
    private BigDecimalMath() {
    }

    public static double roundToDouble(BigDecimal x, RoundingMode mode) {
        return BigDecimalToDoubleRounder.INSTANCE.roundToDouble(x, mode);
    }

    private static class BigDecimalToDoubleRounder
    extends ToDoubleRounder<BigDecimal> {
        static final BigDecimalToDoubleRounder INSTANCE = new BigDecimalToDoubleRounder();

        private BigDecimalToDoubleRounder() {
        }

        @Override
        double roundToDoubleArbitrarily(BigDecimal bigDecimal) {
            return bigDecimal.doubleValue();
        }

        @Override
        int sign(BigDecimal bigDecimal) {
            return bigDecimal.signum();
        }

        @Override
        BigDecimal toX(double d, RoundingMode mode) {
            return new BigDecimal(d);
        }

        @Override
        BigDecimal minus(BigDecimal a, BigDecimal b) {
            return a.subtract(b);
        }
    }
}

