/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.storage;

import java.util.Objects;
import org.apache.uniffle.common.storage.StorageMedia;
import org.apache.uniffle.common.storage.StorageStatus;
import org.apache.uniffle.proto.RssProtos;

public class StorageInfo {
    private String mountPoint;
    private StorageMedia type;
    private long capacity;
    private long usedBytes;
    private long writingSpeed1M;
    private long writingSpeed5M;
    private long writingSpeed1H;
    private long numberOfWritingFailures;
    private StorageStatus status;

    public StorageInfo(String mountPoint, StorageMedia type, long capacity, long usedBytes, StorageStatus status) {
        this.mountPoint = mountPoint;
        this.type = type;
        this.capacity = capacity;
        this.usedBytes = usedBytes;
        this.writingSpeed1M = -1L;
        this.writingSpeed5M = -1L;
        this.writingSpeed1H = -1L;
        this.numberOfWritingFailures = -1L;
        this.status = status;
    }

    public StorageInfo(String mountPoint, StorageMedia type, long capacity, long usedBytes, long writingSpeed1M, long writingSpeed5M, long writingSpeed1H, long numberOfWritingFailures, StorageStatus status) {
        this.mountPoint = mountPoint;
        this.type = type;
        this.capacity = capacity;
        this.usedBytes = usedBytes;
        this.writingSpeed1M = writingSpeed1M;
        this.writingSpeed5M = writingSpeed5M;
        this.writingSpeed1H = writingSpeed1H;
        this.numberOfWritingFailures = numberOfWritingFailures;
        this.status = status;
    }

    public RssProtos.StorageInfo toProto() {
        RssProtos.StorageInfo.Builder builder = RssProtos.StorageInfo.newBuilder().setMountPoint(this.mountPoint).setStorageMedia(this.type.toProto()).setCapacity(this.capacity).setUsedBytes(this.usedBytes).setStatus(this.status.toProto());
        if (this.writingSpeed1M >= 0L) {
            builder.setWritingSpeed1M(this.writingSpeed1M);
            builder.setWritingSpeed5M(this.writingSpeed5M);
            builder.setWritingSpeed1H(this.writingSpeed1H);
        }
        if (this.numberOfWritingFailures >= 0L) {
            builder.setNumOfWritingFailures(this.numberOfWritingFailures);
        }
        return builder.build();
    }

    public StorageStatus getStatus() {
        return this.status;
    }

    public StorageMedia getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StorageInfo that = (StorageInfo)o;
        return Objects.equals(this.mountPoint, that.mountPoint) && this.type == that.type && this.capacity == that.capacity && this.usedBytes == that.usedBytes && this.writingSpeed1M == that.writingSpeed1M && this.writingSpeed5M == that.writingSpeed5M && this.writingSpeed1H == that.writingSpeed1H && this.numberOfWritingFailures == that.numberOfWritingFailures && this.status == that.status;
    }

    public int hashCode() {
        int hash = 41;
        hash = 37 * hash + Objects.hashCode(this.mountPoint);
        hash = 19 * hash + Objects.hashCode((Object)this.type);
        hash = 37 * hash + (int)this.capacity;
        hash = 37 * hash + (int)this.usedBytes;
        hash = 37 * hash + (int)this.writingSpeed1M;
        hash = 37 * hash + (int)this.writingSpeed5M;
        hash = 37 * hash + (int)this.writingSpeed1H;
        hash = 37 * hash + (int)this.numberOfWritingFailures;
        hash = 19 * hash + Objects.hashCode((Object)this.status);
        return hash;
    }
}

