/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.storage.common;

import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import org.apache.uniffle.common.util.JavaUtils;
import org.apache.uniffle.common.util.RssUtils;
import org.apache.uniffle.storage.common.Storage;
import org.apache.uniffle.storage.handler.api.ServerReadHandler;
import org.apache.uniffle.storage.handler.api.ShuffleWriteHandler;
import org.apache.uniffle.storage.request.CreateShuffleReadHandlerRequest;
import org.apache.uniffle.storage.request.CreateShuffleWriteHandlerRequest;
import org.apache.uniffle.storage.util.ShuffleStorageUtils;

public abstract class AbstractStorage
implements Storage {
    private Map<String, Map<String, ShuffleWriteHandler>> writerHandlers = JavaUtils.newConcurrentMap();
    private Map<String, Map<String, CreateShuffleWriteHandlerRequest>> requests = JavaUtils.newConcurrentMap();
    private Map<String, Map<String, ServerReadHandler>> readerHandlers = JavaUtils.newConcurrentMap();

    abstract ShuffleWriteHandler newWriteHandler(CreateShuffleWriteHandlerRequest var1);

    @Override
    public ShuffleWriteHandler getOrCreateWriteHandler(CreateShuffleWriteHandlerRequest request) {
        this.writerHandlers.computeIfAbsent(request.getAppId(), key -> JavaUtils.newConcurrentMap());
        this.requests.computeIfAbsent(request.getAppId(), key -> JavaUtils.newConcurrentMap());
        Map<String, ShuffleWriteHandler> map = this.writerHandlers.get(request.getAppId());
        String partitionKey = RssUtils.generatePartitionKey((String)request.getAppId(), (Integer)request.getShuffleId(), (Integer)request.getStartPartition());
        map.computeIfAbsent(partitionKey, key -> this.newWriteHandler(request));
        Map<String, CreateShuffleWriteHandlerRequest> requestMap = this.requests.get(request.getAppId());
        requestMap.putIfAbsent(partitionKey, request);
        return map.get(partitionKey);
    }

    @Override
    public ServerReadHandler getOrCreateReadHandler(CreateShuffleReadHandlerRequest request) {
        this.readerHandlers.computeIfAbsent(request.getAppId(), key -> JavaUtils.newConcurrentMap());
        Map<String, ServerReadHandler> map = this.readerHandlers.get(request.getAppId());
        int[] range = ShuffleStorageUtils.getPartitionRange(request.getPartitionId(), request.getPartitionNumPerRange(), request.getPartitionNum());
        String partitionKey = RssUtils.generatePartitionKey((String)request.getAppId(), (Integer)request.getShuffleId(), (Integer)range[0]);
        map.computeIfAbsent(partitionKey, key -> this.newReadHandler(request));
        return map.get(partitionKey);
    }

    protected abstract ServerReadHandler newReadHandler(CreateShuffleReadHandlerRequest var1);

    public boolean containsWriteHandler(String appId, int shuffleId, int partition) {
        Map<String, ShuffleWriteHandler> map = this.writerHandlers.get(appId);
        if (map == null || map.isEmpty()) {
            return false;
        }
        String partitionKey = RssUtils.generatePartitionKey((String)appId, (Integer)shuffleId, (Integer)partition);
        return map.containsKey(partitionKey);
    }

    @Override
    public void removeHandlers(String appId) {
        this.writerHandlers.remove(appId);
        this.readerHandlers.remove(appId);
        this.requests.remove(appId);
    }

    @VisibleForTesting
    public int getHandlerSize() {
        return this.writerHandlers.size();
    }
}

