/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.server;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.uniffle.common.ShufflePartitionedBlock;
import org.apache.uniffle.server.buffer.ShuffleBuffer;
import org.apache.uniffle.storage.common.Storage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShuffleDataFlushEvent {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShuffleDataFlushEvent.class);
    private final long eventId;
    private final String appId;
    private final int shuffleId;
    private final int startPartition;
    private final int endPartition;
    private final long size;
    private final List<ShufflePartitionedBlock> shuffleBlocks;
    private final Supplier<Boolean> valid;
    private final ShuffleBuffer shuffleBuffer;
    private final AtomicInteger retryTimes = new AtomicInteger();
    private boolean isPended = false;
    private Storage underStorage;
    private final List<Runnable> cleanupCallbackChains;
    private boolean ownedByHugePartition = false;
    private long startPendingTime;

    public ShuffleDataFlushEvent(long eventId, String appId, int shuffleId, int startPartition, int endPartition, long size, List<ShufflePartitionedBlock> shuffleBlocks, Supplier<Boolean> valid, ShuffleBuffer shuffleBuffer) {
        this.eventId = eventId;
        this.appId = appId;
        this.shuffleId = shuffleId;
        this.startPartition = startPartition;
        this.endPartition = endPartition;
        this.size = size;
        this.shuffleBlocks = shuffleBlocks;
        this.valid = valid;
        this.shuffleBuffer = shuffleBuffer;
        this.cleanupCallbackChains = new ArrayList<Runnable>();
    }

    public List<ShufflePartitionedBlock> getShuffleBlocks() {
        return this.shuffleBlocks;
    }

    public long getEventId() {
        return this.eventId;
    }

    public long getSize() {
        return this.size;
    }

    public String getAppId() {
        return this.appId;
    }

    public int getShuffleId() {
        return this.shuffleId;
    }

    public int getStartPartition() {
        return this.startPartition;
    }

    public int getEndPartition() {
        return this.endPartition;
    }

    public ShuffleBuffer getShuffleBuffer() {
        return this.shuffleBuffer;
    }

    public boolean isValid() {
        if (this.valid == null) {
            return true;
        }
        return this.valid.get();
    }

    public int getRetryTimes() {
        return this.retryTimes.get();
    }

    public void increaseRetryTimes() {
        this.retryTimes.incrementAndGet();
    }

    public boolean isPended() {
        return this.isPended;
    }

    public void markPended() {
        this.isPended = true;
        this.startPendingTime = System.currentTimeMillis();
    }

    public Storage getUnderStorage() {
        return this.underStorage;
    }

    public void setUnderStorage(Storage underStorage) {
        this.underStorage = underStorage;
    }

    public boolean doCleanup() {
        boolean ret = true;
        for (Runnable cleanupCallback : this.cleanupCallbackChains) {
            try {
                cleanupCallback.run();
            }
            catch (Exception e) {
                ret = false;
                LOGGER.error("Errors doing cleanup callback. event: {}", (Object)this, (Object)e);
            }
        }
        return ret;
    }

    public void addCleanupCallback(Runnable cleanupCallback) {
        if (cleanupCallback != null) {
            this.cleanupCallbackChains.add(cleanupCallback);
        }
    }

    public String toString() {
        return "ShuffleDataFlushEvent: eventId=" + this.eventId + ", appId=" + this.appId + ", shuffleId=" + this.shuffleId + ", startPartition=" + this.startPartition + ", endPartition=" + this.endPartition + ", retryTimes=" + this.retryTimes + ", underStorage=" + (this.underStorage == null ? null : this.underStorage.getClass().getSimpleName()) + ", isPended=" + this.isPended;
    }

    public boolean isOwnedByHugePartition() {
        return this.ownedByHugePartition;
    }

    public void markOwnedByHugePartition() {
        this.ownedByHugePartition = true;
    }

    public long getStartPendingTime() {
        return this.startPendingTime;
    }
}

