/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.guava.util.concurrent;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.RunnableFuture;
import org.apache.uniffle.guava.annotations.Beta;
import org.apache.uniffle.guava.annotations.GwtIncompatible;
import org.apache.uniffle.guava.util.concurrent.ElementTypesAreNonnullByDefault;
import org.apache.uniffle.guava.util.concurrent.ListenableFuture;
import org.apache.uniffle.guava.util.concurrent.ListeningExecutorService;
import org.apache.uniffle.guava.util.concurrent.ParametricNullness;
import org.apache.uniffle.guava.util.concurrent.TrustedListenableFutureTask;

@ElementTypesAreNonnullByDefault
@Beta
@CanIgnoreReturnValue
@GwtIncompatible
public abstract class AbstractListeningExecutorService
extends AbstractExecutorService
implements ListeningExecutorService {
    @Override
    protected final <T> RunnableFuture<T> newTaskFor(Runnable runnable, @ParametricNullness T value) {
        return TrustedListenableFutureTask.create(runnable, value);
    }

    @Override
    protected final <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return TrustedListenableFutureTask.create(callable);
    }

    @Override
    public ListenableFuture<?> submit(Runnable task) {
        return (ListenableFuture)super.submit(task);
    }

    @Override
    public <T> ListenableFuture<T> submit(Runnable task, @ParametricNullness T result) {
        return (ListenableFuture)super.submit(task, result);
    }

    @Override
    public <T> ListenableFuture<T> submit(Callable<T> task) {
        return (ListenableFuture)super.submit(task);
    }
}

