/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.pear.tools;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.parsers.SAXParser;
import org.apache.uima.pear.tools.InstallationDescriptor;
import org.apache.uima.pear.util.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class InstallationDescriptorHandler
extends DefaultHandler {
    protected static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    public static final String ROOT_TAG = "COMPONENT_INSTALLATION_DESCRIPTOR";
    public static final String OS_TAG = "OS";
    public static final String NAME_TAG = "NAME";
    public static final String VERSION_TAG = "VERSION";
    public static final String TOOLKITS_TAG = "TOOLKITS";
    public static final String JDK_VERSION_TAG = "JDK_VERSION";
    public static final String UIMA_FRAMEWORK_TAG = "UIMA_FRAMEWORK";
    public static final String UIMA_VERSION_TAG = "UIMA_VERSION";
    public static final String TAF_VERSION_TAG = "TAF_VERSION";
    public static final String SUBMITTED_COMPONENT_TAG = "SUBMITTED_COMPONENT";
    public static final String ID_TAG = "ID";
    public static final String DESC_TAG = "DESC";
    public static final String DEPLOYMENT_TAG = "DEPLOYMENT";
    public static final String STANDARD_TAG = "standard";
    public static final String SERVICE_TAG = "service";
    public static final String NETWORK_TAG = "network";
    public static final String SERVICE_COMMAND_TAG = "SERVICE_COMMAND";
    public static final String SERVICE_WORKING_DIR_TAG = "SERVICE_WORKING_DIR";
    public static final String SERVICE_COMMAND_ARGS_TAG = "SERVICE_COMMAND_ARGS";
    public static final String ARGUMENT_TAG = "ARGUMENT";
    public static final String VALUE_TAG = "VALUE";
    public static final String NETWORK_PARAMETERS_TAG = "NETWORK_PARAMETERS";
    public static final String COMMENTS_TAG = "COMMENTS";
    public static final String COLLECTION_READER_TAG = "COLLECTION_READER";
    public static final String COLLECTION_ITERATOR_DESC_TAG = "COLLECTION_ITERATOR_DESC";
    public static final String CAS_INITIALIZER_DESC_TAG = "CAS_INITIALIZER_DESC";
    public static final String CAS_CONSUMER_TAG = "CAS_CONSUMER";
    public static final String INSTALLATION_TAG = "INSTALLATION";
    public static final String DELEGATE_COMPONENT_TAG = "DELEGATE_COMPONENT";
    public static final String PROCESS_TAG = "PROCESS";
    public static final String ACTION_TAG = "ACTION";
    public static final String PARAMETERS_TAG = "PARAMETERS";
    public static final String FILE_TAG = "FILE";
    public static final String FIND_STRING_TAG = "FIND_STRING";
    public static final String REPLACE_WITH_TAG = "REPLACE_WITH";
    public static final String VAR_NAME_TAG = "VAR_NAME";
    public static final String VAR_VALUE_TAG = "VAR_VALUE";
    private SAXParser _parser = null;
    private StringBuffer _activeBuffer = new StringBuffer();
    private String _mainTag = null;
    private InstallationDescriptor _insdObject = null;
    private String _activeSection = "";
    private String _activeSubSection = "";
    private String _activeComponentId = null;
    private InstallationDescriptor.ActionInfo _activeAction = null;
    private InstallationDescriptor.ServiceInfo _activeService = null;
    private InstallationDescriptor.ArgInfo _activeArg = null;
    private boolean _insdLoaded = false;

    public static InputStream getInstallationDescriptorAsStream(InstallationDescriptor insdObject) throws IOException {
        ByteArrayInputStream iStream = null;
        StringBuffer xmlBuffer = new StringBuffer();
        xmlBuffer.append(XML_HEADER);
        xmlBuffer.append('\n');
        xmlBuffer.append(insdObject.toString());
        byte[] xmlContentBytes = xmlBuffer.toString().getBytes(StandardCharsets.UTF_8);
        iStream = new ByteArrayInputStream(xmlContentBytes);
        return iStream;
    }

    public static void printInstallationDescriptor(InstallationDescriptor insdObject, PrintWriter oWriter) throws IOException {
        String[] tagOrder = null;
        XMLUtil.printXMLTag(ROOT_TAG, oWriter, false, 0);
        oWriter.println();
        XMLUtil.printXMLTag(OS_TAG, oWriter, false, 1);
        oWriter.println();
        tagOrder = new String[]{NAME_TAG};
        if (insdObject.getOSSpecs().size() > 0) {
            XMLUtil.printAllXMLElements(insdObject.getOSSpecs(), "\n", tagOrder, oWriter, 2);
        }
        XMLUtil.printXMLTag(OS_TAG, oWriter, true, 1);
        oWriter.println();
        XMLUtil.printXMLTag(TOOLKITS_TAG, oWriter, false, 1);
        oWriter.println();
        if (insdObject.getToolkitsSpecs().size() > 0) {
            XMLUtil.printAllXMLElements(insdObject.getToolkitsSpecs(), "\n", null, oWriter, 2);
        }
        XMLUtil.printXMLTag(TOOLKITS_TAG, oWriter, true, 1);
        oWriter.println();
        XMLUtil.printXMLTag(UIMA_FRAMEWORK_TAG, oWriter, false, 1);
        oWriter.println();
        if (insdObject.getFrameworkSpecs().size() > 0) {
            XMLUtil.printAllXMLElements(insdObject.getFrameworkSpecs(), "\n", null, oWriter, 2);
        }
        XMLUtil.printXMLTag(UIMA_FRAMEWORK_TAG, oWriter, true, 1);
        oWriter.println();
        XMLUtil.printXMLTag(SUBMITTED_COMPONENT_TAG, oWriter, false, 1);
        oWriter.println();
        if (insdObject.getMainComponentId() != null) {
            String casConsDesc;
            Set<String> netParamNames;
            XMLUtil.printXMLElement(ID_TAG, insdObject.getMainComponentId(), oWriter, 2);
            oWriter.println();
            XMLUtil.printXMLElement(NAME_TAG, insdObject.getMainComponentName(), oWriter, 2);
            oWriter.println();
            XMLUtil.printXMLElement(DESC_TAG, insdObject.getMainComponentDesc(), oWriter, 2);
            oWriter.println();
            XMLUtil.printXMLElement(DEPLOYMENT_TAG, insdObject.getMainComponentDeployment(), oWriter, 2);
            oWriter.println();
            InstallationDescriptor.ServiceInfo service = insdObject.getMainComponentService();
            if (service != null) {
                XMLUtil.printXMLElement(SERVICE_COMMAND_TAG, service.command, oWriter, 2);
                oWriter.println();
                XMLUtil.printXMLElement(SERVICE_WORKING_DIR_TAG, service.workingDirPath, oWriter, 2);
                oWriter.println();
                XMLUtil.printXMLTag(SERVICE_COMMAND_ARGS_TAG, oWriter, false, 2);
                oWriter.println();
                Iterator<InstallationDescriptor.ArgInfo> argList = service.getArgs().iterator();
                while (argList.hasNext()) {
                    XMLUtil.printXMLTag(ARGUMENT_TAG, oWriter, false, 3);
                    oWriter.println();
                    InstallationDescriptor.ArgInfo arg = argList.next();
                    XMLUtil.printXMLElement(VALUE_TAG, arg.value, oWriter, 4);
                    oWriter.println();
                    XMLUtil.printXMLElement(COMMENTS_TAG, arg.comments, oWriter, 4);
                    oWriter.println();
                    XMLUtil.printXMLTag(ARGUMENT_TAG, oWriter, true, 3);
                    oWriter.println();
                }
                XMLUtil.printXMLTag(SERVICE_COMMAND_ARGS_TAG, oWriter, true, 2);
                oWriter.println();
            }
            if ((netParamNames = insdObject.getMainComponentNetworkParamNames()) != null) {
                XMLUtil.printXMLTag(NETWORK_PARAMETERS_TAG, oWriter, false, 2);
                oWriter.println();
                for (String name : netParamNames) {
                    Properties attributes = insdObject.getMainComponentNetworkParam(name);
                    XMLUtil.printXMLElement(name, attributes, null, oWriter, 3);
                    oWriter.println();
                }
                XMLUtil.printXMLTag(NETWORK_PARAMETERS_TAG, oWriter, true, 2);
                oWriter.println();
            }
            if (insdObject.getMainComponentProps().size() > 0) {
                XMLUtil.printAllXMLElements(insdObject.getMainComponentProps(), oWriter, 2);
            }
            String collIterDesc = insdObject.getMainCollIteratorDesc();
            String casInitDesc = insdObject.getMainCasInitializerDesc();
            if (collIterDesc != null || casInitDesc != null) {
                XMLUtil.printXMLTag(COLLECTION_READER_TAG, oWriter, false, 2);
                oWriter.println();
                if (collIterDesc != null) {
                    XMLUtil.printXMLElement(COLLECTION_ITERATOR_DESC_TAG, collIterDesc, oWriter, 3);
                    oWriter.println();
                }
                if (casInitDesc != null) {
                    XMLUtil.printXMLElement(CAS_INITIALIZER_DESC_TAG, casInitDesc, oWriter, 3);
                    oWriter.println();
                }
                XMLUtil.printXMLTag(COLLECTION_READER_TAG, oWriter, true, 2);
                oWriter.println();
            }
            if ((casConsDesc = insdObject.getMainCasConsumerDesc()) != null) {
                XMLUtil.printXMLTag(CAS_CONSUMER_TAG, oWriter, false, 2);
                oWriter.println();
                XMLUtil.printXMLElement(DESC_TAG, casConsDesc, oWriter, 3);
                oWriter.println();
                XMLUtil.printXMLTag(CAS_CONSUMER_TAG, oWriter, true, 2);
                oWriter.println();
            }
        }
        XMLUtil.printXMLTag(SUBMITTED_COMPONENT_TAG, oWriter, true, 1);
        oWriter.println();
        XMLUtil.printXMLTag(INSTALLATION_TAG, oWriter, false, 1);
        oWriter.println();
        Hashtable<String, InstallationDescriptor.ComponentInfo> dlgTable = insdObject.getDelegateComponents();
        Iterator<String> dlgList = dlgTable.keySet().iterator();
        while (dlgList.hasNext()) {
            XMLUtil.printXMLTag(DELEGATE_COMPONENT_TAG, oWriter, false, 2);
            oWriter.println();
            String dlgId = dlgList.next();
            InstallationDescriptor.ComponentInfo dlgInfo = dlgTable.get(dlgId);
            XMLUtil.printXMLElement(ID_TAG, dlgId, oWriter, 3);
            oWriter.println();
            XMLUtil.printXMLElement(NAME_TAG, dlgInfo.name, oWriter, 3);
            oWriter.println();
            XMLUtil.printXMLTag(DELEGATE_COMPONENT_TAG, oWriter, true, 2);
            oWriter.println();
        }
        for (InstallationDescriptor.ActionInfo actInfo : insdObject.getInstallationActions()) {
            XMLUtil.printXMLTag(PROCESS_TAG, oWriter, false, 2);
            oWriter.println();
            XMLUtil.printXMLElement(ACTION_TAG, actInfo.getName(), oWriter, 3);
            oWriter.println();
            XMLUtil.printXMLTag(PARAMETERS_TAG, oWriter, false, 3);
            oWriter.println();
            if (actInfo.params != null && actInfo.params.size() > 0) {
                XMLUtil.printAllXMLElements(actInfo.params, oWriter, 4);
            }
            XMLUtil.printXMLTag(PARAMETERS_TAG, oWriter, true, 3);
            oWriter.println();
            XMLUtil.printXMLTag(PROCESS_TAG, oWriter, true, 2);
            oWriter.println();
        }
        XMLUtil.printXMLTag(INSTALLATION_TAG, oWriter, true, 1);
        oWriter.println();
        XMLUtil.printXMLTag(ROOT_TAG, oWriter, true, 0);
        oWriter.println();
    }

    public static void saveInstallationDescriptor(InstallationDescriptor insdObject, File xmlFile) throws IOException {
        try (PrintWriter oWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(xmlFile), StandardCharsets.UTF_8));){
            oWriter.println(XML_HEADER);
            InstallationDescriptorHandler.printInstallationDescriptor(insdObject, oWriter);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this._activeBuffer.append(ch, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
        this._insdLoaded = true;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String elemValue = this._activeBuffer.toString().trim();
        if (OS_TAG.equals(this._activeSection)) {
            if (localName.equalsIgnoreCase(OS_TAG)) {
                this._activeSection = "";
            } else {
                this._insdObject.addOSSpec(localName, elemValue);
            }
        } else if (TOOLKITS_TAG.equals(this._activeSection)) {
            if (localName.equalsIgnoreCase(TOOLKITS_TAG)) {
                this._activeSection = "";
            } else {
                this._insdObject.addToolkitsSpec(localName, elemValue);
            }
        } else if (UIMA_FRAMEWORK_TAG.equals(this._activeSection)) {
            if (localName.equalsIgnoreCase(UIMA_FRAMEWORK_TAG)) {
                this._activeSection = "";
            } else {
                this._insdObject.addFrameworkSpec(localName, elemValue);
            }
        } else if (SUBMITTED_COMPONENT_TAG.equals(this._activeSection)) {
            if (localName.equalsIgnoreCase(SUBMITTED_COMPONENT_TAG)) {
                this._activeSection = "";
                if (this._activeService != null) {
                    this._insdObject.setMainComponentService(this._activeService);
                }
                this._activeService = null;
            } else if (localName.equalsIgnoreCase(SERVICE_COMMAND_ARGS_TAG)) {
                this._activeSubSection = "";
            } else if (localName.equalsIgnoreCase(COLLECTION_READER_TAG)) {
                this._activeSubSection = "";
            } else if (localName.equalsIgnoreCase(CAS_CONSUMER_TAG)) {
                this._activeSubSection = "";
            } else if (localName.equalsIgnoreCase(ID_TAG)) {
                this._activeComponentId = elemValue;
                this._insdObject.setMainComponent(this._activeComponentId, "");
                this._activeService = new InstallationDescriptor.ServiceInfo();
            } else if (localName.equalsIgnoreCase(NAME_TAG)) {
                if (this._activeComponentId != null) {
                    this._insdObject.setMainComponentName(elemValue);
                    this._activeComponentId = null;
                }
            } else if (localName.equalsIgnoreCase(DESC_TAG)) {
                if (CAS_CONSUMER_TAG.equals(this._activeSubSection)) {
                    this._insdObject.setMainCasConsumerDesc(elemValue);
                } else {
                    this._insdObject.setMainComponentDesc(elemValue);
                }
            } else if (localName.equalsIgnoreCase(DEPLOYMENT_TAG)) {
                this._insdObject.setMainComponentDeployment(elemValue);
            } else if (localName.equalsIgnoreCase(SERVICE_COMMAND_TAG)) {
                if (this._activeService != null) {
                    this._activeService.command = elemValue;
                }
            } else if (localName.equalsIgnoreCase(SERVICE_WORKING_DIR_TAG)) {
                if (this._activeService != null) {
                    this._activeService.workingDirPath = elemValue;
                }
            } else if (localName.equalsIgnoreCase(VALUE_TAG)) {
                if (SERVICE_COMMAND_ARGS_TAG.equals(this._activeSubSection) && this._activeArg != null) {
                    this._activeArg.value = elemValue;
                }
            } else if (localName.equalsIgnoreCase(ARGUMENT_TAG)) {
                if (SERVICE_COMMAND_ARGS_TAG.equals(this._activeSubSection) && this._activeService != null && this._activeArg != null && this._activeArg.value != null && this._activeArg.value.length() > 0) {
                    this._activeService.addArg(this._activeArg);
                }
                this._activeArg = null;
            } else if (localName.equalsIgnoreCase(NETWORK_PARAMETERS_TAG)) {
                if (NETWORK_PARAMETERS_TAG.equals(this._activeSubSection)) {
                    this._activeSubSection = "";
                }
            } else if (localName.equalsIgnoreCase(COMMENTS_TAG)) {
                if (SERVICE_COMMAND_ARGS_TAG.equals(this._activeSubSection)) {
                    if (this._activeArg != null) {
                        this._activeArg.comments = elemValue;
                    }
                } else {
                    this._insdObject.setMainComponentProperty(COMMENTS_TAG, elemValue);
                }
            } else if (localName.equalsIgnoreCase(COLLECTION_ITERATOR_DESC_TAG)) {
                this._insdObject.setMainCollIteratorDesc(elemValue);
            } else if (localName.equalsIgnoreCase(CAS_INITIALIZER_DESC_TAG)) {
                this._insdObject.setMainCasInitializerDesc(elemValue);
            } else {
                this._insdObject.setMainComponentProperty(localName, elemValue);
            }
        } else if (INSTALLATION_TAG.equals(this._activeSection)) {
            if (localName.equalsIgnoreCase(INSTALLATION_TAG)) {
                this._activeSection = "";
            } else if (localName.equalsIgnoreCase(DELEGATE_COMPONENT_TAG)) {
                this._activeSubSection = "";
            } else if (localName.equalsIgnoreCase(PROCESS_TAG)) {
                if (this._activeAction != null) {
                    this._insdObject.addInstallationAction(this._activeAction);
                    this._activeAction = null;
                }
                this._activeSubSection = "";
            } else if (!localName.equalsIgnoreCase(PARAMETERS_TAG)) {
                if (localName.equalsIgnoreCase(ID_TAG)) {
                    this._activeComponentId = elemValue;
                } else if (localName.equalsIgnoreCase(NAME_TAG)) {
                    if (DELEGATE_COMPONENT_TAG.equals(this._activeSubSection) && this._activeComponentId != null) {
                        this._insdObject.addDelegateComponent(this._activeComponentId, elemValue);
                        this._activeComponentId = null;
                    }
                } else if (localName.equalsIgnoreCase(ACTION_TAG)) {
                    if (PROCESS_TAG.equals(this._activeSubSection)) {
                        this._activeAction = new InstallationDescriptor.ActionInfo(elemValue);
                    }
                } else if (this._activeAction != null) {
                    this._activeAction.params.setProperty(localName, elemValue);
                }
            }
        }
    }

    @Override
    public void error(SAXParseException ex) throws SAXException {
        XMLUtil.printError("Error", ex);
    }

    @Override
    public void fatalError(SAXParseException ex) throws SAXException {
        XMLUtil.printError("Fatal Error", ex);
        throw ex;
    }

    public synchronized InstallationDescriptor getInstallationDescriptor() {
        return this._insdLoaded ? this._insdObject : null;
    }

    public synchronized void parse(File xmlFile) throws IOException, SAXException {
        if (this._parser == null) {
            this._parser = XMLUtil.createSAXParser();
        }
        this._insdObject = new InstallationDescriptor(xmlFile);
        this._insdLoaded = false;
        this._parser.parse(xmlFile, (DefaultHandler)this);
    }

    public synchronized void parse(InputStream xmlStream) throws IOException, SAXException {
        if (this._parser == null) {
            this._parser = XMLUtil.createSAXParser();
        }
        this._insdObject = new InstallationDescriptor();
        this._insdLoaded = false;
        this._parser.parse(xmlStream, (DefaultHandler)this);
    }

    public synchronized void parseInstallationDescriptor(JarFile pearFile) throws IOException, SAXException {
        String insdFilePath = "metadata/install.xml";
        JarEntry insdJarEntry = pearFile.getJarEntry(insdFilePath);
        if (insdJarEntry == null) {
            throw new IOException("installation drescriptor not found");
        }
        this.parse(pearFile.getInputStream(insdJarEntry));
    }

    public synchronized void saveInstallationDescriptor(File xmlFile) throws IOException {
        if (this._insdLoaded) {
            InstallationDescriptorHandler.saveInstallationDescriptor(this._insdObject, xmlFile);
        }
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this._mainTag = localName;
        this._activeBuffer.setLength(0);
        if (this._mainTag.equalsIgnoreCase(OS_TAG)) {
            this._activeSection = OS_TAG;
        } else if (this._mainTag.equalsIgnoreCase(TOOLKITS_TAG)) {
            this._activeSection = TOOLKITS_TAG;
        } else if (this._mainTag.equalsIgnoreCase(UIMA_FRAMEWORK_TAG)) {
            this._activeSection = UIMA_FRAMEWORK_TAG;
        } else if (this._mainTag.equalsIgnoreCase(SUBMITTED_COMPONENT_TAG)) {
            this._activeSection = SUBMITTED_COMPONENT_TAG;
            this._activeComponentId = null;
        } else if (this._mainTag.equalsIgnoreCase(SERVICE_COMMAND_ARGS_TAG)) {
            if (SUBMITTED_COMPONENT_TAG.equals(this._activeSection)) {
                this._activeSubSection = SERVICE_COMMAND_ARGS_TAG;
            }
        } else if (this._mainTag.equalsIgnoreCase(ARGUMENT_TAG)) {
            if (SUBMITTED_COMPONENT_TAG.equals(this._activeSection) && SERVICE_COMMAND_ARGS_TAG.equals(this._activeSubSection)) {
                this._activeArg = new InstallationDescriptor.ArgInfo();
            }
        } else if (this._mainTag.equalsIgnoreCase(NETWORK_PARAMETERS_TAG)) {
            if (SUBMITTED_COMPONENT_TAG.equals(this._activeSection)) {
                this._activeSubSection = NETWORK_PARAMETERS_TAG;
            }
        } else if (this._mainTag.equalsIgnoreCase(CAS_CONSUMER_TAG)) {
            if (SUBMITTED_COMPONENT_TAG.equals(this._activeSection)) {
                this._activeSubSection = CAS_CONSUMER_TAG;
            }
        } else if (this._mainTag.equalsIgnoreCase(INSTALLATION_TAG)) {
            this._activeSection = INSTALLATION_TAG;
        } else if (this._mainTag.equalsIgnoreCase(DELEGATE_COMPONENT_TAG)) {
            if (INSTALLATION_TAG.equals(this._activeSection)) {
                this._activeSubSection = DELEGATE_COMPONENT_TAG;
                this._activeComponentId = null;
            }
        } else if (this._mainTag.equalsIgnoreCase(PROCESS_TAG)) {
            if (INSTALLATION_TAG.equals(this._activeSection)) {
                this._activeSubSection = PROCESS_TAG;
                this._activeAction = null;
            }
        } else if (NETWORK_PARAMETERS_TAG.equals(this._activeSubSection)) {
            String paramName = this._mainTag;
            int attrCount = attributes.getLength();
            Properties paramSpecs = new Properties();
            for (int i = 0; i < attrCount; ++i) {
                String name = attributes.getLocalName(i);
                String value = attributes.getValue(i);
                paramSpecs.setProperty(name, value);
            }
            if (paramSpecs.size() > 0) {
                this._insdObject.setMainComponentNetworkParam(paramName, paramSpecs);
            }
        }
    }

    @Override
    public void warning(SAXParseException ex) throws SAXException {
        XMLUtil.printError("Warning", ex);
    }
}

