/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.expression.bool;

import java.util.List;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.expression.annotation.IAnnotationListExpression;
import org.apache.uima.ruta.expression.bool.AbstractBooleanExpression;
import org.apache.uima.ruta.rule.MatchContext;

public class BooleanAnnotationListExpression
extends AbstractBooleanExpression {
    private final IAnnotationListExpression e1;
    private final String op;
    private final IAnnotationListExpression e2;

    public BooleanAnnotationListExpression(IAnnotationListExpression e1, String op, IAnnotationListExpression e2) {
        this.e1 = e1;
        this.op = op;
        this.e2 = e2;
    }

    @Override
    public boolean getBooleanValue(MatchContext context, RutaStream stream) {
        List<AnnotationFS> first = this.getFristExpression().getAnnotationList(context, stream);
        List<AnnotationFS> second = this.getSecondExpression().getAnnotationList(context, stream);
        return this.eval(first, this.getOperator(), second);
    }

    private boolean eval(List<AnnotationFS> t1, String op, List<AnnotationFS> t2) {
        if ("==".equals(op)) {
            if (t1 == null) {
                return t2 == null;
            }
            return t1.equals(t2);
        }
        if ("!=".equals(op)) {
            if (t1 == null) {
                return t2 != null;
            }
            return !t1.equals(t2);
        }
        return false;
    }

    public IAnnotationListExpression getFristExpression() {
        return this.e1;
    }

    public String getOperator() {
        return this.op;
    }

    public IAnnotationListExpression getSecondExpression() {
        return this.e2;
    }

    @Override
    public String getStringValue(MatchContext context, RutaStream stream) {
        return this.e1.getStringValue(context, stream) + " " + this.op + " " + this.e2.getStringValue(context, stream);
    }
}

