/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.sql;

import java.util.List;
import org.apache.torque.Database;
import org.apache.torque.Torque;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.criteria.Criterion;
import org.apache.torque.criteria.FromElement;
import org.apache.torque.criteria.Join;
import org.apache.torque.criteria.JoinType;
import org.apache.torque.criteria.PreparedStatementPart;
import org.apache.torque.criteria.PreparedStatementPartImpl;
import org.apache.torque.sql.Query;
import org.apache.torque.sql.SqlBuilder;
import org.apache.torque.util.UniqueList;

public final class JoinBuilder {
    private JoinBuilder() {
    }

    public static void processJoins(Criteria criteria, Query query) throws TorqueException {
        if (criteria.isComposite()) {
            return;
        }
        List<Join> criteriaJoins = criteria.getJoins();
        if (criteriaJoins.isEmpty()) {
            return;
        }
        UniqueList<FromElement> queryFromClause = query.getFromClause();
        UniqueList<String> queryWhereClause = query.getWhereClause();
        for (int i = 0; i < criteriaJoins.size(); ++i) {
            FromElement fromElement;
            PreparedStatementPart rightExpression;
            PreparedStatementPart leftExpression;
            Join join = criteriaJoins.get(i);
            JoinType joinType = join.getJoinType();
            if (joinType == null) {
                StringBuilder joinConditionStringBuilder = new StringBuilder();
                SqlBuilder.appendCriterion(join.getJoinCondition(), criteria, joinConditionStringBuilder, query);
                queryWhereClause.add(joinConditionStringBuilder.toString());
                continue;
            }
            Criterion joinCondition = join.getJoinCondition();
            if (join.getLeftTable() != null) {
                leftExpression = join.getLeftTable();
            } else {
                if (joinCondition.isComposite()) {
                    throw new TorqueException("join condition is composite and there is no leftTable defined in the join. Please define a leftTable in the join");
                }
                Object lValue = joinCondition.getLValue();
                leftExpression = SqlBuilder.getExpressionForFromClause(lValue, criteria);
            }
            if (join.getRightTable() != null) {
                rightExpression = join.getRightTable();
            } else {
                if (joinCondition.isComposite()) {
                    throw new TorqueException("join condition is composite and there is no rightTable defined in the join. Please define a rightTable in the join");
                }
                Object rValue = joinCondition.getRValue();
                rightExpression = SqlBuilder.getExpressionForFromClause(rValue, criteria);
            }
            leftExpression = JoinBuilder.addSchema(leftExpression, criteria);
            rightExpression = JoinBuilder.addSchema(rightExpression, criteria);
            if (!SqlBuilder.fromClauseContainsExpression(queryFromClause, rightExpression)) {
                if (!SqlBuilder.fromClauseContainsExpression(queryFromClause, leftExpression)) {
                    fromElement = new FromElement(leftExpression.getSqlAsString(), null, null, leftExpression.getPreparedStatementReplacements());
                    queryFromClause.add(fromElement);
                }
                fromElement = new FromElement(rightExpression.getSqlAsString(), joinType, JoinBuilder.buildJoinCondition(joinCondition, criteria, query));
                fromElement.getPreparedStatementReplacements().addAll(rightExpression.getPreparedStatementReplacements());
                queryFromClause.add(fromElement);
                continue;
            }
            if (SqlBuilder.fromClauseContainsExpression(queryFromClause, leftExpression)) {
                throw new TorqueException("Unable to create a" + (Object)((Object)joinType) + "because both expressions " + leftExpression.getSqlAsString() + " and " + rightExpression.getSqlAsString() + " are already in use. Try to create an(other) alias.");
            }
            fromElement = new FromElement(leftExpression.getSqlAsString(), JoinBuilder.reverseJoinType(joinType), JoinBuilder.buildJoinCondition(joinCondition, criteria, query));
            queryFromClause.add(fromElement);
        }
    }

    private static JoinType reverseJoinType(JoinType joinType) {
        if (JoinType.LEFT_JOIN.equals((Object)joinType)) {
            return JoinType.RIGHT_JOIN;
        }
        if (JoinType.RIGHT_JOIN.equals((Object)joinType)) {
            return JoinType.LEFT_JOIN;
        }
        return joinType;
    }

    private static PreparedStatementPart buildJoinCondition(Criterion joinCondition, Criteria criteria, Query query) throws TorqueException {
        PreparedStatementPartImpl joinPart = new PreparedStatementPartImpl();
        JoinBuilder.appendJoinCondition(joinCondition, criteria, joinPart, query);
        return joinPart;
    }

    private static void appendJoinCondition(Criterion joinCondition, Criteria criteria, PreparedStatementPartImpl joinPart, Query query) throws TorqueException {
        if (joinCondition.isComposite()) {
            joinPart.getSql().append('(');
            boolean firstPart = true;
            for (Criterion part : joinCondition.getParts()) {
                if (!firstPart) {
                    joinPart.getSql().append(joinCondition.getConjunction());
                }
                JoinBuilder.appendJoinCondition(part, criteria, joinPart, query);
                firstPart = false;
            }
            joinPart.getSql().append(')');
            return;
        }
        PreparedStatementPart joinConditionStatementPart = SqlBuilder.processCriterion(joinCondition, criteria, query);
        joinPart.append(joinConditionStatementPart);
    }

    private static PreparedStatementPart addSchema(PreparedStatementPart tableNamePart, Criteria criteria) throws TorqueException {
        String tableName = tableNamePart.getSqlAsString();
        if (tableName.indexOf(46) != -1 || tableName.indexOf(32) != -1 || tableName.indexOf(40) != -1) {
            return tableNamePart;
        }
        Object resolvedAlias = criteria.getAliases().get(tableName);
        if (resolvedAlias != null) {
            return tableNamePart;
        }
        String dbName = criteria.getDbName();
        Database database = Torque.getDatabase(dbName);
        String resolvedSchemaName = database.getSchema();
        if (resolvedSchemaName == null) {
            return tableNamePart;
        }
        PreparedStatementPartImpl result = new PreparedStatementPartImpl(tableNamePart);
        result.getSql().insert(0, '.');
        result.getSql().insert(0, resolvedSchemaName);
        return result;
    }
}

