/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules.actions.sessionvalidator;

import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.turbine.Turbine;
import org.apache.turbine.modules.actions.sessionvalidator.SessionValidator;
import org.apache.turbine.om.security.User;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.util.RunData;

public class TemplateSessionValidator
extends SessionValidator {
    private static Logger log = LogManager.getLogger(TemplateSessionValidator.class);

    @Override
    public void doPerform(PipelineData pipelineData) throws Exception {
        RunData data = pipelineData.getRunData();
        data.populate();
        if (data.getUser() == null) {
            log.debug("Creating an anonymous user object!");
            Object anonymousUser = this.security.getAnonymousUser();
            data.setUser(anonymousUser);
            data.save();
        }
        if (!data.hasScreen() && StringUtils.isEmpty((CharSequence)data.getTemplateInfo().getScreenTemplate())) {
            if (StringUtils.isNotEmpty((CharSequence)this.templateHomepage)) {
                data.getTemplateInfo().setScreenTemplate(this.templateHomepage);
            } else {
                data.setScreen(this.screenHomepage);
            }
        } else {
            this.handleFormCounterToken(data, false);
        }
        if (data.getTemplateInfo().getScreenTemplate() != null) {
            data.setScreen(null);
        }
        pipelineData.get(Turbine.class).put(User.class, data.getUser());
    }
}

