/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import nl.basjes.parse.useragent.analyze.Matcher;
import nl.basjes.parse.useragent.parser.UserAgentBaseListener;
import nl.basjes.parse.useragent.utils.DefaultANTLRErrorListener;
import nl.basjes.shaded.org.antlr.v4.runtime.Parser;
import nl.basjes.shaded.org.antlr.v4.runtime.RecognitionException;
import nl.basjes.shaded.org.antlr.v4.runtime.Recognizer;
import nl.basjes.shaded.org.antlr.v4.runtime.atn.ATNConfigSet;
import nl.basjes.shaded.org.antlr.v4.runtime.dfa.DFA;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAgent
extends UserAgentBaseListener
implements Serializable,
DefaultANTLRErrorListener {
    private static final Logger LOG = LoggerFactory.getLogger(UserAgent.class);
    public static final String DEVICE_CLASS = "DeviceClass";
    public static final String DEVICE_BRAND = "DeviceBrand";
    public static final String DEVICE_NAME = "DeviceName";
    public static final String DEVICE_VERSION = "DeviceVersion";
    public static final String OPERATING_SYSTEM_CLASS = "OperatingSystemClass";
    public static final String OPERATING_SYSTEM_NAME = "OperatingSystemName";
    public static final String OPERATING_SYSTEM_VERSION = "OperatingSystemVersion";
    public static final String LAYOUT_ENGINE_CLASS = "LayoutEngineClass";
    public static final String LAYOUT_ENGINE_NAME = "LayoutEngineName";
    public static final String LAYOUT_ENGINE_VERSION = "LayoutEngineVersion";
    public static final String LAYOUT_ENGINE_VERSION_MAJOR = "LayoutEngineVersionMajor";
    public static final String AGENT_CLASS = "AgentClass";
    public static final String AGENT_NAME = "AgentName";
    public static final String AGENT_VERSION = "AgentVersion";
    public static final String AGENT_VERSION_MAJOR = "AgentVersionMajor";
    public static final String SYNTAX_ERROR = "__SyntaxError__";
    public static final String USERAGENT_FIELDNAME = "Useragent";
    public static final String SET_ALL_FIELDS = "__Set_ALL_Fields__";
    public static final String NULL_VALUE = "<<<null>>>";
    public static final String UNKNOWN_VALUE = "Unknown";
    public static final String UNKNOWN_VERSION = "??";
    public static final List<String> STANDARD_FIELDS = Collections.unmodifiableList(Arrays.asList("DeviceClass", "DeviceBrand", "DeviceName", "OperatingSystemClass", "OperatingSystemName", "OperatingSystemVersion", "LayoutEngineClass", "LayoutEngineName", "LayoutEngineVersion", "LayoutEngineVersionMajor", "AgentClass", "AgentName", "AgentVersion", "AgentVersionMajor"));
    private boolean hasSyntaxError;
    private boolean hasAmbiguity;
    private int ambiguityCount;
    private String userAgentString = null;
    private boolean debug = false;
    private final Map<String, AgentField> allFields = new HashMap<String, AgentField>(32);
    protected static final List<String> PRE_SORTED_FIELDS_LIST = new ArrayList<String>(32);

    public boolean hasSyntaxError() {
        return this.hasSyntaxError;
    }

    public boolean hasAmbiguity() {
        return this.hasAmbiguity;
    }

    public int getAmbiguityCount() {
        return this.ambiguityCount;
    }

    @Override
    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
        if (this.debug) {
            LOG.error("Syntax error");
            LOG.error("Source : {}", (Object)this.userAgentString);
            LOG.error("Message: {}", (Object)msg);
        }
        this.hasSyntaxError = true;
        AgentField syntaxError = new AgentField("false");
        syntaxError.setValue("true", 1L);
        this.allFields.put(SYNTAX_ERROR, syntaxError);
    }

    @Override
    public void reportAmbiguity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, boolean exact, BitSet ambigAlts, ATNConfigSet configs) {
        this.hasAmbiguity = true;
        ++this.ambiguityCount;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean newDebug) {
        this.debug = newDebug;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserAgent)) {
            return false;
        }
        UserAgent agent = (UserAgent)o;
        return Objects.equals(this.userAgentString, agent.userAgentString) && Objects.equals(this.allFields, agent.allFields);
    }

    public int hashCode() {
        return Objects.hash(this.userAgentString, this.allFields);
    }

    public UserAgent() {
        this.init();
    }

    public UserAgent(String userAgentString) {
        this.init();
        this.setUserAgentString(userAgentString);
    }

    public UserAgent(UserAgent userAgent) {
        this.clone(userAgent);
    }

    public void clone(UserAgent userAgent) {
        this.init();
        this.debug = userAgent.debug;
        this.setUserAgentString(userAgent.userAgentString);
        for (Map.Entry<String, AgentField> entry : userAgent.allFields.entrySet()) {
            this.set(entry.getKey(), entry.getValue().getValue(), entry.getValue().confidence);
        }
        this.hasSyntaxError = userAgent.hasSyntaxError;
        this.hasAmbiguity = userAgent.hasAmbiguity;
        this.ambiguityCount = userAgent.ambiguityCount;
    }

    private void init() {
        this.allFields.put(DEVICE_CLASS, new AgentField(UNKNOWN_VALUE));
        this.allFields.put(DEVICE_BRAND, new AgentField(UNKNOWN_VALUE));
        this.allFields.put(DEVICE_NAME, new AgentField(UNKNOWN_VALUE));
        this.allFields.put(OPERATING_SYSTEM_CLASS, new AgentField(UNKNOWN_VALUE));
        this.allFields.put(OPERATING_SYSTEM_NAME, new AgentField(UNKNOWN_VALUE));
        this.allFields.put(OPERATING_SYSTEM_VERSION, new AgentField(UNKNOWN_VERSION));
        this.allFields.put(LAYOUT_ENGINE_CLASS, new AgentField(UNKNOWN_VALUE));
        this.allFields.put(LAYOUT_ENGINE_NAME, new AgentField(UNKNOWN_VALUE));
        this.allFields.put(LAYOUT_ENGINE_VERSION, new AgentField(UNKNOWN_VERSION));
        this.allFields.put(LAYOUT_ENGINE_VERSION_MAJOR, new AgentField(UNKNOWN_VERSION));
        this.allFields.put(AGENT_CLASS, new AgentField(UNKNOWN_VALUE));
        this.allFields.put(AGENT_NAME, new AgentField(UNKNOWN_VALUE));
        this.allFields.put(AGENT_VERSION, new AgentField(UNKNOWN_VERSION));
        this.allFields.put(AGENT_VERSION_MAJOR, new AgentField(UNKNOWN_VERSION));
    }

    public void setUserAgentString(String newUserAgentString) {
        this.userAgentString = newUserAgentString;
        this.reset();
    }

    public String getUserAgentString() {
        return this.userAgentString;
    }

    public void reset() {
        this.hasSyntaxError = false;
        this.hasAmbiguity = false;
        this.ambiguityCount = 0;
        for (AgentField field : this.allFields.values()) {
            field.reset();
        }
    }

    static boolean isSystemField(String fieldname) {
        return SET_ALL_FIELDS.equals(fieldname) || SYNTAX_ERROR.equals(fieldname) || USERAGENT_FIELDNAME.equals(fieldname);
    }

    public void processSetAll() {
        AgentField setAllField = this.allFields.get(SET_ALL_FIELDS);
        if (setAllField == null) {
            return;
        }
        String value = setAllField.getValue();
        Long confidence = setAllField.confidence;
        for (Map.Entry<String, AgentField> fieldEntry : this.allFields.entrySet()) {
            if (UserAgent.isSystemField(fieldEntry.getKey())) continue;
            fieldEntry.getValue().setValue(value, confidence);
        }
    }

    public void set(String attribute, String value, long confidence) {
        AgentField field = this.allFields.get(attribute);
        if (field == null) {
            field = new AgentField(null);
        }
        boolean wasEmpty = confidence == -1L;
        boolean updated = field.setValue(value, confidence);
        if (this.debug && !wasEmpty) {
            if (updated) {
                LOG.info("USE  {} ({}) = {}", new Object[]{attribute, confidence, value});
            } else {
                LOG.info("SKIP {} ({}) = {}", new Object[]{attribute, confidence, value});
            }
        }
        this.allFields.put(attribute, field);
    }

    public void setForced(String attribute, String value, long confidence) {
        AgentField field = this.allFields.get(attribute);
        if (field == null) {
            field = new AgentField(null);
        }
        boolean wasEmpty = confidence == -1L;
        field.setValueForced(value, confidence);
        if (this.debug && !wasEmpty) {
            LOG.info("USE  {} ({}) = {}", new Object[]{attribute, confidence, value});
        }
        this.allFields.put(attribute, field);
    }

    public void set(UserAgent newValuesUserAgent, Matcher appliedMatcher) {
        for (String fieldName : newValuesUserAgent.allFields.keySet()) {
            AgentField field = newValuesUserAgent.allFields.get(fieldName);
            this.set(fieldName, field.value, field.confidence);
        }
    }

    void setImmediateForTesting(String fieldName, AgentField agentField) {
        this.allFields.put(fieldName, agentField);
    }

    public AgentField get(String fieldName) {
        if (USERAGENT_FIELDNAME.equals(fieldName)) {
            AgentField agentField = new AgentField(this.userAgentString);
            agentField.setValue(this.userAgentString, 0L);
            return agentField;
        }
        return this.allFields.get(fieldName);
    }

    public String getValue(String fieldName) {
        if (USERAGENT_FIELDNAME.equals(fieldName)) {
            return this.userAgentString;
        }
        AgentField field = this.allFields.get(fieldName);
        if (field == null) {
            return UNKNOWN_VALUE;
        }
        return field.getValue();
    }

    public Long getConfidence(String fieldName) {
        if (USERAGENT_FIELDNAME.equals(fieldName)) {
            return 0L;
        }
        AgentField field = this.allFields.get(fieldName);
        if (field == null) {
            return -1L;
        }
        return field.getConfidence();
    }

    public String toYamlTestCase() {
        return this.toYamlTestCase(false, null);
    }

    public String toYamlTestCase(boolean showConfidence) {
        return this.toYamlTestCase(showConfidence, null);
    }

    public String toYamlTestCase(boolean showConfidence, Map<String, String> comments) {
        StringBuilder sb = new StringBuilder(10240);
        sb.append("\n");
        sb.append("- test:\n");
        sb.append("#    options:\n");
        sb.append("#    - 'verbose'\n");
        sb.append("#    - 'init'\n");
        sb.append("#    - 'only'\n");
        sb.append("    input:\n");
        sb.append("      user_agent_string: '").append(this.userAgentString).append("'\n");
        sb.append("    expected:\n");
        List<String> fieldNames = this.getAvailableFieldNamesSorted();
        int maxNameLength = 30;
        int maxValueLength = 0;
        for (String fieldName : this.allFields.keySet()) {
            maxNameLength = Math.max(maxNameLength, fieldName.length());
        }
        for (String fieldName : fieldNames) {
            maxValueLength = Math.max(maxValueLength, this.get(fieldName).getValue().length());
        }
        for (String fieldName : fieldNames) {
            String comment;
            sb.append("      ").append(fieldName);
            for (int l = fieldName.length(); l < maxNameLength + 7; ++l) {
                sb.append(' ');
            }
            String value = this.get(fieldName).getValue();
            sb.append(": '").append(value).append('\'');
            if (showConfidence) {
                for (int l = value.length(); l < maxValueLength + 5; ++l) {
                    sb.append(' ');
                }
                sb.append("# ").append(String.format("%5d", this.get(fieldName).confidence));
            }
            if (comments != null && (comment = comments.get(fieldName)) != null) {
                sb.append(" | ").append(comment);
            }
            sb.append('\n');
        }
        sb.append("\n\n");
        return sb.toString();
    }

    public String toJson() {
        List<String> fields = this.getAvailableFieldNames();
        fields.add(USERAGENT_FIELDNAME);
        return this.toJson(fields);
    }

    public String toJson(List<String> fieldNames) {
        StringBuilder sb = new StringBuilder(10240);
        sb.append("{");
        boolean addSeparator = false;
        for (String fieldName : fieldNames) {
            if (addSeparator) {
                sb.append(',');
            } else {
                addSeparator = true;
            }
            if (USERAGENT_FIELDNAME.equals(fieldName)) {
                sb.append("\"Useragent\"").append(':').append('\"').append(StringEscapeUtils.escapeJson((String)this.getUserAgentString())).append('\"');
                continue;
            }
            sb.append('\"').append(StringEscapeUtils.escapeJson((String)fieldName)).append('\"').append(':').append('\"').append(StringEscapeUtils.escapeJson((String)this.getValue(fieldName))).append('\"');
        }
        sb.append("}");
        return sb.toString();
    }

    public String toString() {
        return this.toString(this.getAvailableFieldNamesSorted());
    }

    public String toString(String ... fieldNames) {
        return this.toString(Arrays.asList(fieldNames));
    }

    public String toString(List<String> fieldNames) {
        StringBuilder sb = new StringBuilder("  - user_agent_string: '\"" + this.userAgentString + "\"'\n");
        int maxLength = 0;
        for (String fieldName : fieldNames) {
            maxLength = Math.max(maxLength, fieldName.length());
        }
        for (String fieldName : fieldNames) {
            AgentField field;
            if (USERAGENT_FIELDNAME.equals(fieldName) || (field = this.allFields.get(fieldName)).getValue() == null) continue;
            sb.append("    ").append(fieldName);
            for (int l = fieldName.length(); l < maxLength + 2; ++l) {
                sb.append(' ');
            }
            sb.append(": '").append(field.getValue()).append('\'');
            sb.append('\n');
        }
        return sb.toString();
    }

    public List<String> getAvailableFieldNames() {
        ArrayList<String> resultSet = new ArrayList<String>(this.allFields.size() + 10);
        resultSet.addAll(STANDARD_FIELDS);
        this.allFields.forEach((fieldName, value) -> {
            AgentField field;
            if (!resultSet.contains(fieldName) && (field = this.allFields.get(fieldName)) != null && field.confidence >= 0L && field.getValue() != null) {
                resultSet.add((String)fieldName);
            }
        });
        resultSet.remove(SET_ALL_FIELDS);
        return resultSet;
    }

    public List<String> getAvailableFieldNamesSorted() {
        ArrayList<String> fieldNames = new ArrayList<String>(this.getAvailableFieldNames());
        ArrayList<String> result = new ArrayList<String>();
        for (String fieldName : PRE_SORTED_FIELDS_LIST) {
            if (!fieldNames.remove(fieldName)) continue;
            result.add(fieldName);
        }
        Collections.sort(fieldNames);
        result.addAll(fieldNames);
        return result;
    }

    static {
        PRE_SORTED_FIELDS_LIST.add(DEVICE_CLASS);
        PRE_SORTED_FIELDS_LIST.add(DEVICE_NAME);
        PRE_SORTED_FIELDS_LIST.add(DEVICE_BRAND);
        PRE_SORTED_FIELDS_LIST.add("DeviceCpu");
        PRE_SORTED_FIELDS_LIST.add("DeviceCpuBits");
        PRE_SORTED_FIELDS_LIST.add("DeviceFirmwareVersion");
        PRE_SORTED_FIELDS_LIST.add(DEVICE_VERSION);
        PRE_SORTED_FIELDS_LIST.add(OPERATING_SYSTEM_CLASS);
        PRE_SORTED_FIELDS_LIST.add(OPERATING_SYSTEM_NAME);
        PRE_SORTED_FIELDS_LIST.add(OPERATING_SYSTEM_VERSION);
        PRE_SORTED_FIELDS_LIST.add("OperatingSystemNameVersion");
        PRE_SORTED_FIELDS_LIST.add("OperatingSystemVersionBuild");
        PRE_SORTED_FIELDS_LIST.add(LAYOUT_ENGINE_CLASS);
        PRE_SORTED_FIELDS_LIST.add(LAYOUT_ENGINE_NAME);
        PRE_SORTED_FIELDS_LIST.add(LAYOUT_ENGINE_VERSION);
        PRE_SORTED_FIELDS_LIST.add(LAYOUT_ENGINE_VERSION_MAJOR);
        PRE_SORTED_FIELDS_LIST.add("LayoutEngineNameVersion");
        PRE_SORTED_FIELDS_LIST.add("LayoutEngineNameVersionMajor");
        PRE_SORTED_FIELDS_LIST.add("LayoutEngineBuild");
        PRE_SORTED_FIELDS_LIST.add(AGENT_CLASS);
        PRE_SORTED_FIELDS_LIST.add(AGENT_NAME);
        PRE_SORTED_FIELDS_LIST.add(AGENT_VERSION);
        PRE_SORTED_FIELDS_LIST.add(AGENT_VERSION_MAJOR);
        PRE_SORTED_FIELDS_LIST.add("AgentNameVersion");
        PRE_SORTED_FIELDS_LIST.add("AgentNameVersionMajor");
        PRE_SORTED_FIELDS_LIST.add("AgentBuild");
        PRE_SORTED_FIELDS_LIST.add("AgentLanguage");
        PRE_SORTED_FIELDS_LIST.add("AgentLanguageCode");
        PRE_SORTED_FIELDS_LIST.add("AgentInformationEmail");
        PRE_SORTED_FIELDS_LIST.add("AgentInformationUrl");
        PRE_SORTED_FIELDS_LIST.add("AgentSecurity");
        PRE_SORTED_FIELDS_LIST.add("AgentUuid");
        PRE_SORTED_FIELDS_LIST.add("WebviewAppName");
        PRE_SORTED_FIELDS_LIST.add("WebviewAppVersion");
        PRE_SORTED_FIELDS_LIST.add("WebviewAppVersionMajor");
        PRE_SORTED_FIELDS_LIST.add("WebviewAppNameVersionMajor");
        PRE_SORTED_FIELDS_LIST.add("FacebookCarrier");
        PRE_SORTED_FIELDS_LIST.add("FacebookDeviceClass");
        PRE_SORTED_FIELDS_LIST.add("FacebookDeviceName");
        PRE_SORTED_FIELDS_LIST.add("FacebookDeviceVersion");
        PRE_SORTED_FIELDS_LIST.add("FacebookFBOP");
        PRE_SORTED_FIELDS_LIST.add("FacebookFBSS");
        PRE_SORTED_FIELDS_LIST.add("FacebookOperatingSystemName");
        PRE_SORTED_FIELDS_LIST.add("FacebookOperatingSystemVersion");
        PRE_SORTED_FIELDS_LIST.add("Anonymized");
        PRE_SORTED_FIELDS_LIST.add("HackerAttackVector");
        PRE_SORTED_FIELDS_LIST.add("HackerToolkit");
        PRE_SORTED_FIELDS_LIST.add("KoboAffiliate");
        PRE_SORTED_FIELDS_LIST.add("KoboPlatformId");
        PRE_SORTED_FIELDS_LIST.add("IECompatibilityVersion");
        PRE_SORTED_FIELDS_LIST.add("IECompatibilityVersionMajor");
        PRE_SORTED_FIELDS_LIST.add("IECompatibilityNameVersion");
        PRE_SORTED_FIELDS_LIST.add("IECompatibilityNameVersionMajor");
        PRE_SORTED_FIELDS_LIST.add(SYNTAX_ERROR);
    }

    public static class AgentField
    implements Serializable {
        private final String defaultValue;
        private String value;
        private long confidence;

        private AgentField() {
            this.defaultValue = null;
        }

        AgentField(String defaultValue) {
            this.defaultValue = defaultValue;
            this.reset();
        }

        public void reset() {
            this.value = this.defaultValue;
            this.confidence = -1L;
        }

        public String getValue() {
            if (this.value == null) {
                return this.defaultValue;
            }
            return this.value;
        }

        public long getConfidence() {
            if (this.value == null) {
                return -1L;
            }
            return this.confidence;
        }

        public boolean setValue(AgentField field) {
            return this.setValue(field.value, field.confidence);
        }

        public boolean setValue(String newValue, long newConfidence) {
            if (newConfidence > this.confidence) {
                this.confidence = newConfidence;
                this.value = UserAgent.NULL_VALUE.equals(newValue) ? this.defaultValue : newValue;
                return true;
            }
            return false;
        }

        public void setValueForced(String newValue, long newConfidence) {
            this.confidence = newConfidence;
            this.value = UserAgent.NULL_VALUE.equals(newValue) ? this.defaultValue : newValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AgentField)) {
                return false;
            }
            AgentField that = (AgentField)o;
            return this.confidence == that.confidence && Objects.equals(this.defaultValue, that.defaultValue) && Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.defaultValue, this.value, this.confidence);
        }

        public String toString() {
            if (this.defaultValue == null) {
                return "{ value:'" + this.value + "', confidence:'" + this.confidence + "', default:null }";
            }
            return "{ value:'" + this.value + "', confidence:'" + this.confidence + "', default:'" + this.defaultValue + "' }";
        }
    }
}

