/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.manager;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.FastArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.JCS;
import org.apache.jcs.access.GroupCacheAccess;
import org.apache.jcs.access.exception.CacheException;
import org.apache.torque.Torque;
import org.apache.torque.TorqueException;
import org.apache.torque.manager.CacheListener;
import org.apache.torque.manager.MethodResultCache;
import org.apache.torque.manager.NoOpMethodResultCache;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.Persistent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBaseManager<T extends Persistent>
implements Serializable {
    private static final long serialVersionUID = 509798299473481305L;
    protected static final Log log = LogFactory.getLog(AbstractBaseManager.class);
    protected transient GroupCacheAccess cache;
    protected MethodResultCache mrCache;
    private Class<T> omClass;
    private String className;
    private String region;
    private boolean isNew = true;
    protected Map<String, ?> validFields;
    protected Map<String, FastArrayList> listenersMap = new HashMap<String, FastArrayList>();

    protected Class<T> getOMClass() {
        return this.omClass;
    }

    protected void setOMClass(Class<T> omClass) {
        this.omClass = omClass;
    }

    protected T getOMInstance() throws TorqueException {
        try {
            return (T)((Persistent)this.omClass.newInstance());
        }
        catch (InstantiationException e) {
            throw new TorqueException("Could not instantiate " + this.getClassName(), e);
        }
        catch (IllegalAccessException e) {
            throw new TorqueException("Could not access " + this.getClassName(), e);
        }
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String v) throws TorqueException {
        this.className = v;
        try {
            Class<?> clazz = Class.forName(this.getClassName());
            if (!Persistent.class.isAssignableFrom(clazz)) {
                throw new TorqueException(this.getClassName() + " does not implement the interface Persistent");
            }
            this.setOMClass(clazz);
        }
        catch (ClassNotFoundException cnfe) {
            throw new TorqueException("Could not load " + this.getClassName(), cnfe);
        }
    }

    protected T getOMInstance(ObjectKey id) throws TorqueException {
        return this.getOMInstance(id, true);
    }

    protected T getOMInstance(ObjectKey key, boolean fromCache) throws TorqueException {
        T om = null;
        if (fromCache) {
            om = this.cacheGet(key);
        }
        if (om == null) {
            om = this.retrieveStoredOM(key);
            if (fromCache) {
                this.putInstanceImpl(om);
            }
        }
        return om;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T cacheGet(Serializable key) {
        Persistent om = null;
        if (this.cache != null) {
            AbstractBaseManager abstractBaseManager = this;
            synchronized (abstractBaseManager) {
                om = (Persistent)this.cache.get((Object)key);
            }
        }
        return (T)om;
    }

    protected void clearImpl() throws TorqueException {
        if (this.cache != null) {
            try {
                this.cache.clear();
            }
            catch (CacheException ce) {
                throw new TorqueException("Could not clear cache due to internal JCS error.", ce);
            }
        }
    }

    public void dispose() {
        if (this.cache != null) {
            this.cache.dispose();
            this.cache = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T removeInstanceImpl(Serializable key) throws TorqueException {
        Persistent oldOm = null;
        if (this.cache != null) {
            try {
                AbstractBaseManager abstractBaseManager = this;
                synchronized (abstractBaseManager) {
                    oldOm = (Persistent)this.cache.get((Object)key);
                    this.cache.remove((Object)key);
                }
            }
            catch (CacheException ce) {
                throw new TorqueException("Could not remove from cache due to internal JCS error", ce);
            }
        }
        return (T)oldOm;
    }

    protected T putInstanceImpl(T om) throws TorqueException {
        ObjectKey key = om.getPrimaryKey();
        return this.putInstanceImpl(key, om);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T putInstanceImpl(Serializable key, T om) throws TorqueException {
        if (this.getOMClass() != null && !this.getOMClass().isInstance(om)) {
            throw new TorqueException(om + "; class=" + om.getClass().getName() + "; id=" + om.getPrimaryKey() + " cannot be cached with " + this.getOMClass().getName() + " objects");
        }
        Persistent oldOm = null;
        if (this.cache != null) {
            try {
                AbstractBaseManager abstractBaseManager = this;
                synchronized (abstractBaseManager) {
                    oldOm = (Persistent)this.cache.get((Object)key);
                    this.cache.put((Object)key, om);
                }
            }
            catch (CacheException ce) {
                throw new TorqueException("Could not cache due to internal JCS error", ce);
            }
        }
        return (T)oldOm;
    }

    protected abstract T retrieveStoredOM(ObjectKey var1) throws TorqueException;

    protected List<T> getOMs(ObjectKey[] ids) throws TorqueException {
        return this.getOMs(Arrays.asList(ids));
    }

    protected List<T> getOMs(List<? extends ObjectKey> ids) throws TorqueException {
        return this.getOMs(ids, true);
    }

    protected List<T> getOMs(List<? extends ObjectKey> ids, boolean fromCache) throws TorqueException {
        ArrayList oms = null;
        if (ids != null && ids.size() > 0) {
            HashMap<ObjectKey, Persistent> omsMap = new HashMap<ObjectKey, Persistent>();
            ArrayList<ObjectKey> newIds = new ArrayList<ObjectKey>(ids.size());
            for (ObjectKey objectKey : ids) {
                Persistent om = null;
                if (fromCache) {
                    om = (Persistent)this.cacheGet(objectKey);
                }
                if (om == null) {
                    newIds.add(objectKey);
                    continue;
                }
                omsMap.put(objectKey, om);
            }
            if (newIds.size() > 0) {
                List<T> newOms = this.retrieveStoredOMs(newIds);
                for (Persistent om : newOms) {
                    omsMap.put(om.getPrimaryKey(), om);
                    if (!fromCache) continue;
                    this.putInstanceImpl(om);
                }
            }
            oms = new ArrayList(ids.size());
            for (ObjectKey objectKey : ids) {
                oms.add(omsMap.get(objectKey));
            }
        }
        return oms;
    }

    protected abstract List<T> retrieveStoredOMs(List<? extends ObjectKey> var1) throws TorqueException;

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String v) throws TorqueException {
        this.region = v;
        try {
            if (Torque.getConfiguration().getBoolean("manager.useCache", false)) {
                this.cache = JCS.getInstance((String)this.getRegion());
                this.mrCache = new MethodResultCache(this.cache);
            } else {
                this.mrCache = new NoOpMethodResultCache(this.cache);
            }
        }
        catch (CacheException e) {
            throw new TorqueException("Cache could not be initialized", e);
        }
        if (this.cache == null) {
            log.info((Object)("Cache could not be initialized for region: " + v));
        }
    }

    public synchronized MethodResultCache getMethodResultCache() {
        if (this.isNew) {
            this.registerAsListener();
            this.isNew = false;
        }
        return this.mrCache;
    }

    protected void registerAsListener() {
    }

    public void addCacheListenerImpl(CacheListener<? extends Persistent> listener) {
        List<String> keys = listener.getInterestedFields();
        for (String key : keys) {
            if (this.validFields == null || !this.validFields.containsKey(key)) continue;
            FastArrayList listeners = this.listenersMap.get(key);
            if (listeners == null) {
                listeners = this.createSubsetList(key);
            }
            boolean isListenerNew = true;
            Iterator j = listeners.iterator();
            while (j.hasNext()) {
                Object listener2 = ((WeakReference)j.next()).get();
                if (listener2 != listener) continue;
                isListenerNew = false;
                break;
            }
            if (!isListenerNew) continue;
            listeners.add(new WeakReference<CacheListener<? extends Persistent>>(listener));
        }
    }

    private synchronized FastArrayList createSubsetList(String key) {
        FastArrayList list = null;
        if (this.listenersMap.containsKey(key)) {
            list = this.listenersMap.get(key);
        } else {
            list = new FastArrayList();
            list.setFast(true);
            this.listenersMap.put(key, list);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <TT extends Persistent> void notifyListeners(List<WeakReference<CacheListener<TT>>> listeners, TT oldOm, TT om) {
        if (listeners != null) {
            List<WeakReference<CacheListener<TT>>> list = listeners;
            synchronized (list) {
                Iterator<WeakReference<CacheListener<TT>>> i = listeners.iterator();
                while (i.hasNext()) {
                    CacheListener listener = (CacheListener)i.next().get();
                    if (listener == null) {
                        i.remove();
                        continue;
                    }
                    if (oldOm == null) {
                        listener.addedObject(om);
                        continue;
                    }
                    listener.refreshedObject(om);
                }
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            if (this.region != null) {
                this.setRegion(this.region);
            }
        }
        catch (Exception e) {
            log.error((Object)("Cache could not be initialized for region '" + this.region + "' after deserialization"));
        }
    }
}

