/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.jsp.util;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.modules.Screen;
import org.apache.turbine.modules.ScreenLoader;
import org.apache.turbine.services.assemblerbroker.TurbineAssemblerBroker;
import org.apache.turbine.services.jsp.util.JspNavigation;
import org.apache.turbine.services.template.TurbineTemplate;
import org.apache.turbine.util.RunData;

public class JspScreenPlaceholder {
    private static Log log = LogFactory.getLog(JspNavigation.class);
    private final RunData data;
    private final ScreenLoader screenLoader;

    public JspScreenPlaceholder(RunData data) {
        this.data = data;
        this.screenLoader = (ScreenLoader)TurbineAssemblerBroker.getLoader(Screen.class);
    }

    public void exec() {
        String template = null;
        String module = null;
        try {
            template = this.data.getTemplateInfo().getScreenTemplate();
            module = TurbineTemplate.getScreenName(template);
            this.screenLoader.exec(this.data, module);
        }
        catch (Exception e) {
            String message = "Error processing navigation template:" + template + " using module: " + module;
            log.error((Object)message, (Throwable)e);
            try {
                this.data.getResponse().getWriter().print("Error processing navigation template: " + template + " using module: " + module);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }
}

