/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.torque.turbine;

import java.sql.Connection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.model.turbine.entity.TurbineGroup;
import org.apache.fulcrum.security.model.turbine.entity.TurbineUserGroupRole;
import org.apache.fulcrum.security.torque.om.TorqueTurbineGroupPeer;
import org.apache.fulcrum.security.torque.om.TorqueTurbineUserGroupRole;
import org.apache.fulcrum.security.torque.om.TorqueTurbineUserGroupRolePeer;
import org.apache.fulcrum.security.torque.security.turbine.TorqueAbstractTurbineTurbineSecurityEntity;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.util.TorqueConnection;
import org.apache.torque.util.Transaction;

public abstract class FulcrumAbstractTurbineGroup
extends TorqueAbstractTurbineTurbineSecurityEntity
implements TurbineGroup {
    private static final long serialVersionUID = -6230312046016785990L;

    protected List<TorqueTurbineUserGroupRole> getTorqueTurbineUserGroupRolesJoinTorqueTurbineRole(Criteria criteria, Connection con) throws TorqueException {
        criteria.and((Object)TorqueTurbineUserGroupRolePeer.GROUP_ID, (Object)this.getEntityId());
        return TorqueTurbineUserGroupRolePeer.doSelectJoinTorqueTurbineRole(criteria, con);
    }

    @Override
    public void retrieveAttachedObjects(Connection con) throws DataBackendException {
        this.retrieveAttachedObjects(con, false);
    }

    @Override
    public void retrieveAttachedObjects(Connection con, Boolean lazy) throws DataBackendException {
        try {
            if (!lazy.booleanValue()) {
                HashSet<TurbineUserGroupRole> userGroupRoleSet = new HashSet<TurbineUserGroupRole>();
                List<TorqueTurbineUserGroupRole> ugrs = this.getTorqueTurbineUserGroupRolesJoinTorqueTurbineRole(new Criteria(), con);
                for (TorqueTurbineUserGroupRole ttugr : ugrs) {
                    TurbineUserGroupRole ugr = new TurbineUserGroupRole();
                    ugr.setGroup((Group)this);
                    ugr.setRole((Role)ttugr.getTorqueTurbineRole());
                    ugr.setUser((User)ttugr.getTorqueTurbineUser(con));
                    userGroupRoleSet.add(ugr);
                }
                this.setUserGroupRoleSet(userGroupRoleSet);
            }
        }
        catch (TorqueException e) {
            throw new DataBackendException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public <T extends TurbineUserGroupRole> Set<T> getUserGroupRoleSet() throws DataBackendException {
        if (super.getUserGroupRoleSet() == null || super.getUserGroupRoleSet().isEmpty()) {
            TorqueConnection con = null;
            try {
                con = Transaction.begin();
                this.retrieveAttachedObjects((Connection)con, false);
                Transaction.commit((Connection)con);
                con = null;
            }
            catch (TorqueException e) {
                throw new DataBackendException("Error retrieving group information", (Throwable)e);
            }
            finally {
                if (con != null) {
                    Transaction.safeRollback((Connection)con);
                }
            }
        }
        return super.getUserGroupRoleSet();
    }

    @Override
    public void update(Connection con) throws TorqueException {
        try {
            Set userGroupRoleSet = this.getUserGroupRoleSet();
            if (userGroupRoleSet != null) {
                Criteria criteria = new Criteria();
                criteria.where((Object)TorqueTurbineUserGroupRolePeer.GROUP_ID, (Object)this.getEntityId());
                TorqueTurbineUserGroupRolePeer.doDelete(criteria, con);
                for (TurbineUserGroupRole ugr : userGroupRoleSet) {
                    TorqueTurbineUserGroupRole ttugr = new TorqueTurbineUserGroupRole();
                    ttugr.setGroupId((Integer)ugr.getGroup().getId());
                    ttugr.setUserId((Integer)ugr.getUser().getId());
                    ttugr.setRoleId((Integer)ugr.getRole().getId());
                    ttugr.save(con);
                }
            }
            this.save(con);
        }
        catch (Exception e) {
            throw new TorqueException((Throwable)e);
        }
    }

    @Override
    public void delete() throws TorqueException {
        TorqueTurbineGroupPeer.doDelete(SimpleKey.keyFor((Number)this.getEntityId()));
    }
}

