/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.validator;

import jakarta.servlet.http.Part;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.fulcrum.intake.validator.DefaultValidator;
import org.apache.fulcrum.intake.validator.ValidationException;

public class FileValidator
extends DefaultValidator<Part> {
    private static final Pattern charsetPattern = Pattern.compile(".+charset\\s*=\\s*(.+)");

    public void assertValidity(Part testValue) throws ValidationException {
        Matcher matcher;
        byte[] fileData = new byte[(int)testValue.getSize()];
        String contentType = testValue.getContentType();
        String charset = Charset.defaultCharset().name();
        if (contentType.contains("charset") && (matcher = charsetPattern.matcher(contentType)).matches()) {
            charset = matcher.group(1);
        }
        try (InputStream fis = testValue.getInputStream();){
            int byteSize = fis.read(fileData);
            if (fileData.length != byteSize) {
                throw new ValidationException("Byte length mismatch found");
            }
        }
        catch (IOException e) {
            fileData = null;
        }
        String content = null;
        try {
            if (fileData != null) {
                content = new String(fileData, charset);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new ValidationException("Invalid charset " + charset);
        }
        super.assertValidity(content);
    }
}

