/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.SpecCompatibility;
import io.smallrye.faulttolerance.autoconfig.Config;
import io.smallrye.faulttolerance.config.FallbackValidation;
import io.smallrye.faulttolerance.config.KotlinSupport;
import io.smallrye.faulttolerance.internal.FallbackMethodCandidates;
import io.smallrye.faulttolerance.internal.InterceptionPoint;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.FallbackHandler;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

public interface FallbackConfig
extends Fallback,
Config {
    default public void validate() {
        Method guardedMethod;
        String INVALID_FALLBACK_ON = "Invalid @Fallback on ";
        try {
            guardedMethod = this.method().reflect();
        }
        catch (NoSuchMethodException e) {
            throw new FaultToleranceDefinitionException((Throwable)e);
        }
        if (!"".equals(this.fallbackMethod())) {
            if (!Fallback.DEFAULT.class.equals((Object)this.value())) {
                throw new FaultToleranceDefinitionException("Invalid @Fallback on " + String.valueOf(this.method()) + ": fallback handler class and fallback method can't be specified both at the same time");
            }
            SpecCompatibility specCompatibility = SpecCompatibility.createFromConfig();
            FallbackMethodCandidates candidates = FallbackMethodCandidates.create(new InterceptionPoint(this.beanClass(), guardedMethod), this.fallbackMethod(), specCompatibility.allowFallbackMethodExceptionParameter());
            if (candidates.isEmpty()) {
                throw new FaultToleranceDefinitionException("Invalid @Fallback on " + String.valueOf(this.method()) + ": can't find fallback method '" + this.fallbackMethod() + "' with matching parameter types and return type");
            }
        }
        if (!Fallback.DEFAULT.class.equals((Object)this.value())) {
            Type fallbackType = null;
            for (Type genericInterface : this.value().getGenericInterfaces()) {
                ParameterizedType parameterizedType;
                if (!(genericInterface instanceof ParameterizedType) || !(parameterizedType = (ParameterizedType)genericInterface).getRawType().equals(FallbackHandler.class)) continue;
                fallbackType = parameterizedType.getActualTypeArguments()[0];
                break;
            }
            Type boxedReturnType = FallbackValidation.box(guardedMethod.getGenericReturnType());
            if (KotlinSupport.isSuspendingFunction(guardedMethod)) {
                boxedReturnType = KotlinSupport.getSuspendingFunctionResultType(guardedMethod);
            }
            if (!boxedReturnType.equals(fallbackType)) {
                throw new FaultToleranceDefinitionException("Invalid @Fallback on " + String.valueOf(this.method()) + ": fallback handler's type " + String.valueOf(fallbackType) + " is not the same as method's return type");
            }
        }
    }
}

