/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.AbstractMappingConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import jakarta.annotation.Priority;
import java.util.Map;
import java.util.function.Function;

@Priority(value=3300)
public class RelocateConfigSourceInterceptor
extends AbstractMappingConfigSourceInterceptor {
    private static final long serialVersionUID = 3476637906383945843L;

    public RelocateConfigSourceInterceptor(Function<String, String> mapping) {
        super(mapping);
    }

    public RelocateConfigSourceInterceptor(Map<String, String> mappings) {
        super(mappings);
    }

    @Override
    public ConfigValue getValue(ConfigSourceInterceptorContext context, String name) {
        String map = this.getMapping().apply(name);
        ConfigValue relocateValue = context.proceed(map);
        if (name.equals(map)) {
            return relocateValue;
        }
        ConfigValue configValue = context.proceed(name);
        if (relocateValue != null && configValue != null) {
            return ConfigValue.CONFIG_SOURCE_COMPARATOR.compare(relocateValue, configValue) >= 0 ? relocateValue : configValue.withName(map);
        }
        if (relocateValue != null) {
            return relocateValue;
        }
        if (configValue != null) {
            return configValue.withName(map);
        }
        return null;
    }
}

