import { Traversal } from './traversal.cjs';
import Bytecode from './bytecode.cjs';
/**
 * Class to translate glv bytecode steps into executable Gremlin-Groovy script
 */
export default class Translator {
    private traversalSource;
    constructor(traversalSource: string);
    getTraversalSource(): string;
    getTargetLanguage(): string;
    of(traversalSource: string): void;
    /**
     * Returns a script representation of the given bytecode instructions.
     * @param {Object} bytecodeOrTraversal The traversal or bytecode of a traversal containing step instructions.
     * @param {boolean} child Determines if a traversal object should be treated as an anonymous child or if it is a spawn from "g"
     * @returns {string} Gremlin-Groovy script
     */
    translate(bytecodeOrTraversal: Traversal | Bytecode, child?: boolean): string;
    /**
     * Converts an object to a Gremlin script representation.
     * @param {Object} anyObject The object to convert to a script representation
     * @returns {string} The Gremlin script representation
     */
    convert(anyObject: any): string;
}
