/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.common.objectregistry;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.tez.runtime.api.ObjectRegistry;

public class ObjectRegistryImpl
implements ObjectRegistry {
    private Map<String, Map.Entry<Object, ObjectLifeCycle>> objectCache = new HashMap<String, Map.Entry<Object, ObjectLifeCycle>>();

    private synchronized Object add(ObjectLifeCycle lifeCycle, String key, Object value) {
        Map.Entry oldEntry = this.objectCache.put(key, new AbstractMap.SimpleImmutableEntry<Object, ObjectLifeCycle>(value, lifeCycle));
        return oldEntry != null ? oldEntry.getKey() : null;
    }

    public synchronized Object get(String key) {
        Map.Entry<Object, ObjectLifeCycle> entry = this.objectCache.get(key);
        return entry != null ? entry.getKey() : null;
    }

    public synchronized boolean delete(String key) {
        return null != this.objectCache.remove(key);
    }

    public synchronized void clearCache(ObjectLifeCycle lifeCycle) {
        Iterator<Map.Entry<String, Map.Entry<Object, ObjectLifeCycle>>> it = this.objectCache.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Map.Entry<Object, ObjectLifeCycle>> entry = it.next();
            if (!entry.getValue().getValue().equals((Object)lifeCycle)) continue;
            it.remove();
        }
    }

    public synchronized Object cacheForVertex(String key, Object value) {
        return this.add(ObjectLifeCycle.VERTEX, key, value);
    }

    public synchronized Object cacheForDAG(String key, Object value) {
        return this.add(ObjectLifeCycle.DAG, key, value);
    }

    public synchronized Object cacheForSession(String key, Object value) {
        return this.add(ObjectLifeCycle.SESSION, key, value);
    }

    public static enum ObjectLifeCycle {
        SESSION,
        DAG,
        VERTEX;

    }
}

