/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.api;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceStability.Unstable
@InterfaceAudience.Public
public class InputSpecUpdate {
    private final boolean forAllWorkUnits;
    private final List<Integer> numPhysicalInputs;
    private static final InputSpecUpdate DEFAULT_SINGLE_PHYSICAL_INPUT_SPEC = InputSpecUpdate.createAllTaskInputSpecUpdate(1);

    public static InputSpecUpdate createAllTaskInputSpecUpdate(int numPhysicalInputs) {
        return new InputSpecUpdate(numPhysicalInputs);
    }

    public static InputSpecUpdate createPerTaskInputSpecUpdate(List<Integer> perWorkUnitNumPhysicalInputs) {
        return new InputSpecUpdate(perWorkUnitNumPhysicalInputs);
    }

    public static InputSpecUpdate getDefaultSinglePhysicalInputSpecUpdate() {
        return DEFAULT_SINGLE_PHYSICAL_INPUT_SPEC;
    }

    private InputSpecUpdate(int numPhysicalInputs) {
        this.forAllWorkUnits = true;
        this.numPhysicalInputs = Lists.newArrayList((Object[])new Integer[]{numPhysicalInputs});
    }

    private InputSpecUpdate(List<Integer> perWorkUnitNumPhysicalInputs) {
        this.forAllWorkUnits = false;
        this.numPhysicalInputs = Lists.newArrayList(perWorkUnitNumPhysicalInputs);
    }

    @InterfaceAudience.Private
    public int getNumPhysicalInputsForWorkUnit(int index) {
        if (this.forAllWorkUnits) {
            return this.numPhysicalInputs.get(0);
        }
        return this.numPhysicalInputs.get(index);
    }

    @InterfaceAudience.Private
    public boolean isForAllWorkUnits() {
        return this.forAllWorkUnits;
    }

    @InterfaceAudience.Private
    public List<Integer> getAllNumPhysicalInputs() {
        return this.numPhysicalInputs;
    }

    public String toString() {
        return "forAllWorkUnits=" + this.forAllWorkUnits + ", update=" + this.numPhysicalInputs.toString();
    }
}

