/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.io.Writable;
import org.apache.sysds.runtime.compress.colgroup.dictionary.DictionaryFactory;
import org.apache.sysds.runtime.compress.colgroup.dictionary.IDictionary;

public class DictWritable
implements Writable,
Serializable {
    private static final long serialVersionUID = 731937201435558L;
    public List<IDictionary> dicts;

    public DictWritable() {
    }

    protected DictWritable(List<IDictionary> dicts) {
        this.dicts = dicts;
    }

    public void write(DataOutput out) throws IOException {
        HashSet<IDictionary> ud = new HashSet<IDictionary>();
        for (IDictionary d : this.dicts) {
            if (ud.contains(d)) {
                this.writeWithDuplicates(out);
                return;
            }
            ud.add(d);
        }
        out.writeInt(this.dicts.size());
        for (int i = 0; i < this.dicts.size(); ++i) {
            this.dicts.get(i).write(out);
        }
    }

    private void writeWithDuplicates(DataOutput out) throws IOException {
        out.writeInt(this.dicts.size() * -1);
        HashMap<IDictionary, Integer> m = new HashMap<IDictionary, Integer>();
        for (int i = 0; i < this.dicts.size(); ++i) {
            int id = m.getOrDefault(this.dicts.get(i), m.size());
            out.writeInt(id);
            if (m.containsKey(this.dicts.get(i))) continue;
            m.put(this.dicts.get(i), m.size());
            this.dicts.get(i).write(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        int s = in.readInt();
        if (s < 0) {
            this.readFieldsWithDuplicates(Math.abs(s), in);
        } else {
            this.dicts = new ArrayList<IDictionary>(s);
            for (int i = 0; i < s; ++i) {
                this.dicts.add(DictionaryFactory.read(in));
            }
        }
    }

    private void readFieldsWithDuplicates(int s, DataInput in) throws IOException {
        this.dicts = new ArrayList<IDictionary>(s);
        for (int i = 0; i < s; ++i) {
            int id = in.readInt();
            if (id < i) {
                this.dicts.set(i, this.dicts.get(id));
                continue;
            }
            this.dicts.add(DictionaryFactory.read(in));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Written dictionaries:\n");
        for (IDictionary d : this.dicts) {
            sb.append(d);
            sb.append("\n");
        }
        return sb.toString();
    }

    public static class K
    implements Writable,
    Serializable {
        private static final long serialVersionUID = 733937201435558L;
        public int id;

        public K() {
        }

        public K(int id) {
            this.id = id;
        }

        public void write(DataOutput out) throws IOException {
            out.writeInt(this.id);
        }

        public void readFields(DataInput in) throws IOException {
            this.id = in.readInt();
        }
    }
}

