/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import org.apache.commons.lang3.SystemUtils;
import org.apache.spark.internal.Logging;
import org.apache.spark.util.SignalUtils;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import sun.misc.Signal;

public final class SignalUtils$
implements Logging {
    public static SignalUtils$ MODULE$;
    private boolean loggerRegistered;
    private final HashMap<String, SignalUtils.ActionHandler> handlers;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new SignalUtils$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private boolean loggerRegistered() {
        return this.loggerRegistered;
    }

    private void loggerRegistered_$eq(boolean x$1) {
        this.loggerRegistered = x$1;
    }

    public synchronized void registerLogger(Logger log) {
        if (!this.loggerRegistered()) {
            ((IterableLike)new .colon.colon((Object)"TERM", (List)new .colon.colon((Object)"HUP", (List)new .colon.colon((Object)"INT", (List)Nil$.MODULE$)))).foreach((Function1 & java.io.Serializable & Serializable)sig -> {
                SignalUtils$.MODULE$.register(sig, (Function0<Object>)(JFunction0.mcZ.sp & java.io.Serializable & Serializable)() -> {
                    log$1.error(new StringBuilder(16).append("RECEIVED SIGNAL ").append(sig).toString());
                    return false;
                });
                return BoxedUnit.UNIT;
            });
            this.loggerRegistered_$eq(true);
            return;
        }
    }

    public void register(String signal, Function0<Object> action) {
        if (SystemUtils.IS_OS_UNIX) {
            this.register(signal, new StringBuilder(38).append("Failed to register signal handler for ").append(signal).toString(), true, action);
            return;
        }
    }

    public synchronized void register(String signal, String failMessage, boolean logStackTrace, Function0<Object> action) {
        block3: {
            try {
                SignalUtils.ActionHandler handler = (SignalUtils.ActionHandler)this.handlers().getOrElseUpdate((Object)signal, (Function0 & java.io.Serializable & Serializable)() -> {
                    MODULE$.logInfo((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(31).append("Registering signal handler for ").append(signal).toString());
                    return new SignalUtils.ActionHandler(new Signal(signal));
                });
                handler.register(action);
            }
            catch (Exception ex) {
                if (logStackTrace) {
                    this.logWarning((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> failMessage, ex);
                    break block3;
                }
                this.logWarning((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> failMessage);
            }
        }
    }

    public boolean register$default$3() {
        return true;
    }

    private HashMap<String, SignalUtils.ActionHandler> handlers() {
        return this.handlers;
    }

    private SignalUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.loggerRegistered = false;
        this.handlers = new HashMap();
    }
}

