/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io;

import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.frame.data.lib.FrameLibCompress;
import org.apache.sysds.runtime.io.FrameWriterBinaryBlockParallel;

public class FrameWriterCompressed
extends FrameWriterBinaryBlockParallel {
    private final boolean parallel;

    public FrameWriterCompressed(boolean parallel) {
        this.parallel = parallel;
    }

    @Override
    protected void writeBinaryBlockFrameToHDFS(Path path, JobConf job, FrameBlock src, long rlen, long clen) throws IOException, DMLRuntimeException {
        int k = this.parallel ? OptimizerUtils.getParallelBinaryWriteParallelism() : 1;
        FrameBlock compressed = FrameLibCompress.compress(src, k);
        super.writeBinaryBlockFrameToHDFS(path, job, compressed, rlen, clen);
    }
}

