/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.frame.data.compress;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.workload.WTreeRoot;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.frame.data.columns.Array;
import org.apache.sysds.runtime.frame.data.columns.DDCArray;
import org.apache.sysds.runtime.frame.data.compress.ArrayCompressionStatistics;
import org.apache.sysds.runtime.frame.data.compress.FrameCompressionSettings;
import org.apache.sysds.runtime.frame.data.compress.FrameCompressionSettingsBuilder;
import org.apache.sysds.runtime.util.CommonThreadPool;

public class CompressedFrameBlockFactory {
    private static final Log LOG = LogFactory.getLog((String)CompressedFrameBlockFactory.class.getName());
    private final FrameBlock in;
    private final FrameCompressionSettings cs;
    private final ArrayCompressionStatistics[] stats;
    private final Array<?>[] compressedColumns;
    private final int nSamples;

    private CompressedFrameBlockFactory(FrameBlock fb, FrameCompressionSettings cs) {
        this.in = fb;
        this.cs = cs;
        this.stats = new ArrayCompressionStatistics[this.in.getNumColumns()];
        this.compressedColumns = new Array[this.in.getNumColumns()];
        this.nSamples = Math.min(this.in.getNumRows(), (int)Math.ceil((float)this.in.getNumRows() * cs.sampleRatio));
    }

    public static FrameBlock compress(FrameBlock fb) {
        FrameCompressionSettings cs = new FrameCompressionSettingsBuilder().create();
        return CompressedFrameBlockFactory.compress(fb, cs);
    }

    public static FrameBlock compress(FrameBlock fb, int k, WTreeRoot root) {
        FrameCompressionSettings cs = new FrameCompressionSettingsBuilder().threads(k).wTreeRoot(root).create();
        return CompressedFrameBlockFactory.compress(fb, cs);
    }

    public static FrameBlock compress(FrameBlock fb, FrameCompressionSettingsBuilder csb) {
        return CompressedFrameBlockFactory.compress(fb, csb.create());
    }

    public static FrameBlock compress(FrameBlock fb, FrameCompressionSettings cs) {
        return new CompressedFrameBlockFactory(fb, cs).compressFrame();
    }

    private FrameBlock compressFrame() {
        this.encodeColumns();
        FrameBlock ret = new FrameBlock(this.compressedColumns, this.in.getColumnNames(false));
        this.logStatistics();
        this.logRet(ret);
        return ret;
    }

    private void encodeColumns() {
        if (this.cs.k > 1) {
            this.encodeParallel();
        } else {
            this.encodeSingleThread();
        }
    }

    private void encodeSingleThread() {
        for (int i = 0; i < this.compressedColumns.length; ++i) {
            this.compressCol(i);
        }
    }

    private void encodeParallel() {
        ExecutorService pool = CommonThreadPool.get(this.cs.k);
        try {
            ArrayList tasks = new ArrayList();
            int i = 0;
            while (i < this.compressedColumns.length) {
                int n = i++;
                tasks.add(pool.submit(() -> this.compressCol(l)));
            }
            for (Future future : tasks) {
                future.get();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            pool.shutdown();
        }
    }

    private void compressCol(int i) {
        this.stats[i] = this.in.getColumn(i).statistics(this.nSamples);
        if (this.stats[i] != null) {
            if (this.stats[i].bestType == null) {
                this.compressedColumns[i] = this.in.getColumn(i).safeChangeType(this.stats[i].valueType, this.stats[i].containsNull);
            } else {
                switch (this.stats[i].bestType) {
                    case DDC: {
                        this.compressedColumns[i] = DDCArray.compressToDDC(this.in.getColumn(i), this.stats[i].valueType, this.stats[i].containsNull);
                        break;
                    }
                    default: {
                        LOG.error((Object)("Unsupported encoding default to do nothing: " + this.stats[i].bestType));
                        this.compressedColumns[i] = this.in.getColumn(i);
                        break;
                    }
                }
            }
        } else {
            this.compressedColumns[i] = this.in.getColumn(i);
        }
    }

    private void logStatistics() {
        if (LOG.isDebugEnabled()) {
            for (int i = 0; i < this.compressedColumns.length; ++i) {
                if (this.stats[i] != null) {
                    LOG.debug((Object)String.format("Col: %3d, %s", i, this.stats[i]));
                    continue;
                }
                LOG.debug((Object)String.format("Col: %3d, No Compress, Type: %s", i, this.in.getColumn(i).getClass().getSimpleName()));
            }
        }
    }

    private void logRet(FrameBlock ret) {
        if (LOG.isDebugEnabled()) {
            long before = this.in.getInMemorySize();
            long after = ret.getInMemorySize();
            LOG.debug((Object)String.format("Uncompressed Size: %15d", before));
            LOG.debug((Object)String.format("compressed Size:   %15d", after));
            LOG.debug((Object)String.format("ratio:             %15.3f", (double)before / (double)after));
        }
    }
}

