/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.data;

import java.io.Serializable;
import java.util.Arrays;
import java.util.stream.IntStream;
import org.apache.commons.lang.math.IntRange;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.data.BasicTensorBlock;
import org.apache.sysds.runtime.data.TensorBlock;

public class DataTensorBlock
implements Serializable {
    private static final long serialVersionUID = 3410679389807309521L;
    private static final int VALID_VALUE_TYPES_LENGTH = Types.ValueType.values().length - 1;
    protected int[] _dims;
    protected BasicTensorBlock[] _colsdata = new BasicTensorBlock[VALID_VALUE_TYPES_LENGTH];
    protected Types.ValueType[] _schema = null;
    protected int[] _colsToIx = null;
    protected int[][] _ixToCols = null;

    public DataTensorBlock() {
        this(new Types.ValueType[0], TensorBlock.DEFAULT_DIMS);
    }

    public DataTensorBlock(int ncols, Types.ValueType vt) {
        this(vt, new int[]{0, ncols});
    }

    public DataTensorBlock(Types.ValueType[] schema) {
        int type;
        int i;
        this._dims = new int[]{0, schema.length};
        this._schema = schema;
        this._colsToIx = new int[this._schema.length];
        this._ixToCols = new int[VALID_VALUE_TYPES_LENGTH][];
        int[] typeIxCounter = new int[VALID_VALUE_TYPES_LENGTH];
        for (i = 0; i < schema.length; ++i) {
            int n = type = schema[i].ordinal();
            typeIxCounter[n] = typeIxCounter[n] + 1;
        }
        i = 0;
        while (i < schema.length) {
            type = schema[i].ordinal();
            if (this._ixToCols[type] == null) {
                this._ixToCols[type] = new int[typeIxCounter[type]];
                typeIxCounter[type] = 0;
            }
            int n = type;
            int n2 = typeIxCounter[n];
            typeIxCounter[n] = n2 + 1;
            this._ixToCols[type][n2] = i++;
        }
    }

    public DataTensorBlock(Types.ValueType[] schema, int[] dims) {
        int type;
        int i;
        this._dims = dims;
        this._schema = schema;
        this._colsToIx = new int[this._schema.length];
        this._ixToCols = new int[VALID_VALUE_TYPES_LENGTH][];
        int[] typeIxCounter = new int[VALID_VALUE_TYPES_LENGTH];
        for (i = 0; i < schema.length; ++i) {
            int n = type = schema[i].ordinal();
            typeIxCounter[n] = typeIxCounter[n] + 1;
        }
        i = 0;
        while (i < schema.length) {
            type = schema[i].ordinal();
            if (this._ixToCols[type] == null) {
                this._ixToCols[type] = new int[typeIxCounter[type]];
                typeIxCounter[type] = 0;
            }
            int n = type;
            int n2 = typeIxCounter[n];
            typeIxCounter[n] = n2 + 1;
            this._ixToCols[type][n2] = i++;
        }
        this.reset();
    }

    public DataTensorBlock(Types.ValueType vt, int[] dims) {
        this._dims = dims;
        this._schema = new Types.ValueType[this.getDim(1)];
        Arrays.fill((Object[])this._schema, (Object)vt);
        this._colsToIx = new IntRange(0, this.getDim(1)).toArray();
        this._ixToCols = new int[VALID_VALUE_TYPES_LENGTH][];
        this._ixToCols[vt.ordinal()] = new IntRange(0, this.getDim(1)).toArray();
        this.reset();
    }

    public DataTensorBlock(Types.ValueType[] schema, int[] dims, String[][] data) {
        this(schema, dims);
        this.allocateBlock();
        for (int i = 0; i < schema.length; ++i) {
            int[] ix = new int[dims.length];
            ix[1] = this._colsToIx[i];
            BasicTensorBlock current = this._colsdata[schema[i].ordinal()];
            for (int j = 0; j < data[i].length; ++j) {
                current.set(ix, data[i][j]);
                TensorBlock.getNextIndexes(this._dims, ix);
                if (ix[1] == this._colsToIx[i]) continue;
                if (ix[1] == 0) {
                    ix[1] = this._colsToIx[i];
                    continue;
                }
                ix[1] = this._colsToIx[i];
                ix[0] = ix[0] + 1;
            }
        }
    }

    public DataTensorBlock(double val) {
        this._dims = new int[]{1, 1};
        this._schema = new Types.ValueType[]{Types.ValueType.FP64};
        this._colsToIx = new int[]{0};
        this._ixToCols = new int[VALID_VALUE_TYPES_LENGTH][];
        this._ixToCols[Types.ValueType.FP64.ordinal()] = new int[]{0};
        this._colsdata = new BasicTensorBlock[VALID_VALUE_TYPES_LENGTH];
        this._colsdata[Types.ValueType.FP64.ordinal()] = new BasicTensorBlock(val);
    }

    public DataTensorBlock(DataTensorBlock that) {
        this.copy(that);
    }

    public DataTensorBlock(BasicTensorBlock that) {
        this._dims = that._dims;
        this._schema = new Types.ValueType[this._dims[1]];
        Arrays.fill((Object[])this._schema, (Object)that._vt);
        this._colsToIx = IntStream.range(0, this._dims[1]).toArray();
        this._ixToCols = new int[VALID_VALUE_TYPES_LENGTH][];
        this._ixToCols[that._vt.ordinal()] = IntStream.range(0, this._dims[1]).toArray();
        this._colsdata = new BasicTensorBlock[VALID_VALUE_TYPES_LENGTH];
        this._colsdata[that._vt.ordinal()] = that;
    }

    public void reset() {
        this.reset(this._dims);
    }

    public void reset(int[] dims) {
        if (dims.length < 2) {
            throw new DMLRuntimeException("DataTensor.reset(int[]) invalid number of tensor dimensions: " + dims.length);
        }
        if (dims[1] > this._dims[1]) {
            throw new DMLRuntimeException("DataTensor.reset(int[]) columns can not be added without a provided schema, use reset(int[],ValueType[]) instead");
        }
        for (int i = 0; i < dims.length; ++i) {
            if (dims[i] >= 0) continue;
            throw new DMLRuntimeException("DataTensor.reset(int[]) invalid  dimension " + i + ": " + dims[i]);
        }
        this._dims = dims;
        if (this.getDim(1) < this._schema.length) {
            Types.ValueType[] schema = new Types.ValueType[this.getDim(1)];
            System.arraycopy(this._schema, 0, schema, 0, this.getDim(1));
            this._schema = schema;
        }
        this.reset(this._dims, this._schema);
    }

    public void reset(int[] dims, Types.ValueType[] schema) {
        if (dims.length < 2) {
            throw new DMLRuntimeException("DataTensor.reset(int[],ValueType[]) invalid number of tensor dimensions: " + dims.length);
        }
        if (dims[1] != schema.length) {
            throw new DMLRuntimeException("DataTensor.reset(int[],ValueType[]) column dimension and schema length does not match");
        }
        for (int i = 0; i < dims.length; ++i) {
            if (dims[i] >= 0) continue;
            throw new DMLRuntimeException("DataTensor.reset(int[],ValueType[]) invalid  dimension " + i + ": " + dims[i]);
        }
        this._dims = dims;
        this._schema = schema;
        this._colsToIx = new int[this._schema.length];
        int[] typeIxCounter = new int[VALID_VALUE_TYPES_LENGTH];
        for (int i = 0; i < schema.length; ++i) {
            int type;
            int n = type = schema[i].ordinal();
            typeIxCounter[n] = typeIxCounter[n] + 1;
        }
        int[] colCounters = new int[VALID_VALUE_TYPES_LENGTH];
        int i = 0;
        while (i < this.getDim(1)) {
            int type = this._schema[i].ordinal();
            if (this._ixToCols[type] == null || this._ixToCols[type].length != typeIxCounter[type]) {
                this._ixToCols[type] = new int[typeIxCounter[type]];
            }
            int n = type;
            int n2 = colCounters[n];
            colCounters[n] = n2 + 1;
            this._ixToCols[type][n2] = i++;
        }
        if (this._colsdata == null) {
            this.allocateBlock();
        } else {
            for (i = 0; i < this._colsdata.length; ++i) {
                if (this._colsdata[i] != null) {
                    this._colsdata[i].reset(DataTensorBlock.toInternalDims(dims, typeIxCounter[i]));
                    continue;
                }
                if (typeIxCounter[i] == 0) continue;
                int[] colDims = DataTensorBlock.toInternalDims(this._dims, typeIxCounter[i]);
                this._colsdata[i] = new BasicTensorBlock(Types.ValueType.values()[i], colDims, false);
                this._colsdata[i].allocateBlock();
            }
        }
    }

    public DataTensorBlock allocateBlock() {
        if (this._colsdata == null) {
            this._colsdata = new BasicTensorBlock[VALID_VALUE_TYPES_LENGTH];
        }
        int[] colDataColumnLength = new int[this._colsdata.length];
        for (Types.ValueType valueType : this._schema) {
            int n = valueType.ordinal();
            colDataColumnLength[n] = colDataColumnLength[n] + 1;
        }
        for (int i = 0; i < this._colsdata.length; ++i) {
            if (colDataColumnLength[i] == 0) continue;
            int[] dims = DataTensorBlock.toInternalDims(this._dims, colDataColumnLength[i]);
            this._colsdata[i] = new BasicTensorBlock(Types.ValueType.values()[i], dims, false);
            this._colsdata[i].allocateBlock();
        }
        return this;
    }

    public boolean isAllocated() {
        if (this._colsdata == null) {
            return false;
        }
        for (BasicTensorBlock block : this._colsdata) {
            if (block == null || !block.isAllocated()) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty(boolean safe) {
        if (!this.isAllocated()) {
            return true;
        }
        for (BasicTensorBlock tb : this._colsdata) {
            if (tb == null || tb.isEmpty(safe)) continue;
            return false;
        }
        return true;
    }

    public long getNonZeros() {
        if (!this.isAllocated()) {
            return 0L;
        }
        long nnz = 0L;
        for (BasicTensorBlock bt : this._colsdata) {
            if (bt == null) continue;
            nnz += bt.getNonZeros();
        }
        return nnz;
    }

    public int getNumRows() {
        return this.getDim(0);
    }

    public int getNumColumns() {
        return this.getDim(1);
    }

    public int getNumDims() {
        return this._dims.length;
    }

    public int getDim(int i) {
        return this._dims[i];
    }

    public int[] getDims() {
        return this._dims;
    }

    public Types.ValueType[] getSchema() {
        return this._schema;
    }

    public Types.ValueType getColValueType(int col) {
        return this._schema[col];
    }

    public Object get(int[] ix) {
        int columns = ix[1];
        int[] internalIx = DataTensorBlock.toInternalIx(ix, this._colsToIx[columns]);
        return this._colsdata[this._schema[columns].ordinal()].get(internalIx);
    }

    public double get(int r, int c) {
        if (this.getNumDims() != 2) {
            throw new DMLRuntimeException("DataTensor.get(int,int) dimension mismatch: expected=2 actual=" + this.getNumDims());
        }
        return this._colsdata[this._schema[c].ordinal()].get(r, this._colsToIx[c]);
    }

    public void set(Object v) {
        for (BasicTensorBlock bt : this._colsdata) {
            bt.set(v);
        }
    }

    public void set(int[] ix, Object v) {
        int columns = ix[1];
        int[] internalIx = DataTensorBlock.toInternalIx(ix, this._colsToIx[columns]);
        this._colsdata[this._schema[columns].ordinal()].set(internalIx, v);
    }

    public void set(int r, int c, double v) {
        if (this.getNumDims() != 2) {
            throw new DMLRuntimeException("DataTensor.set(int,int,double) dimension mismatch: expected=2 actual=" + this.getNumDims());
        }
        this._colsdata[this._schema[c].ordinal()].set(r, this._colsToIx[c], v);
    }

    public void copy(DataTensorBlock that) {
        int i;
        this._dims = (int[])that._dims.clone();
        this._schema = (Types.ValueType[])that._schema.clone();
        this._colsToIx = (int[])that._colsToIx.clone();
        this._ixToCols = new int[that._ixToCols.length][];
        for (i = 0; i < this._ixToCols.length; ++i) {
            if (that._ixToCols[i] == null) continue;
            this._ixToCols[i] = (int[])that._ixToCols[i].clone();
        }
        if (that.isAllocated()) {
            for (i = 0; i < this._colsdata.length; ++i) {
                if (that._colsdata[i] == null) continue;
                this._colsdata[i] = new BasicTensorBlock(that._colsdata[i]);
            }
        }
    }

    public void copy(int[] lower, int[] upper, DataTensorBlock src) {
        int[] subLower = (int[])lower.clone();
        if (upper[1] == 0) {
            upper[1] = this.getDim(1);
            upper[0] = upper[0] - 1;
        }
        int[] subUpper = (int[])upper.clone();
        for (int i = 0; i < VALID_VALUE_TYPES_LENGTH; ++i) {
            if (src._colsdata[i] == null) continue;
            subLower[1] = lower[1];
            subUpper[1] = lower[1] + src._colsdata[i].getNumColumns();
            this._colsdata[i].copy(subLower, subUpper, src._colsdata[i]);
        }
    }

    private static int[] toInternalIx(int[] ix, int col) {
        int[] internalIx = (int[])ix.clone();
        internalIx[1] = col;
        return internalIx;
    }

    private static int[] toInternalDims(int[] dims, int cols) {
        int[] internalDims = (int[])dims.clone();
        internalDims[1] = cols;
        return internalDims;
    }
}

