/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.parser;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.parser.ConstIdentifier;
import org.apache.sysds.parser.DataExpression;
import org.apache.sysds.parser.DataIdentifier;
import org.apache.sysds.parser.DoubleIdentifier;
import org.apache.sysds.parser.Expression;
import org.apache.sysds.parser.FunctionCallIdentifier;
import org.apache.sysds.parser.Identifier;
import org.apache.sysds.parser.IndexPair;
import org.apache.sysds.parser.IntIdentifier;
import org.apache.sysds.parser.ParseInfo;
import org.apache.sysds.parser.VariableSet;
import org.apache.sysds.runtime.util.UtilFunctions;

public class IndexedIdentifier
extends DataIdentifier {
    private static final Log LOG = LogFactory.getLog((String)DataExpression.class.getName());
    private Expression _rowLowerBound = null;
    private Expression _rowUpperBound = null;
    private Expression _colLowerBound = null;
    private Expression _colUpperBound = null;
    private boolean _rowLowerEqualsUpper = false;
    private boolean _colLowerEqualsUpper = false;
    private long _origDim1;
    private long _origDim2;

    public boolean getRowLowerEqualsUpper() {
        return this._rowLowerEqualsUpper;
    }

    public boolean getColLowerEqualsUpper() {
        return this._colLowerEqualsUpper;
    }

    public void setRowLowerEqualsUpper(boolean passed) {
        this._rowLowerEqualsUpper = passed;
    }

    public void setColLowerEqualsUpper(boolean passed) {
        this._colLowerEqualsUpper = passed;
    }

    public IndexedIdentifier(String name, boolean passedRows, boolean passedCols) {
        super(name);
        this._rowLowerEqualsUpper = passedRows;
        this._colLowerEqualsUpper = passedCols;
        this._origDim1 = -1L;
        this._origDim2 = -1L;
    }

    public IndexPair calculateIndexedDimensions(HashMap<String, DataIdentifier> ids, HashMap<String, ConstIdentifier> currConstVars, boolean conditional) {
        String identifierName;
        String identifierName2;
        String identifierName3;
        long updatedRowDim = -1L;
        long updatedColDim = -1L;
        boolean isConst_rowLowerBound = false;
        boolean isConst_rowUpperBound = false;
        boolean isConst_colLowerBound = false;
        boolean isConst_colUpperBound = false;
        if (this._rowLowerBound instanceof ConstIdentifier && (this._rowLowerBound instanceof IntIdentifier || this._rowLowerBound instanceof DoubleIdentifier)) {
            Long rowLB_1_1 = -1L;
            rowLB_1_1 = this._rowLowerBound instanceof IntIdentifier ? Long.valueOf(((IntIdentifier)this._rowLowerBound).getValue()) : Long.valueOf(UtilFunctions.toLong(((DoubleIdentifier)this._rowLowerBound).getValue()));
            if (rowLB_1_1 < 1L) {
                this.raiseValidateError("lower-bound row index " + rowLB_1_1 + " initialized to out of bounds value. Value must be >= 1", conditional);
            }
            if (this.getOrigDim1() >= 0L && rowLB_1_1 > this.getOrigDim1()) {
                this.raiseValidateError("lower-bound row index " + rowLB_1_1 + " initialized to out of bounds value.  Rows in " + this.getName() + ": " + this.getOrigDim1(), conditional);
            }
            isConst_rowLowerBound = true;
        } else if (this._rowLowerBound instanceof ConstIdentifier && !this.getDataType().isList()) {
            this.raiseValidateError("assign lower-bound row index for Indexed Identifier " + this.toString() + " the non-numeric value " + this._rowLowerBound.toString(), conditional);
        } else if (this._rowLowerBound != null && this._rowLowerBound instanceof DataIdentifier && !(this._rowLowerBound instanceof IndexedIdentifier) && currConstVars.containsKey(identifierName3 = ((DataIdentifier)this._rowLowerBound).getName()) && !conditional) {
            ConstIdentifier constValue = currConstVars.get(identifierName3);
            if (!(constValue instanceof IntIdentifier) && !(constValue instanceof DoubleIdentifier)) {
                LOG.info((Object)(this.printInfoLocation() + "attempted to assign lower row bound for " + this.toString() + "the non-numeric value " + constValue.getOutput().toString() + " assigned to " + identifierName3 + ". May cause runtime exception "));
            } else {
                long tempRowLB = -1L;
                boolean validRowLB = true;
                tempRowLB = constValue instanceof IntIdentifier ? ((IntIdentifier)constValue).getValue() : UtilFunctions.toLong(((DoubleIdentifier)constValue).getValue());
                if (tempRowLB < 1L) {
                    LOG.info((Object)(this.printInfoLocation() + "lower-bound row index " + identifierName3 + " initialized to " + tempRowLB + " May cause runtime exception (runtime value must be >= 1)"));
                    validRowLB = false;
                }
                if (this.getOrigDim1() >= 0L && tempRowLB > this.getOrigDim1()) {
                    LOG.info((Object)(this.printInfoLocation() + "lower-bound row index " + identifierName3 + " initialized to " + tempRowLB + " May cause runtime exception (Rows in " + this.getName() + ": " + this.getOrigDim1() + ")"));
                    validRowLB = false;
                }
                if (validRowLB) {
                    this._rowLowerBound = constValue instanceof IntIdentifier ? new IntIdentifier((IntIdentifier)constValue, (ParseInfo)constValue) : new DoubleIdentifier((DoubleIdentifier)constValue, (ParseInfo)constValue);
                    isConst_rowLowerBound = true;
                }
            }
        }
        Long rowLB_1 = -1L;
        if (isConst_rowLowerBound) {
            rowLB_1 = this._rowLowerBound instanceof IntIdentifier ? Long.valueOf(((IntIdentifier)this._rowLowerBound).getValue()) : Long.valueOf(UtilFunctions.toLong(((DoubleIdentifier)this._rowLowerBound).getValue()));
        }
        if (this._rowUpperBound instanceof ConstIdentifier && (this._rowUpperBound instanceof IntIdentifier || this._rowUpperBound instanceof DoubleIdentifier)) {
            Long rowUB_1_1 = -1L;
            rowUB_1_1 = this._rowUpperBound instanceof IntIdentifier ? Long.valueOf(((IntIdentifier)this._rowUpperBound).getValue()) : Long.valueOf(UtilFunctions.toLong(((DoubleIdentifier)this._rowUpperBound).getValue()));
            if (rowUB_1_1 < 1L) {
                this.raiseValidateError("upper-bound row index " + rowUB_1_1 + " out of bounds value. Value must be >= 1", conditional);
            }
            if (this.getOrigDim1() >= 0L && rowUB_1_1 > this.getOrigDim1()) {
                this.raiseValidateError("upper-bound row index " + rowUB_1_1 + " out of bounds value.  Rows in " + this.getName() + ": " + this.getOrigDim1(), conditional);
            }
            if (isConst_rowLowerBound && rowUB_1_1 < rowLB_1) {
                this.raiseValidateError("upper-bound row index " + rowUB_1_1 + " greater than lower-bound row index " + rowLB_1, conditional);
            }
            isConst_rowUpperBound = true;
        } else if (this._rowUpperBound instanceof ConstIdentifier && !this.getDataType().isList()) {
            this.raiseValidateError("assign upper-bound row index for " + this.toString() + " the non-numeric value " + this._rowUpperBound.toString(), conditional);
        } else if (this._rowUpperBound != null && this._rowUpperBound instanceof DataIdentifier && !(this._rowUpperBound instanceof IndexedIdentifier) && currConstVars.containsKey(identifierName2 = ((DataIdentifier)this._rowUpperBound).getName()) && !conditional) {
            ConstIdentifier constValue = currConstVars.get(identifierName2);
            if (!(constValue instanceof IntIdentifier) && !(constValue instanceof DoubleIdentifier)) {
                LOG.info((Object)(this.printInfoLocation() + "attempted to assign upper row bound for " + this.toString() + "the non-numeric value " + constValue.getOutput().toString() + " assigned to " + identifierName2 + ". May cause runtime exception "));
            } else {
                long tempRowUB = -1L;
                boolean validRowUB = true;
                tempRowUB = constValue instanceof IntIdentifier ? ((IntIdentifier)constValue).getValue() : UtilFunctions.toLong(((DoubleIdentifier)constValue).getValue());
                if (tempRowUB < 1L) {
                    LOG.info((Object)(this.printInfoLocation() + "upper-bound row index " + identifierName2 + " initialized to " + tempRowUB + " May cause runtime exception (runtime value must be >= 1)"));
                    validRowUB = false;
                }
                if (this.getOrigDim1() >= 0L && tempRowUB > this.getOrigDim1()) {
                    LOG.info((Object)(this.printInfoLocation() + "upper-bound row index " + identifierName2 + " initialized to " + tempRowUB + " May cause runtime exception (Rows in " + this.getName() + ": " + this.getOrigDim1() + ")"));
                    validRowUB = false;
                }
                if (isConst_rowLowerBound && tempRowUB < rowLB_1) {
                    LOG.info((Object)(this.printInfoLocation() + "upper-bound row index " + identifierName2 + " initialized to " + tempRowUB + ", which is greater than lower-bound row index value " + rowLB_1 + " May cause runtime exception"));
                    validRowUB = false;
                }
                if (validRowUB) {
                    this._rowUpperBound = constValue instanceof IntIdentifier ? new IntIdentifier((IntIdentifier)constValue, (ParseInfo)constValue) : new DoubleIdentifier((DoubleIdentifier)constValue, (ParseInfo)constValue);
                    isConst_rowUpperBound = true;
                }
            }
        }
        if (this._colLowerBound instanceof ConstIdentifier && (this._colLowerBound instanceof IntIdentifier || this._colLowerBound instanceof DoubleIdentifier)) {
            Long colLB_1_1 = -1L;
            colLB_1_1 = this._colLowerBound instanceof IntIdentifier ? Long.valueOf(((IntIdentifier)this._colLowerBound).getValue()) : Long.valueOf(UtilFunctions.toLong(((DoubleIdentifier)this._colLowerBound).getValue()));
            if (colLB_1_1 < 1L) {
                this.raiseValidateError("lower-bound column index " + colLB_1_1 + " initialized to out of bounds value. Value must be >= 1", conditional);
            }
            if (this.getOrigDim2() >= 0L && colLB_1_1 > this.getOrigDim2()) {
                this.raiseValidateError("lower-bound column index " + colLB_1_1 + " initialized to out of bounds value.  Columns in " + this.getName() + ": " + this.getOrigDim2(), conditional);
            }
            isConst_colLowerBound = true;
        } else if (this._colLowerBound instanceof ConstIdentifier && !this.getDataType().isList()) {
            this.raiseValidateError("assign lower-bound column index for Indexed Identifier " + this.toString() + " the non-numeric value " + this._colLowerBound.toString(), conditional);
        } else if (this._colLowerBound != null && this._colLowerBound instanceof DataIdentifier && !(this._colLowerBound instanceof IndexedIdentifier) && currConstVars.containsKey(identifierName2 = ((DataIdentifier)this._colLowerBound).getName()) && !conditional) {
            ConstIdentifier constValue = currConstVars.get(identifierName2);
            if (!(constValue instanceof IntIdentifier) && !(constValue instanceof DoubleIdentifier)) {
                LOG.info((Object)(this.printInfoLocation() + "attempted to assign lower column bound for " + this.toString() + "the non-numeric value " + constValue.getOutput().toString() + " assigned to " + identifierName2 + ". May cause runtime exception "));
            } else {
                long tempColLB = -1L;
                boolean validColLB = true;
                tempColLB = constValue instanceof IntIdentifier ? ((IntIdentifier)constValue).getValue() : UtilFunctions.toLong(((DoubleIdentifier)constValue).getValue());
                if (tempColLB < 1L) {
                    LOG.info((Object)(this.printInfoLocation() + "lower-bound column index " + identifierName2 + " initialized to " + tempColLB + " May cause runtime exception (runtime value must be >= 1)"));
                    validColLB = false;
                }
                if (this.getOrigDim2() >= 0L && tempColLB > this.getOrigDim2()) {
                    LOG.info((Object)(this.printInfoLocation() + "lower-bound column index " + identifierName2 + " initialized to " + tempColLB + " May cause runtime exception (Columns in " + this.getName() + ": " + this.getOrigDim2() + ")"));
                    validColLB = false;
                }
                if (validColLB) {
                    this._colLowerBound = constValue instanceof IntIdentifier ? new IntIdentifier((IntIdentifier)constValue, (ParseInfo)constValue) : new DoubleIdentifier((DoubleIdentifier)constValue, (ParseInfo)constValue);
                    isConst_colLowerBound = true;
                }
            }
        }
        Long colLB_1 = -1L;
        if (isConst_colLowerBound) {
            colLB_1 = this._colLowerBound instanceof IntIdentifier ? Long.valueOf(((IntIdentifier)this._colLowerBound).getValue()) : Long.valueOf(UtilFunctions.toLong(((DoubleIdentifier)this._colLowerBound).getValue()));
        }
        if (this._colUpperBound instanceof ConstIdentifier && (this._colUpperBound instanceof IntIdentifier || this._colUpperBound instanceof DoubleIdentifier)) {
            Long colUB_1_1 = -1L;
            colUB_1_1 = this._colUpperBound instanceof IntIdentifier ? Long.valueOf(((IntIdentifier)this._colUpperBound).getValue()) : Long.valueOf(UtilFunctions.toLong(((DoubleIdentifier)this._colUpperBound).getValue()));
            if (colUB_1_1 < 1L) {
                this.raiseValidateError("upper-bound column index " + colUB_1_1 + " out of bounds value. Value must be >= 1", conditional);
            }
            if (this.getOrigDim2() >= 0L && colUB_1_1 > this.getOrigDim2()) {
                this.raiseValidateError("upper-bound column index " + colUB_1_1 + " out of bounds value.  Columns in " + this.getName() + ": " + this.getOrigDim2(), conditional);
            }
            if (isConst_rowLowerBound && colUB_1_1 < colLB_1) {
                this.raiseValidateError("upper-bound column index " + colUB_1_1 + " greater than lower-bound row index " + colLB_1, conditional);
            }
            isConst_colUpperBound = true;
        } else if (this._colUpperBound instanceof ConstIdentifier && !this.getDataType().isList()) {
            this.raiseValidateError("assign upper-bound column index for " + this.toString() + " the non-numeric value " + this._colUpperBound.toString(), conditional);
        } else if (this._colUpperBound != null && this._colUpperBound instanceof DataIdentifier && !(this._colUpperBound instanceof IndexedIdentifier) && currConstVars.containsKey(identifierName = ((DataIdentifier)this._colUpperBound).getName()) && !conditional) {
            ConstIdentifier constValue = currConstVars.get(identifierName);
            if (!(constValue instanceof IntIdentifier) && !(constValue instanceof DoubleIdentifier)) {
                LOG.info((Object)(this.printInfoLocation() + "attempted to assign upper column bound for " + this.toString() + "the non-numeric value " + constValue.getOutput().toString() + " assigned to " + identifierName + ". May cause runtime exception "));
            } else {
                long tempColUB = -1L;
                boolean validColUB = true;
                tempColUB = constValue instanceof IntIdentifier ? ((IntIdentifier)constValue).getValue() : UtilFunctions.toLong(((DoubleIdentifier)constValue).getValue());
                if (tempColUB < 1L) {
                    LOG.info((Object)(this.printInfoLocation() + "upper-bound column index " + identifierName + " initialized to " + tempColUB + " May cause runtime exception (runtime value must be >= 1)"));
                    validColUB = false;
                }
                if (this.getOrigDim2() >= 0L && tempColUB > this.getOrigDim2()) {
                    LOG.info((Object)(this.printInfoLocation() + "upper-bound column index " + identifierName + " initialized to " + tempColUB + " May cause runtime exception (Columns in " + this.getName() + ": " + this.getOrigDim2() + ")"));
                    validColUB = false;
                }
                if (isConst_colLowerBound && tempColUB < colLB_1) {
                    LOG.info((Object)(this.printInfoLocation() + "upper-bound column index " + identifierName + " initialized to " + tempColUB + ", which is greater than lower-bound column index value " + colLB_1 + " May cause runtime exception"));
                    validColUB = false;
                }
                if (validColUB) {
                    this._colUpperBound = constValue instanceof IntIdentifier ? new IntIdentifier((IntIdentifier)constValue, (ParseInfo)constValue) : new DoubleIdentifier((DoubleIdentifier)constValue, (ParseInfo)constValue);
                    isConst_colUpperBound = true;
                }
            }
        }
        if (this._rowLowerEqualsUpper) {
            updatedRowDim = 1L;
        } else if (this._rowLowerBound == null && this._rowUpperBound == null) {
            updatedRowDim = this.getOrigDim1();
        } else if (this._rowLowerBound == null && isConst_rowUpperBound) {
            if (this._rowUpperBound instanceof IntIdentifier) {
                updatedRowDim = ((IntIdentifier)this._rowUpperBound).getValue();
            } else if (this._rowUpperBound instanceof DoubleIdentifier) {
                updatedRowDim = UtilFunctions.toLong(((DoubleIdentifier)this._rowUpperBound).getValue());
            }
        } else if (isConst_rowLowerBound && this._rowUpperBound == null && this.getOrigDim1() >= 0L) {
            long rowCount = this.getOrigDim1();
            if (this._rowLowerBound instanceof IntIdentifier) {
                updatedRowDim = rowCount - ((IntIdentifier)this._rowLowerBound).getValue() + 1L;
            } else if (this._rowLowerBound instanceof DoubleIdentifier) {
                updatedRowDim = UtilFunctions.toLong((double)rowCount - ((DoubleIdentifier)this._rowLowerBound).getValue() + 1.0);
            }
        } else if (isConst_rowLowerBound && isConst_rowUpperBound) {
            if (this._rowLowerBound instanceof IntIdentifier && this._rowUpperBound instanceof IntIdentifier) {
                updatedRowDim = ((IntIdentifier)this._rowUpperBound).getValue() - ((IntIdentifier)this._rowLowerBound).getValue() + 1L;
            } else if (this._rowLowerBound instanceof DoubleIdentifier && this._rowUpperBound instanceof DoubleIdentifier) {
                updatedRowDim = UtilFunctions.toLong(((DoubleIdentifier)this._rowUpperBound).getValue() - ((DoubleIdentifier)this._rowLowerBound).getValue() + 1.0);
            } else if (this._rowLowerBound instanceof IntIdentifier && this._rowUpperBound instanceof DoubleIdentifier) {
                updatedRowDim = UtilFunctions.toLong(((DoubleIdentifier)this._rowUpperBound).getValue() - (double)((IntIdentifier)this._rowLowerBound).getValue() + 1.0);
            } else if (this._rowLowerBound instanceof DoubleIdentifier && this._rowUpperBound instanceof IntIdentifier) {
                updatedRowDim = UtilFunctions.toLong((double)((IntIdentifier)this._rowUpperBound).getValue() - ((DoubleIdentifier)this._rowLowerBound).getValue() + 1.0);
            }
        } else {
            updatedRowDim = -1L;
        }
        if (this._colLowerEqualsUpper) {
            updatedColDim = 1L;
        } else if (this._colLowerBound == null && this._colUpperBound == null) {
            updatedColDim = this.getOrigDim2();
        } else if (this._colLowerBound == null && isConst_colUpperBound) {
            if (this._colUpperBound instanceof IntIdentifier) {
                updatedColDim = ((IntIdentifier)this._colUpperBound).getValue();
            } else if (this._colUpperBound instanceof DoubleIdentifier) {
                updatedColDim = UtilFunctions.toLong(((DoubleIdentifier)this._colUpperBound).getValue());
            }
        } else if (isConst_colLowerBound && this._colUpperBound == null && this.getOrigDim2() >= 0L) {
            long colCount = this.getOrigDim2();
            if (this._colLowerBound instanceof IntIdentifier) {
                updatedColDim = colCount - ((IntIdentifier)this._colLowerBound).getValue() + 1L;
            } else if (this._colLowerBound instanceof DoubleIdentifier) {
                updatedColDim = UtilFunctions.toLong((double)colCount - ((DoubleIdentifier)this._colLowerBound).getValue() + 1.0);
            }
        } else if (isConst_colLowerBound && isConst_colUpperBound) {
            if (this._colLowerBound instanceof IntIdentifier && this._colUpperBound instanceof IntIdentifier) {
                updatedColDim = ((IntIdentifier)this._colUpperBound).getValue() - ((IntIdentifier)this._colLowerBound).getValue() + 1L;
            } else if (this._colLowerBound instanceof DoubleIdentifier && this._colUpperBound instanceof DoubleIdentifier) {
                updatedColDim = UtilFunctions.toLong(((DoubleIdentifier)this._colUpperBound).getValue() - ((DoubleIdentifier)this._colLowerBound).getValue() + 1.0);
            } else if (this._colLowerBound instanceof IntIdentifier && this._colUpperBound instanceof DoubleIdentifier) {
                updatedColDim = UtilFunctions.toLong(((DoubleIdentifier)this._colUpperBound).getValue() - (double)((IntIdentifier)this._colLowerBound).getValue() + 1.0);
            } else if (this._colLowerBound instanceof DoubleIdentifier && this._colUpperBound instanceof IntIdentifier) {
                updatedColDim = UtilFunctions.toLong((double)((IntIdentifier)this._colUpperBound).getValue() - ((DoubleIdentifier)this._colLowerBound).getValue() + 1.0);
            }
        } else {
            updatedColDim = -1L;
        }
        return new IndexPair(updatedRowDim, updatedColDim);
    }

    public void setOriginalDimensions(long passedDim1, long passedDim2) {
        this._origDim1 = passedDim1;
        this._origDim2 = passedDim2;
    }

    public long getOrigDim1() {
        return this._origDim1;
    }

    public long getOrigDim2() {
        return this._origDim2;
    }

    @Override
    public Expression rewriteExpression(String prefix) {
        IndexedIdentifier newIndexedIdentifier = new IndexedIdentifier(this.getName(), this._rowLowerEqualsUpper, this._colLowerEqualsUpper);
        newIndexedIdentifier.setParseInfo(this);
        newIndexedIdentifier.setProperties(this);
        newIndexedIdentifier.setOriginalDimensions(this._origDim1, this._origDim2);
        newIndexedIdentifier._name = prefix + this._name;
        newIndexedIdentifier._valueTypeString = this.getValueType().toString();
        newIndexedIdentifier._rowLowerBound = this._rowLowerBound == null ? null : this._rowLowerBound.rewriteExpression(prefix);
        newIndexedIdentifier._rowUpperBound = this._rowUpperBound == null ? null : this._rowUpperBound.rewriteExpression(prefix);
        newIndexedIdentifier._colLowerBound = this._colLowerBound == null ? null : this._colLowerBound.rewriteExpression(prefix);
        newIndexedIdentifier._colUpperBound = this._colUpperBound == null ? null : this._colUpperBound.rewriteExpression(prefix);
        return newIndexedIdentifier;
    }

    public void setIndices(ArrayList<ArrayList<Expression>> passed) {
        if (passed.size() != 2) {
            this.raiseValidateError("matrix indices must be specified for 2 dimensions");
        }
        ArrayList<Expression> rowIndices = passed.get(0);
        ArrayList<Expression> colIndices = passed.get(1);
        if (rowIndices.size() == 2) {
            this._rowLowerBound = rowIndices.get(0);
            this._rowUpperBound = rowIndices.get(1);
        } else if (rowIndices.size() == 1) {
            this._rowLowerBound = rowIndices.get(0);
            this._rowUpperBound = rowIndices.get(0);
            this._rowLowerEqualsUpper = true;
        } else {
            this.raiseValidateError("row indices are length " + rowIndices.size() + " -- should be either 1 or 2");
        }
        if (colIndices.size() == 2) {
            this._colLowerBound = colIndices.get(0);
            this._colUpperBound = colIndices.get(1);
        } else if (colIndices.size() == 1) {
            this._colLowerBound = colIndices.get(0);
            this._colUpperBound = colIndices.get(0);
            this._colLowerEqualsUpper = true;
        } else {
            this.raiseValidateError("column indices are length " + colIndices.size() + " -- should be either 1 or 2");
        }
        if (this._rowLowerBound instanceof FunctionCallIdentifier || this._rowUpperBound instanceof FunctionCallIdentifier || this._colLowerBound instanceof FunctionCallIdentifier || this._colUpperBound instanceof FunctionCallIdentifier) {
            this.raiseValidateError("UDF functions not supported for row or column indices");
        }
    }

    public Expression getRowLowerBound() {
        return this._rowLowerBound;
    }

    public Expression getRowUpperBound() {
        return this._rowUpperBound;
    }

    public Expression getColLowerBound() {
        return this._colLowerBound;
    }

    public Expression getColUpperBound() {
        return this._colUpperBound;
    }

    public void setRowLowerBound(Expression passed) {
        this._rowLowerBound = passed;
    }

    public void setRowUpperBound(Expression passed) {
        this._rowUpperBound = passed;
    }

    public void setColLowerBound(Expression passed) {
        this._colLowerBound = passed;
    }

    public void setColUpperBound(Expression passed) {
        this._colUpperBound = passed;
    }

    @Override
    public String toString() {
        Object retVal = this.getName();
        if (this._rowLowerBound != null || this._rowUpperBound != null || this._colLowerBound != null || this._colUpperBound != null) {
            retVal = (String)retVal + "[";
            if (this._rowLowerBound != null && this._rowUpperBound != null) {
                retVal = this._rowLowerBound.toString().equals(this._rowUpperBound.toString()) ? (String)retVal + this._rowLowerBound.toString() : (String)retVal + this._rowLowerBound.toString() + ":" + this._rowUpperBound.toString();
            } else if (this._rowLowerBound != null || this._rowUpperBound != null) {
                if (this._rowLowerBound != null) {
                    retVal = (String)retVal + this._rowLowerBound.toString();
                }
                retVal = (String)retVal + ":";
                if (this._rowUpperBound != null) {
                    retVal = (String)retVal + this._rowUpperBound.toString();
                }
            }
            retVal = (String)retVal + ",";
            if (this._colLowerBound != null && this._colUpperBound != null) {
                retVal = this._colLowerBound.toString().equals(this._colUpperBound.toString()) ? (String)retVal + this._colLowerBound.toString() : (String)retVal + this._colLowerBound.toString() + ":" + this._colUpperBound.toString();
            } else if (this._colLowerBound != null || this._colUpperBound != null) {
                if (this._colLowerBound != null) {
                    retVal = (String)retVal + this._colLowerBound.toString();
                }
                retVal = (String)retVal + ":";
                if (this._colUpperBound != null) {
                    retVal = (String)retVal + this._colUpperBound.toString();
                }
            }
            retVal = (String)retVal + "]";
        }
        return retVal;
    }

    @Override
    public VariableSet variablesRead() {
        VariableSet result = new VariableSet();
        result.addVariable(this.getName(), this);
        if (this._rowLowerBound != null) {
            result.addVariables(this._rowLowerBound.variablesRead());
        }
        if (this._rowUpperBound != null) {
            result.addVariables(this._rowUpperBound.variablesRead());
        }
        if (this._colLowerBound != null) {
            result.addVariables(this._colLowerBound.variablesRead());
        }
        if (this._colUpperBound != null) {
            result.addVariables(this._colUpperBound.variablesRead());
        }
        return result;
    }

    @Override
    public void setProperties(Identifier i) {
        this._dataType = i.getDataType();
        this._valueType = i.getValueType();
        this._dim1 = i.getDim1();
        this._dim2 = i.getDim2();
        this._blocksize = i.getBlocksize();
        this._nnz = i.getNnz();
        this._format = i.getFileFormat();
        if (i instanceof IndexedIdentifier) {
            this._origDim1 = ((IndexedIdentifier)i).getOrigDim1();
            this._origDim2 = ((IndexedIdentifier)i).getOrigDim2();
        } else {
            this._origDim1 = i.getDim1();
            this._origDim2 = i.getDim2();
        }
    }

    @Override
    public boolean multipleReturns() {
        return false;
    }
}

