/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.commons.compiler;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.commons.compiler.ErrorHandler;
import org.codehaus.commons.compiler.WarningHandler;
import org.codehaus.commons.compiler.util.resource.DirectoryResourceCreator;
import org.codehaus.commons.compiler.util.resource.DirectoryResourceFinder;
import org.codehaus.commons.compiler.util.resource.FileResource;
import org.codehaus.commons.compiler.util.resource.Resource;
import org.codehaus.commons.compiler.util.resource.ResourceCreator;
import org.codehaus.commons.compiler.util.resource.ResourceFinder;
import org.codehaus.commons.nullanalysis.Nullable;

public abstract class ICompiler {
    @Nullable
    public static final File NO_DESTINATION_DIRECTORY = null;
    @Nullable
    public static final ResourceFinder FIND_NEXT_TO_SOURCE_FILE = null;
    @Nullable
    public static final ResourceCreator CREATE_NEXT_TO_SOURCE_FILE = null;
    @Nullable
    private File destinationDirectory;
    private boolean rebuild;

    public abstract void setEncoding(@Nullable Charset var1);

    public abstract void setDebugLines(boolean var1);

    public abstract void setDebugVars(boolean var1);

    public abstract void setDebugSource(boolean var1);

    public abstract void setSourcePath(File[] var1);

    public abstract void setBootClassPath(File[] var1);

    public abstract void setExtensionDirectories(File[] var1);

    public abstract void setClassPath(File[] var1);

    public final void setDestinationDirectory(@Nullable File destinationDirectory) {
        this.destinationDirectory = destinationDirectory;
        this.updateDestinationDirectory();
    }

    public abstract void setVerbose(boolean var1);

    public final void setRebuild(boolean value) {
        this.rebuild = value;
        this.updateDestinationDirectory();
    }

    public abstract void setSourceFinder(ResourceFinder var1);

    public abstract void setClassFileCreator(@Nullable ResourceCreator var1);

    public final boolean compile(File[] sourceFiles) throws CompileException, IOException {
        Resource[] sourceFileResources = new Resource[sourceFiles.length];
        for (int i = 0; i < sourceFiles.length; ++i) {
            sourceFileResources[i] = new FileResource(sourceFiles[i]);
        }
        this.compile(sourceFileResources);
        return true;
    }

    public abstract void setClassFileFinder(@Nullable ResourceFinder var1);

    public void setCharacterEncoding(@Nullable String characterEncoding) {
        this.setEncoding(characterEncoding == null ? null : Charset.forName(characterEncoding));
    }

    public abstract void compile(Resource[] var1) throws CompileException, IOException;

    public abstract void setCompileErrorHandler(@Nullable ErrorHandler var1);

    public abstract void setWarningHandler(WarningHandler var1);

    private void updateDestinationDirectory() {
        File dd = this.destinationDirectory;
        this.setClassFileCreator(dd == NO_DESTINATION_DIRECTORY ? CREATE_NEXT_TO_SOURCE_FILE : new DirectoryResourceCreator(dd));
        this.setClassFileFinder(this.rebuild ? ResourceFinder.EMPTY_RESOURCE_FINDER : (dd == NO_DESTINATION_DIRECTORY ? FIND_NEXT_TO_SOURCE_FILE : new DirectoryResourceFinder(dd)));
    }
}

