/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.fed;

import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRequest;
import org.apache.sysds.runtime.controlprogram.federated.FederationMap;
import org.apache.sysds.runtime.controlprogram.federated.FederationUtils;
import org.apache.sysds.runtime.functionobjects.OffsetColumnIndex;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.fed.BinaryFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.FEDInstruction;
import org.apache.sysds.runtime.matrix.operators.Operator;
import org.apache.sysds.runtime.matrix.operators.ReorgOperator;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.runtime.meta.MatrixCharacteristics;
import org.apache.sysds.runtime.meta.MetaDataUtils;

public class AppendFEDInstruction
extends BinaryFEDInstruction {
    protected boolean _cbind;

    protected AppendFEDInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, boolean cbind, String opcode, String istr) {
        super(FEDInstruction.FEDType.Append, op, in1, in2, out, opcode, istr);
        this._cbind = cbind;
    }

    public static AppendFEDInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        InstructionUtils.checkNumFields(parts, 6, 5, 4);
        String opcode = parts[0];
        CPOperand in1 = new CPOperand(parts[1]);
        CPOperand in2 = new CPOperand(parts[2]);
        CPOperand out = new CPOperand(parts[parts.length - 2]);
        boolean cbind = Boolean.parseBoolean(parts[parts.length - 1]);
        ReorgOperator op = new ReorgOperator(OffsetColumnIndex.getOffsetColumnIndexFnObject(-1));
        return new AppendFEDInstruction(op, in1, in2, out, cbind, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        MatrixObject mo1 = ec.getMatrixObject(this.input1.getName());
        MatrixObject mo2 = ec.getMatrixObject(this.input2.getName());
        DataCharacteristics dc1 = mo1.getDataCharacteristics();
        DataCharacteristics dc2 = mo2.getDataCharacteristics();
        if (this._cbind && mo1.getNumRows() != mo2.getNumRows()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Append-cbind is not possible for federated input matrices ");
            sb.append(this.input1.getName()).append(" and ").append(this.input2.getName());
            sb.append(" with different number of rows: ");
            sb.append(mo1.getNumRows()).append(" vs ").append(mo2.getNumRows());
            throw new DMLRuntimeException(sb.toString());
        }
        if (!this._cbind && mo1.getNumColumns() != mo2.getNumColumns()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Append-rbind is not possible for federated input matrices ");
            sb.append(this.input1.getName()).append(" and ").append(this.input2.getName());
            sb.append(" with different number of columns: ");
            sb.append(mo1.getNumColumns()).append(" vs ").append(mo2.getNumColumns());
            throw new DMLRuntimeException(sb.toString());
        }
        MatrixObject out = ec.getMatrixObject(this.output);
        MetaDataUtils.updateAppendDataCharacteristics(dc1, dc2, out.getDataCharacteristics(), this._cbind);
        if (mo1.isFederated() && mo2.isFederated() && mo1.getFedMapping().getType() == mo2.getFedMapping().getType() && !mo1.getFedMapping().isAligned(mo2.getFedMapping(), FederationMap.AlignType.valueOf(mo1.getFedMapping().getType().name()))) {
            long id = FederationUtils.getNextFedDataID();
            long roff = this._cbind ? 0L : dc1.getRows();
            long coff = this._cbind ? dc1.getCols() : 0L;
            out.setFedMapping(mo1.getFedMapping().identCopy(this.getTID(), id).bind(roff, coff, mo2.getFedMapping().identCopy(this.getTID(), id)));
        } else if ((mo1.isFederated(FederationMap.FType.ROW) || mo2.isFederated(FederationMap.FType.ROW)) && this._cbind) {
            long[] lArray;
            boolean isFed = mo1.isFederated(FederationMap.FType.ROW) && mo1.isFederatedExcept(FederationMap.FType.BROADCAST);
            boolean isSpark = this.instString.contains("SPARK");
            MatrixObject moFed = isFed ? mo1 : mo2;
            MatrixObject moLoc = isFed ? mo2 : mo1;
            FederatedRequest[] fr1 = moFed.getFedMapping().broadcastSliced(moLoc, false);
            CPOperand[] cPOperandArray = new CPOperand[]{this.input1, this.input2};
            if (isFed) {
                long[] lArray2 = new long[2];
                lArray2[0] = moFed.getFedMapping().getID();
                lArray = lArray2;
                lArray2[1] = fr1[0].getID();
            } else {
                long[] lArray3 = new long[2];
                lArray3[0] = fr1[0].getID();
                lArray = lArray3;
                lArray3[1] = moFed.getFedMapping().getID();
            }
            FederatedRequest fr2 = FederationUtils.callInstruction(this.instString, this.output, cPOperandArray, lArray);
            if (isSpark) {
                FederatedRequest tmp = new FederatedRequest(FederatedRequest.RequestType.PUT_VAR, fr2.getID(), new Object[]{new MatrixCharacteristics(-1L, -1L), mo1.getDataType()});
                moFed.getFedMapping().execute(this.getTID(), true, fr1, new FederatedRequest[]{tmp, fr2});
            } else {
                moFed.getFedMapping().execute(this.getTID(), true, fr1, new FederatedRequest[]{fr2});
            }
            out.setFedMapping(moFed.getFedMapping().copyWithNewID(fr2.getID(), out.getNumColumns()));
        } else if ((mo1.isFederated(FederationMap.FType.ROW) || mo2.isFederated(FederationMap.FType.ROW)) && !this._cbind) {
            long id = FederationUtils.getNextFedDataID();
            long roff = this._cbind ? 0L : dc1.getRows();
            long coff = this._cbind ? dc1.getCols() : 0L;
            FederationMap fed1 = mo1.isFederated(FederationMap.FType.ROW) ? mo1.getFedMapping() : FederationUtils.federateLocalData(mo1);
            FederationMap fed2 = mo2.isFederated(FederationMap.FType.ROW) ? mo2.getFedMapping() : FederationUtils.federateLocalData(mo2);
            out.setFedMapping(fed1.identCopy(this.getTID(), id).bind(roff, coff, fed2.identCopy(this.getTID(), id)));
        } else {
            throw new DMLRuntimeException("Unsupported federated append:  input 1 FType is " + (mo1.isFederated() ? mo1.getFedMapping().getType().name() : "LOCAL") + ", input 2 FType is " + (mo2.isFederated() ? mo2.getFedMapping().getType().name() : "LOCAL") + ", and column bind is " + this._cbind);
        }
    }
}

