/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.lops.Lop;
import org.apache.sysds.parser.DataIdentifier;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.matrix.operators.Operator;
import org.apache.sysds.runtime.privacy.PrivacyConstraint;

public abstract class Instruction {
    private static final Log LOG = LogFactory.getLog((String)Instruction.class.getName());
    protected final Operator _optr;
    public static final String OPERAND_DELIM = "\u00b0";
    public static final String DATATYPE_PREFIX = "\u00b7";
    public static final String VALUETYPE_PREFIX = "\u00b7";
    public static final String LITERAL_PREFIX = "\u00b7";
    public static final String INSTRUCTION_DELIM = "\u2021";
    public static final String SP_INST_PREFIX = "sp_";
    public static final String GPU_INST_PREFIX = "gpu_";
    public static final String FEDERATED_INST_PREFIX = "fed_";
    protected String instString = null;
    protected String instOpcode = null;
    private String extendedOpcode = null;
    private long instID = -1L;
    protected String filename = null;
    protected int beginLine = -1;
    protected int endLine = -1;
    protected int beginCol = -1;
    protected int endCol = -1;
    protected PrivacyConstraint privacyConstraint = null;

    protected Instruction(Operator _optr) {
        this._optr = _optr;
    }

    public String getFilename() {
        return this.filename;
    }

    public int getBeginLine() {
        return this.beginLine;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getBeginColumn() {
        return this.beginCol;
    }

    public int getEndColumn() {
        return this.endCol;
    }

    public abstract IType getType();

    public void setLocation(String filename, int beginLine, int endLine, int beginCol, int endCol) {
        this.filename = filename;
        this.beginLine = beginLine;
        this.endLine = endLine;
        this.beginCol = beginCol;
        this.endCol = endCol;
    }

    public void setLocation(Lop lop) {
        if (lop != null) {
            this.filename = lop.getFilename();
            this.beginLine = lop._beginLine;
            this.endLine = lop._endLine;
            this.beginCol = lop._beginColumn;
            this.endCol = lop._endColumn;
        }
    }

    public void setLocation(DataIdentifier id) {
        if (id != null) {
            this.filename = id.getFilename();
            this.beginLine = id.getBeginLine();
            this.endLine = id.getEndLine();
            this.beginCol = id.getBeginColumn();
            this.endCol = id.getEndColumn();
        }
    }

    public void setLocation(Instruction oldInst) {
        if (oldInst != null) {
            this.filename = oldInst.filename;
            this.beginLine = oldInst.beginLine;
            this.endLine = oldInst.endLine;
            this.beginCol = oldInst.beginCol;
            this.endCol = oldInst.endCol;
        }
    }

    public void setPrivacyConstraint(Lop lop) {
        this.privacyConstraint = lop.getPrivacyConstraint();
    }

    public void setPrivacyConstraint(PrivacyConstraint pc) {
        this.privacyConstraint = pc;
    }

    public PrivacyConstraint getPrivacyConstraint() {
        return this.privacyConstraint;
    }

    public Operator getOperator() {
        return this._optr;
    }

    public int getLineNum() {
        return this.beginLine;
    }

    public void setInstID(long id) {
        this.instID = id;
    }

    public long getInstID() {
        return this.instID;
    }

    public void printMe() {
        LOG.debug((Object)this.instString);
    }

    public String toString() {
        return this.instString;
    }

    public String getInstructionString() {
        return this.instString;
    }

    public String getGraphString() {
        return null;
    }

    public String getOpcode() {
        return this.instOpcode;
    }

    public String getExtendedOpcode() {
        if (this.extendedOpcode == null) {
            this.extendedOpcode = this.getType() == IType.SPARK ? SP_INST_PREFIX + this.getOpcode() : (this.getType() == IType.GPU ? GPU_INST_PREFIX + this.getOpcode() : (this.getType() == IType.FEDERATED ? FEDERATED_INST_PREFIX + this.getOpcode() : this.getOpcode()));
        }
        return this.extendedOpcode;
    }

    public boolean requiresLabelUpdate() {
        return this.instString.contains("\u00b6");
    }

    public void updateInstructionThreadID(String pattern, String replace) {
    }

    public Instruction preprocessInstruction(ExecutionContext ec) {
        if (DMLScript.LINEAGE) {
            ec.traceLineage(this);
        }
        return this;
    }

    public abstract void processInstruction(ExecutionContext var1);

    public void postprocessInstruction(ExecutionContext ec) {
    }

    public static enum IType {
        CONTROL_PROGRAM,
        BREAKPOINT,
        SPARK,
        GPU,
        FEDERATED;

    }
}

