/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.sort;

import java.io.IOException;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.instructions.mr.CombineUnaryInstruction;
import org.apache.sysml.runtime.matrix.data.Converter;
import org.apache.sysml.runtime.matrix.data.MatrixCell;
import org.apache.sysml.runtime.matrix.data.Pair;
import org.apache.sysml.runtime.matrix.mapred.MRJobConfiguration;

public class ValueSortMapper<KIN extends WritableComparable, VIN extends Writable, KOUT extends WritableComparable, VOUT extends Writable>
extends MapReduceBase
implements Mapper<KIN, VIN, KOUT, VOUT> {
    private int brlen;
    private int bclen;
    private CombineUnaryInstruction combineInstruction = null;
    private Converter<KIN, VIN, KOUT, VOUT> inputConverter;
    private IntWritable one = new IntWritable(1);
    private DoubleWritable combinedKey = new DoubleWritable();

    public void map(KIN key, VIN value, OutputCollector<KOUT, VOUT> out, Reporter reporter) throws IOException {
        this.inputConverter.convert(key, value);
        while (this.inputConverter.hasNext()) {
            Pair<KOUT, VOUT> pair = this.inputConverter.next();
            if (this.combineInstruction == null) {
                out.collect((Object)((WritableComparable)pair.getKey()), (Object)((Writable)pair.getValue()));
                continue;
            }
            this.processCombineUnaryInstruction(pair, out);
        }
    }

    private void processCombineUnaryInstruction(Pair pair, OutputCollector<KOUT, VOUT> out) throws IOException {
        this.combinedKey.set(((MatrixCell)pair.getValue()).getValue());
        out.collect((Object)this.combinedKey, (Object)this.one);
    }

    public void configure(JobConf job) {
        try {
            this.brlen = MRJobConfiguration.getNumRowsPerBlock(job, (byte)0);
            this.bclen = MRJobConfiguration.getNumColumnsPerBlock(job, (byte)0);
            String str = job.get("combine.instruction", null);
            if (str != null && !str.isEmpty() && !"null".equals(str)) {
                this.combineInstruction = CombineUnaryInstruction.parseInstruction(str);
            }
            this.inputConverter = MRJobConfiguration.getInputConverter(job, (byte)0);
            this.inputConverter.setBlockSize(this.brlen, this.bclen);
        }
        catch (DMLRuntimeException e) {
            throw new RuntimeException(e);
        }
    }
}

